/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class MasterMain {
    private static final Log LOG = LogFactory.getLog(MasterMain.class);

    public static void main(String[] args) throws InterruptedException {
        AMRMClient rmClient = AMRMClient.createAMRMClient();
        rmClient.init(new Configuration());
        rmClient.start();
        NMClient client = NMClient.createNMClient();
        try {
            AMRMClient.ContainerRequest req = new AMRMClient.ContainerRequest(Resource.newInstance((int)1024, (int)1), new String[]{"node1"}, new String[]{"rack1"}, Priority.newInstance((int)10));
            rmClient.addContainerRequest(req);
            while (true) {
                AllocateResponse response = rmClient.allocate(1.0f);
                for (Container container : response.getAllocatedContainers()) {
                    ArrayList commands = new ArrayList();
                    ContainerLaunchContext containerLaunchContext = ContainerLaunchContext.newInstance(new HashMap(), new HashMap(), commands, null, null, null);
                    client.startContainer(container, containerLaunchContext);
                }
                LOG.info((Object)("info:" + response));
                Thread.sleep(1000L);
            }
        }
        catch (YarnException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

