/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVInferSchema;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SchemaOfCsv$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(csv[, options]) - Returns schema in the DDL format of CSV string.", examples="\n    Examples:\n      > SELECT _FUNC_('1,abc');\n       STRUCT<`_c0`: INT, `_c1`: STRING>\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001\u0002\u0010 \u00012B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\"Aa\t\u0001BK\u0002\u0013\u0005q\t\u0003\u0005W\u0001\tE\t\u0015!\u0003I\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u00159\u0006\u0001\"\u0001]\u0011\u00159\u0006\u0001\"\u0001_\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015I\u0007\u0001\"\u0011k\u0011!q\u0007\u0001#b\u0001\n\u0013y\u0007\"B>\u0001\t\u0003b\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003;\u0001A\u0011IA\u0010\u0011%\t\t\u0003AA\u0001\n\u0003\t\u0019\u0003C\u0005\u0002*\u0001\t\n\u0011\"\u0001\u0002,!I\u0011\u0011\t\u0001\u0012\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u000f\u0002\u0011\u0011!C!\u0003\u0013B\u0011\"!\u0017\u0001\u0003\u0003%\t!a\u0017\t\u0013\u0005\r\u0004!!A\u0005\u0002\u0005\u0015\u0004\"CA6\u0001\u0005\u0005I\u0011IA7\u0011%\tY\bAA\u0001\n\u0003\ti\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\u001eI\u0011\u0011U\u0010\u0002\u0002#\u0005\u00111\u0015\u0004\t=}\t\t\u0011#\u0001\u0002&\"1q\u000b\u0007C\u0001\u0003gC\u0011\"!.\u0019\u0003\u0003%)%a.\t\u0013\u0005e\u0006$!A\u0005\u0002\u0006m\u0006\"CAa1\u0005\u0005I\u0011QAb\u0011%\t)\u000eGA\u0001\n\u0013\t9NA\u0006TG\",W.Y(g\u0007N4(B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001i\u0013gN\u001f\u0011\u00059zS\"A\u0010\n\u0005Az\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I*T\"A\u001a\u000b\u0005Qz\u0012aB2pI\u0016<WM\\\u0005\u0003mM\u0012qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\b!J|G-^2u!\tAd(\u0003\u0002@s\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\t!\t\u0005\u0002/\u0007&\u0011Ai\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%A\u0004paRLwN\\:\u0016\u0003!\u0003B!\u0013)T':\u0011!J\u0014\t\u0003\u0017fj\u0011\u0001\u0014\u0006\u0003\u001b.\na\u0001\u0010:p_Rt\u0014BA(:\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011K\u0015\u0002\u0004\u001b\u0006\u0004(BA(:!\tIE+\u0003\u0002V%\n11\u000b\u001e:j]\u001e\f\u0001b\u001c9uS>t7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007eS6\f\u0005\u0002/\u0001!)\u0001)\u0002a\u0001\u0005\")a)\u0002a\u0001\u0011R\u0011\u0011,\u0018\u0005\u0006\u0001\u001a\u0001\rA\u0011\u000b\u00043~\u0003\u0007\"\u0002!\b\u0001\u0004\u0011\u0005\"\u0002$\b\u0001\u0004\u0011\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ\u0012\u0002\u000bQL\b/Z:\n\u0005!,'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\u0012a\u001b\t\u0003q1L!!\\\u001d\u0003\u000f\t{w\u000e\\3b]\u0006\u00191m\u001d<\u0016\u0003A\u0004\"!];\u000e\u0003IT!AZ:\u000b\u0005Q,\u0013AB;og\u00064W-\u0003\u0002we\nQQ\u000b\u0016$9'R\u0014\u0018N\\4)\u0005)A\bC\u0001\u001dz\u0013\tQ\u0018HA\u0005ue\u0006t7/[3oi\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003\t\u0013\u0001C1oC2L8/[:\n\u0007\u0005\u0015qPA\bUsB,7\t[3dWJ+7/\u001e7u\u0003\u0011)g/\u00197\u0015\t\u0005-\u0011\u0011\u0003\t\u0004q\u00055\u0011bAA\bs\t\u0019\u0011I\\=\t\u0013\u0005MA\u0002%AA\u0002\u0005U\u0011!\u0001<\u0011\t\u0005]\u0011\u0011D\u0007\u0002C%\u0019\u00111D\u0011\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u000baJ,G\u000f^=OC6,W#A*\u0002\t\r|\u0007/\u001f\u000b\u00063\u0006\u0015\u0012q\u0005\u0005\b\u0001:\u0001\n\u00111\u0001C\u0011\u001d1e\u0002%AA\u0002!\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002.)\u001a!)a\f,\u0005\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000f:\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\t)DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002F)\u001a\u0001*a\f\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\t1\fgn\u001a\u0006\u0003\u0003+\nAA[1wC&\u0019Q+a\u0014\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0003c\u0001\u001d\u0002`%\u0019\u0011\u0011M\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005-\u0011q\r\u0005\n\u0003S\u001a\u0012\u0011!a\u0001\u0003;\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA8!\u0019\t\t(a\u001e\u0002\f5\u0011\u00111\u000f\u0006\u0004\u0003kJ\u0014AC2pY2,7\r^5p]&!\u0011\u0011PA:\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007-\fy\bC\u0005\u0002jU\t\t\u00111\u0001\u0002\f\u00051Q-];bYN$2a[AC\u0011%\tIGFA\u0001\u0002\u0004\tY\u0001K\b\u0001\u0003\u0013\u000by)!%\u0002\u0016\u0006]\u00151TAO!\rq\u00131R\u0005\u0004\u0003\u001b{\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003'\u000b\u0001j\u0018$V\u001d\u000e{\u0006fY:w72\u0002s\u000e\u001d;j_:\u001cX,\u000b\u0011.AI+G/\u001e:og\u0002\u001a8\r[3nC\u0002Jg\u000e\t;iK\u0002\"E\t\u0014\u0011g_Jl\u0017\r\u001e\u0011pM\u0002\u001a5K\u0016\u0011tiJLgn\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!'\u00025*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u0017bE\u000e<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011T)J+6\t\u0016\u001fa?\u000e\u0004\u0004M\u000f\u0011J\u001dRc\u0003\u0005Y0dc\u0001T\u0004e\u0015+S\u0013:;eH\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ty*A\u00034]Ar\u0003'A\u0006TG\",W.Y(g\u0007N4\bC\u0001\u0018\u0019'\u0011A\u0012qU\u001f\u0011\u000f\u0005%\u0016q\u0016\"I36\u0011\u00111\u0016\u0006\u0004\u0003[K\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003c\u000bYKA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0013\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000be\u000bi,a0\t\u000b\u0001[\u0002\u0019\u0001\"\t\u000b\u0019[\u0002\u0019\u0001%\u0002\u000fUt\u0017\r\u001d9msR!\u0011QYAi!\u0015A\u0014qYAf\u0013\r\tI-\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\niM\u0011%\n\u0007\u0005=\u0017H\u0001\u0004UkBdWM\r\u0005\t\u0003'd\u0012\u0011!a\u00013\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00033\u0004B!!\u0014\u0002\\&!\u0011Q\\A(\u0005\u0019y%M[3di\u0002")
public class SchemaOfCsv
extends UnaryExpression
implements CodegenFallback,
scala.Serializable {
    private transient UTF8String csv;
    private final Expression child;
    private final Map<String, String> options;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Map<String, String>>> unapply(SchemaOfCsv schemaOfCsv) {
        return SchemaOfCsv$.MODULE$.unapply(schemaOfCsv);
    }

    public static Function1<Tuple2<Expression, Map<String, String>>, SchemaOfCsv> tupled() {
        return SchemaOfCsv$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Map<String, String>, SchemaOfCsv>> curried() {
        return SchemaOfCsv$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private UTF8String csv$lzycompute() {
        SchemaOfCsv schemaOfCsv = this;
        synchronized (schemaOfCsv) {
            if (!this.bitmap$trans$0) {
                this.csv = (UTF8String)this.child().eval(this.child().eval$default$1());
                this.bitmap$trans$0 = true;
            }
        }
        return this.csv;
    }

    private UTF8String csv() {
        return !this.bitmap$trans$0 ? this.csv$lzycompute() : this.csv;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.child().foldable() && this.csv() != null ? super.checkInputDataTypes() : new TypeCheckResult.TypeCheckFailure(new StringBuilder(81).append("The input csv should be a foldable string expression and not null; ").append("however, got ").append(this.child().sql()).append(".").toString());
    }

    @Override
    public Object eval(InternalRow v) {
        CSVOptions parsedOptions = new CSVOptions(this.options(), true, "UTC");
        CsvParser parser = new CsvParser(parsedOptions.asParserSettings());
        String[] row = parser.parseLine(this.csv().toString());
        Predef$.MODULE$.assert(row != null, (Function0 & Serializable & scala.Serializable)() -> "Parsed CSV record should not be null.");
        String[] header = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int index = tuple2._2$mcI$sp();
            String string = new StringBuilder(2).append("_c").append(index).toString();
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
        CSVInferSchema inferSchema = new CSVInferSchema(parsedOptions);
        DataType[] fieldTypes = inferSchema.inferRowType(startType, row);
        StructType st = new StructType(inferSchema.toStructFields(fieldTypes, header));
        return UTF8String.fromString((String)st.sql());
    }

    @Override
    public String prettyName() {
        return "schema_of_csv";
    }

    public SchemaOfCsv copy(Expression child, Map<String, String> options) {
        return new SchemaOfCsv(child, options);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    @Override
    public String productPrefix() {
        return "SchemaOfCsv";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Map<String, String> map;
        int n = x$1;
        switch (n) {
            case 0: {
                map = this.child();
                break;
            }
            case 1: {
                map = this.options();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return map;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchemaOfCsv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchemaOfCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchemaOfCsv schemaOfCsv = (SchemaOfCsv)x$1;
        Expression expression = this.child();
        Expression expression2 = schemaOfCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = schemaOfCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!schemaOfCsv.canEqual(this)) return false;
        return true;
    }

    public SchemaOfCsv(Expression child, Map<String, String> options) {
        this.child = child;
        this.options = options;
        CodegenFallback.$init$(this);
    }

    public SchemaOfCsv(Expression child) {
        this(child, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public SchemaOfCsv(Expression child, Expression options) {
        this(child, ExprUtils$.MODULE$.convertToMapData(options));
    }
}

