/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.DatabaseAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.PartitionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015b\u0001\u0002'N\u0001iC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005W\")!\u000f\u0001C\u0001g\u001a!q\u000f\u0001\u0003y\u0011!IHA!a\u0001\n\u0003Q\b\u0002\u0003@\u0005\u0005\u0003\u0007I\u0011A@\t\u0013\u0005-AA!A!B\u0013Y\bB\u0002:\u0005\t\u0003\ti\u0001C\u0005\u0002\u0016\u0011\u0011\r\u0011\"\u0001\u0002\u0018!A\u0011Q\b\u0003!\u0002\u0013\tIB\u0002\u0004\u0002@\u0001!\u0011\u0011\t\u0005\u000b\u0003\u0007Z!\u00111A\u0005\u0002\u0005\u0015\u0003BCA'\u0017\t\u0005\r\u0011\"\u0001\u0002P!Q\u00111K\u0006\u0003\u0002\u0003\u0006K!a\u0012\t\rI\\A\u0011AA+\u0011%\tYf\u0003b\u0001\n\u0003\ti\u0006\u0003\u0005\u0002x-\u0001\u000b\u0011BA0\u0011%\tIh\u0003b\u0001\n\u0003\tY\b\u0003\u0005\u0002\u0006.\u0001\u000b\u0011BA?\u0011!q\u0005A1A\u0005\n\u0005\u001d\u0005\u0002CAF\u0001\u0001\u0006I!!#\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBAT\u0001\u0011%\u0011\u0011\u0016\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\ty\r\u0001C\u0005\u0003#Dq!!>\u0001\t\u0013\t9\u0010C\u0004\u0002P\u0002!I!a?\t\u000f\t\r\u0001\u0001\"\u0011\u0003\u0006!9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\u000f\u0001\u0011\u0005#q\u0004\u0005\b\u0005G\u0001A\u0011\tB\u0013\u0011\u001d\u0011I\u0003\u0001C!\u0005WAqAa\f\u0001\t\u0003\u0012\t\u0004C\u0004\u00030\u0001!\tE!\u000e\t\u000f\tm\u0002\u0001\"\u0011\u0003>!9!\u0011\t\u0001\u0005B\t\r\u0003b\u0002B&\u0001\u0011\u0005#Q\n\u0005\b\u00053\u0002A\u0011\tB.\u0011\u001d\u00119\u0007\u0001C!\u0005SBqA!\u001c\u0001\t\u0003\u0012y\u0007C\u0004\u0003\u0006\u0002!\tEa\"\t\u000f\tu\u0005\u0001\"\u0011\u0003 \"9!Q\u0015\u0001\u0005B\t\u001d\u0006b\u0002BX\u0001\u0011\u0005#\u0011\u0017\u0005\b\u0005o\u0003A\u0011\tB]\u0011\u001d\u00119\f\u0001C!\u0005{CqAa1\u0001\t\u0003\u0012)\rC\u0004\u0003L\u0002!\tE!4\t\u000f\t}\u0007\u0001\"\u0011\u0003b\"9!Q\u001f\u0001\u0005B\t]\bbBB\b\u0001\u0011\u00053\u0011\u0003\u0005\b\u0007;\u0001A\u0011IB\u0010\u0011\u001d\u0019y\u0003\u0001C!\u0007cAqaa\u0010\u0001\t\u0003\u001a\t\u0005C\u0004\u0004L\u0001!\te!\u0014\t\u000f\r]\u0003\u0001\"\u0011\u0004Z!911\r\u0001\u0005B\r\u0015\u0004\"CB8\u0001E\u0005I\u0011AB9\u0011\u001d\u00199\t\u0001C!\u0007\u0013C\u0011ba%\u0001#\u0003%\ta!\u001d\t\u000f\rU\u0005\u0001\"\u0011\u0004\u0018\"911\u0017\u0001\u0005B\rU\u0006bBBj\u0001\u0011\u00053Q\u001b\u0005\b\u0007;\u0004A\u0011IBp\u0011\u001d\u00199\u000f\u0001C!\u0007SDqaa<\u0001\t\u0003\u001a\t\u0010C\u0004\u0004z\u0002!\tea?\t\u000f\u0011\u0005\u0001\u0001\"\u0011\u0005\u0004!9A\u0011\u0002\u0001\u0005B\u0011-q!\u0003C\t\u001b\u0006\u0005\t\u0012\u0001C\n\r!aU*!A\t\u0002\u0011U\u0001B\u0002:I\t\u0003!9\u0002C\u0005\u0005\u001a!\u000b\n\u0011\"\u0001\u0005\u001c!IAq\u0004%\u0012\u0002\u0013\u0005A\u0011\u0005\u0002\u0010\u0013:lU-\\8ss\u000e\u000bG/\u00197pO*\u0011ajT\u0001\bG\u0006$\u0018\r\\8h\u0015\t\u0001\u0016+\u0001\u0005dCR\fG._:u\u0015\t\u00116+A\u0002tc2T!\u0001V+\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y;\u0016AB1qC\u000eDWMC\u0001Y\u0003\ry'oZ\u0002\u0001'\r\u00011,\u0019\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001cW\"A'\n\u0005\u0011l%aD#yi\u0016\u0014h.\u00197DCR\fGn\\4\u0002\t\r|gN\u001a\t\u0003O\"l\u0011aU\u0005\u0003SN\u0013\u0011b\u00159be.\u001cuN\u001c4\u0002\u0019!\fGm\\8q\u0007>tg-[4\u0011\u00051\u0004X\"A7\u000b\u0005\u0015t'BA8V\u0003\u0019A\u0017\rZ8pa&\u0011\u0011/\u001c\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\r!XO\u001e\t\u0003E\u0002Aq!Z\u0002\u0011\u0002\u0003\u0007a\rC\u0004k\u0007A\u0005\t\u0019A6\u0003\u0013Q\u000b'\r\\3EKN\u001c7C\u0001\u0003\\\u0003\u0015!\u0018M\u00197f+\u0005Y\bC\u00012}\u0013\tiXJ\u0001\u0007DCR\fGn\\4UC\ndW-A\u0005uC\ndWm\u0018\u0013fcR!\u0011\u0011AA\u0004!\ra\u00161A\u0005\u0004\u0003\u000bi&\u0001B+oSRD\u0001\"!\u0003\u0007\u0003\u0003\u0005\ra_\u0001\u0004q\u0012\n\u0014A\u0002;bE2,\u0007\u0005\u0006\u0003\u0002\u0010\u0005M\u0001cAA\t\t5\t\u0001\u0001C\u0003z\u0011\u0001\u000710\u0001\u0006qCJ$\u0018\u000e^5p]N,\"!!\u0007\u0011\u0011\u0005m\u0011QEA\u0015\u0003oi!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019#X\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0014\u0003;\u0011q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002,\u0005Ebb\u00012\u0002.%\u0019\u0011qF'\u0002\u0019\r\u000bG/\u00197pORK\b/Z:\n\t\u0005M\u0012Q\u0007\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7MC\u0002\u000205\u00032AYA\u001d\u0013\r\tY$\u0014\u0002\u0016\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a)beRLG/[8o\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0003\u0019\u0011\u000bG/\u00192bg\u0016$Um]2\u0014\u0005-Y\u0016A\u00013c+\t\t9\u0005E\u0002c\u0003\u0013J1!a\u0013N\u0005=\u0019\u0015\r^1m_\u001e$\u0015\r^1cCN,\u0017A\u00023c?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005E\u0003\"CA\u0005\u001b\u0005\u0005\t\u0019AA$\u0003\r!'\r\t\u000b\u0005\u0003/\nI\u0006E\u0002\u0002\u0012-Aq!a\u0011\u0010\u0001\u0004\t9%\u0001\u0004uC\ndWm]\u000b\u0003\u0003?\u0002\u0002\"a\u0007\u0002&\u0005\u0005\u0014q\u0002\t\u0005\u0003G\n\tH\u0004\u0003\u0002f\u00055\u0004cAA4;6\u0011\u0011\u0011\u000e\u0006\u0004\u0003WJ\u0016A\u0002\u001fs_>$h(C\u0002\u0002pu\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA:\u0003k\u0012aa\u0015;sS:<'bAA8;\u00069A/\u00192mKN\u0004\u0013!\u00034v]\u000e$\u0018n\u001c8t+\t\ti\b\u0005\u0005\u0002\u001c\u0005\u0015\u0012\u0011MA@!\r\u0011\u0017\u0011Q\u0005\u0004\u0003\u0007k%aD\"bi\u0006dwn\u001a$v]\u000e$\u0018n\u001c8\u0002\u0015\u0019,hn\u0019;j_:\u001c\b%\u0006\u0002\u0002\nBA\u00111DA\u0013\u0003C\n9&\u0001\u0005dCR\fGn\\4!\u0003=\u0001\u0018M\u001d;ji&|g.\u0012=jgR\u001cH\u0003CAI\u0003/\u000bI*a'\u0011\u0007q\u000b\u0019*C\u0002\u0002\u0016v\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002DY\u0001\r!!\u0019\t\re4\u0002\u0019AA1\u0011\u001d\tiJ\u0006a\u0001\u0003S\tAa\u001d9fG\u0006)\"/Z9vSJ,G+\u00192mK:{G/\u0012=jgR\u001cHCBA\u0001\u0003G\u000b)\u000bC\u0004\u0002D]\u0001\r!!\u0019\t\re<\u0002\u0019AA1\u0003Y\u0011X-];je\u0016\u0004\u0016M\u001d;ji&|gn]#ySN$H\u0003CA\u0001\u0003W\u000bi+a,\t\u000f\u0005\r\u0003\u00041\u0001\u0002b!1\u0011\u0010\u0007a\u0001\u0003CBq!!-\u0019\u0001\u0004\t\u0019,A\u0003ta\u0016\u001c7\u000f\u0005\u0004\u00026\u0006}\u0016\u0011\u0006\b\u0005\u0003o\u000bYL\u0004\u0003\u0002h\u0005e\u0016\"\u00010\n\u0007\u0005uV,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00171\u0019\u0002\u0004'\u0016\f(bAA_;\u0006I\"/Z9vSJ,\u0007+\u0019:uSRLwN\\:O_R,\u00050[:u)!\t\t!!3\u0002L\u00065\u0007bBA\"3\u0001\u0007\u0011\u0011\r\u0005\u0007sf\u0001\r!!\u0019\t\u000f\u0005E\u0016\u00041\u0001\u00024\u00061Bo\\\"bi\u0006dwn\u001a)beRLG/[8o'B,7-\u0006\u0002\u0002TB9A,!6\u0002Z\u0006e\u0017bAAl;\nIa)\u001e8di&|g.\r\t\u0005\u00037\f\tD\u0004\u0003\u0002^\u00065b\u0002BAp\u0003gtA!!9\u0002r:!\u00111]Ax\u001d\u0011\t)/!<\u000f\t\u0005\u001d\u00181\u001e\b\u0005\u0003O\nI/C\u0001Y\u0013\t1v+\u0003\u0002U+&\u0011!kU\u0005\u0003!FK!AT(\u0002/Q|7)\u0019;bY><\u0007+\u0019:uSRLwN\\*qK\u000e\u001cH\u0003BAZ\u0003sDq!!-\u001c\u0001\u0004\t\u0019\f\u0006\u0003\u0002~\u0006}\bCBA[\u0003\u007f\u000b9\u0004C\u0004\u0003\u0002q\u0001\r!!@\u0002\u000bA\f'\u000f^:\u0002\u001d\r\u0014X-\u0019;f\t\u0006$\u0018MY1tKR1\u0011\u0011\u0001B\u0004\u0005\u0017AqA!\u0003\u001e\u0001\u0004\t9%\u0001\u0007eE\u0012+g-\u001b8ji&|g\u000eC\u0004\u0003\u000eu\u0001\r!!%\u0002\u001d%<gn\u001c:f\u0013\u001a,\u00050[:ug\u0006aAM]8q\t\u0006$\u0018MY1tKRA\u0011\u0011\u0001B\n\u0005+\u0011I\u0002C\u0004\u0002Dy\u0001\r!!\u0019\t\u000f\t]a\u00041\u0001\u0002\u0012\u0006\t\u0012n\u001a8pe\u0016LeMT8u\u000bbL7\u000f^:\t\u000f\tma\u00041\u0001\u0002\u0012\u000691-Y:dC\u0012,\u0017!D1mi\u0016\u0014H)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002\u0002\t\u0005\u0002b\u0002B\u0005?\u0001\u0007\u0011qI\u0001\fO\u0016$H)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002H\t\u001d\u0002bBA\"A\u0001\u0007\u0011\u0011M\u0001\u000fI\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\u0011\t\tJ!\f\t\u000f\u0005\r\u0013\u00051\u0001\u0002b\u0005iA.[:u\t\u0006$\u0018MY1tKN$\"Aa\r\u0011\r\u0005U\u0016qXA1)\u0011\u0011\u0019Da\u000e\t\u000f\te2\u00051\u0001\u0002b\u00059\u0001/\u0019;uKJt\u0017AE:fi\u000e+(O]3oi\u0012\u000bG/\u00192bg\u0016$B!!\u0001\u0003@!9\u00111\t\u0013A\u0002\u0005\u0005\u0014aC2sK\u0006$X\rV1cY\u0016$b!!\u0001\u0003F\t%\u0003B\u0002B$K\u0001\u000710A\buC\ndW\rR3gS:LG/[8o\u0011\u001d\u0011i!\na\u0001\u0003#\u000b\u0011\u0002\u001a:paR\u000b'\r\\3\u0015\u0015\u0005\u0005!q\nB)\u0005'\u0012)\u0006C\u0004\u0002D\u0019\u0002\r!!\u0019\t\re4\u0003\u0019AA1\u0011\u001d\u00119B\na\u0001\u0003#CqAa\u0016'\u0001\u0004\t\t*A\u0003qkJ<W-A\u0006sK:\fW.\u001a+bE2,G\u0003CA\u0001\u0005;\u0012yFa\u0019\t\u000f\u0005\rs\u00051\u0001\u0002b!9!\u0011M\u0014A\u0002\u0005\u0005\u0014aB8mI:\u000bW.\u001a\u0005\b\u0005K:\u0003\u0019AA1\u0003\u001dqWm\u001e(b[\u0016\f!\"\u00197uKJ$\u0016M\u00197f)\u0011\t\tAa\u001b\t\r\t\u001d\u0003\u00061\u0001|\u0003Q\tG\u000e^3s)\u0006\u0014G.\u001a#bi\u0006\u001c6\r[3nCRA\u0011\u0011\u0001B9\u0005g\u0012)\bC\u0004\u0002D%\u0002\r!!\u0019\t\reL\u0003\u0019AA1\u0011\u001d\u00119(\u000ba\u0001\u0005s\nQB\\3x\t\u0006$\u0018mU2iK6\f\u0007\u0003\u0002B>\u0005\u0003k!A! \u000b\u0007\t}\u0014+A\u0003usB,7/\u0003\u0003\u0003\u0004\nu$AC*ueV\u001cG\u000fV=qK\u0006y\u0011\r\u001c;feR\u000b'\r\\3Ti\u0006$8\u000f\u0006\u0005\u0002\u0002\t%%1\u0012BG\u0011\u001d\t\u0019E\u000ba\u0001\u0003CBa!\u001f\u0016A\u0002\u0005\u0005\u0004b\u0002BHU\u0001\u0007!\u0011S\u0001\u0006gR\fGo\u001d\t\u00069\nM%qS\u0005\u0004\u0005+k&AB(qi&|g\u000eE\u0002c\u00053K1Aa'N\u0005E\u0019\u0015\r^1m_\u001e\u001cF/\u0019;jgRL7m]\u0001\tO\u0016$H+\u00192mKR)1P!)\u0003$\"9\u00111I\u0016A\u0002\u0005\u0005\u0004BB=,\u0001\u0004\t\t'A\bhKR$\u0016M\u00197fg\nKh*Y7f)\u0019\u0011IKa+\u0003.B)\u0011QWA`w\"9\u00111\t\u0017A\u0002\u0005\u0005\u0004bBA.Y\u0001\u0007!1G\u0001\fi\u0006\u0014G.Z#ySN$8\u000f\u0006\u0004\u0002\u0012\nM&Q\u0017\u0005\b\u0003\u0007j\u0003\u0019AA1\u0011\u0019IX\u00061\u0001\u0002b\u0005QA.[:u)\u0006\u0014G.Z:\u0015\t\tM\"1\u0018\u0005\b\u0003\u0007r\u0003\u0019AA1)\u0019\u0011\u0019Da0\u0003B\"9\u00111I\u0018A\u0002\u0005\u0005\u0004b\u0002B\u001d_\u0001\u0007\u0011\u0011M\u0001\nY&\u001cHOV5foN$bAa\r\u0003H\n%\u0007bBA\"a\u0001\u0007\u0011\u0011\r\u0005\b\u0005s\u0001\u0004\u0019AA1\u0003%aw.\u00193UC\ndW\r\u0006\u0007\u0002\u0002\t='\u0011\u001bBj\u0005/\u0014Y\u000eC\u0004\u0002DE\u0002\r!!\u0019\t\re\f\u0004\u0019AA1\u0011\u001d\u0011).\ra\u0001\u0003C\n\u0001\u0002\\8bIB\u000bG\u000f\u001b\u0005\b\u00053\f\u0004\u0019AAI\u0003-I7o\u0014<fe^\u0014\u0018\u000e^3\t\u000f\tu\u0017\u00071\u0001\u0002\u0012\u0006Q\u0011n]*sG2{7-\u00197\u0002\u001b1|\u0017\r\u001a)beRLG/[8o)A\t\tAa9\u0003f\n\u001d(\u0011\u001eBw\u0005_\u0014\u0019\u0010C\u0004\u0002DI\u0002\r!!\u0019\t\re\u0014\u0004\u0019AA1\u0011\u001d\u0011)N\ra\u0001\u0003CBqAa;3\u0001\u0004\tI#A\u0005qCJ$\u0018\u000e^5p]\"9!\u0011\u001c\u001aA\u0002\u0005E\u0005b\u0002Bye\u0001\u0007\u0011\u0011S\u0001\u0012S:DWM]5u)\u0006\u0014G.Z*qK\u000e\u001c\bb\u0002Boe\u0001\u0007\u0011\u0011S\u0001\u0016Y>\fG\rR=oC6L7\rU1si&$\u0018n\u001c8t)9\t\tA!?\u0003|\nu(q`B\u0001\u0007\u000bAq!a\u00114\u0001\u0004\t\t\u0007\u0003\u0004zg\u0001\u0007\u0011\u0011\r\u0005\b\u0005+\u001c\u0004\u0019AA1\u0011\u001d\u0011Yo\ra\u0001\u0003SAqaa\u00014\u0001\u0004\t\t*A\u0004sKBd\u0017mY3\t\u000f\r\u001d1\u00071\u0001\u0004\n\u0005)a.^7E!B\u0019Ala\u0003\n\u0007\r5QLA\u0002J]R\f\u0001c\u0019:fCR,\u0007+\u0019:uSRLwN\\:\u0015\u0015\u0005\u000511CB\u000b\u0007/\u0019Y\u0002C\u0004\u0002DQ\u0002\r!!\u0019\t\re$\u0004\u0019AA1\u0011\u001d\u0019I\u0002\u000ea\u0001\u0003{\f\u0001B\\3x!\u0006\u0014Ho\u001d\u0005\b\u0005\u001b!\u0004\u0019AAI\u00039!'o\u001c9QCJ$\u0018\u000e^5p]N$b\"!\u0001\u0004\"\r\r2QEB\u0014\u0007S\u0019Y\u0003C\u0004\u0002DU\u0002\r!!\u0019\t\re,\u0004\u0019AA1\u0011\u001d\u0011\t!\u000ea\u0001\u0003gCqAa\u00066\u0001\u0004\t\t\nC\u0004\u0003XU\u0002\r!!%\t\u000f\r5R\u00071\u0001\u0002\u0012\u0006Q!/\u001a;bS:$\u0015\r^1\u0002!I,g.Y7f!\u0006\u0014H/\u001b;j_:\u001cHCCA\u0001\u0007g\u0019)da\u000e\u0004<!9\u00111\t\u001cA\u0002\u0005\u0005\u0004BB=7\u0001\u0004\t\t\u0007C\u0004\u0004:Y\u0002\r!a-\u0002\u0013\u0019\u0014x.\\*qK\u000e\u001c\bbBB\u001fm\u0001\u0007\u00111W\u0001\bi>\u001c\u0006/Z2t\u0003=\tG\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cH\u0003CA\u0001\u0007\u0007\u001a)ea\u0012\t\u000f\u0005\rs\u00071\u0001\u0002b!1\u0011p\u000ea\u0001\u0003CBqa!\u00138\u0001\u0004\ti0\u0001\u0006bYR,'\u000fU1siN\fAbZ3u!\u0006\u0014H/\u001b;j_:$\u0002\"a\u000e\u0004P\rE31\u000b\u0005\b\u0003\u0007B\u0004\u0019AA1\u0011\u0019I\b\b1\u0001\u0002b!91Q\u000b\u001dA\u0002\u0005%\u0012\u0001\u00039beR\u001c\u0006/Z2\u0002%\u001d,G\u000fU1si&$\u0018n\u001c8PaRLwN\u001c\u000b\t\u00077\u001aifa\u0018\u0004bA)ALa%\u00028!9\u00111I\u001dA\u0002\u0005\u0005\u0004BB=:\u0001\u0004\t\t\u0007C\u0004\u0004Ve\u0002\r!!\u000b\u0002%1L7\u000f\u001e)beRLG/[8o\u001d\u0006lWm\u001d\u000b\t\u0005g\u00199g!\u001b\u0004l!9\u00111\t\u001eA\u0002\u0005\u0005\u0004BB=;\u0001\u0004\t\t\u0007C\u0005\u0004Vi\u0002\n\u00111\u0001\u0004nA)ALa%\u0002*\u0005aB.[:u!\u0006\u0014H/\u001b;j_:t\u0015-\\3tI\u0011,g-Y;mi\u0012\u001aTCAB:U\u0011\u0019ig!\u001e,\u0005\r]\u0004\u0003BB=\u0007\u0007k!aa\u001f\u000b\t\ru4qP\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!!^\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u000b\u001bYHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0002\\5tiB\u000b'\u000f^5uS>t7\u000f\u0006\u0005\u0002~\u000e-5QRBH\u0011\u001d\t\u0019\u0005\u0010a\u0001\u0003CBa!\u001f\u001fA\u0002\u0005\u0005\u0004\"CBIyA\u0005\t\u0019AB7\u0003-\u0001\u0018M\u001d;jC2\u001c\u0006/Z2\u000211L7\u000f\u001e)beRLG/[8og\u0012\"WMZ1vYR$3'\u0001\fmSN$\b+\u0019:uSRLwN\\:Cs\u001aKG\u000e^3s))\tip!'\u0004\u001c\u000eu5q\u0016\u0005\b\u0003\u0007r\u0004\u0019AA1\u0011\u0019Ih\b1\u0001\u0002b!91q\u0014 A\u0002\r\u0005\u0016A\u00039sK\u0012L7-\u0019;fgB1\u0011QWA`\u0007G\u0003Ba!*\u0004,6\u00111q\u0015\u0006\u0004\u0007S{\u0015aC3yaJ,7o]5p]NLAa!,\u0004(\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\rEf\b1\u0001\u0002b\u0005\tB-\u001a4bk2$H+[7f5>tW-\u00133\u0002)\u001d,Go\u0015;biN\u0014\u0015\u0010U1si&$\u0018n\u001c8t))\u0011\tja.\u0004<\u000eu6q\u0019\u0005\u0007\u0007s{\u0004\u0019A>\u0002\u0019\r\fG/\u00197pOR\u000b'\r\\3\t\u000f\t\u0005q\b1\u0001\u00024\"91qX A\u0002\r\u0005\u0017!D3yaJ,7o]5p]N+G\u000f\u0005\u0003\u0004&\u000e\r\u0017\u0002BBc\u0007O\u0013Q\"\u0012=qe\u0016\u001c8/[8o'\u0016$\bbBBe\u007f\u0001\u000711Z\u0001\faJ|'.Z2u\u0019&\u001cH\u000f\u0005\u0004\u00026\u0006}6Q\u001a\t\u0005\u0007K\u001by-\u0003\u0003\u0004R\u000e\u001d&a\u0004(b[\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u001d\r\u0014X-\u0019;f\rVt7\r^5p]R1\u0011\u0011ABl\u00073Dq!a\u0011A\u0001\u0004\t\t\u0007C\u0004\u0004\\\u0002\u0003\r!a \u0002\t\u0019,hnY\u0001\rIJ|\u0007OR;oGRLwN\u001c\u000b\u0007\u0003\u0003\u0019\toa9\t\u000f\u0005\r\u0013\t1\u0001\u0002b!91Q]!A\u0002\u0005\u0005\u0014\u0001\u00034v]\u000et\u0015-\\3\u0002\u001b\u0005dG/\u001a:Gk:\u001cG/[8o)\u0019\t\taa;\u0004n\"9\u00111\t\"A\u0002\u0005\u0005\u0004bBBn\u0005\u0002\u0007\u0011qP\u0001\u000fe\u0016t\u0017-\\3Gk:\u001cG/[8o)!\t\taa=\u0004v\u000e]\bbBA\"\u0007\u0002\u0007\u0011\u0011\r\u0005\b\u0005C\u001a\u0005\u0019AA1\u0011\u001d\u0011)g\u0011a\u0001\u0003C\n1bZ3u\rVt7\r^5p]R1\u0011qPB\u007f\u0007\u007fDq!a\u0011E\u0001\u0004\t\t\u0007C\u0004\u0004f\u0012\u0003\r!!\u0019\u0002\u001d\u0019,hn\u0019;j_:,\u00050[:ugR1\u0011\u0011\u0013C\u0003\t\u000fAq!a\u0011F\u0001\u0004\t\t\u0007C\u0004\u0004f\u0016\u0003\r!!\u0019\u0002\u001b1L7\u000f\u001e$v]\u000e$\u0018n\u001c8t)\u0019\u0011\u0019\u0004\"\u0004\u0005\u0010!9\u00111\t$A\u0002\u0005\u0005\u0004b\u0002B\u001d\r\u0002\u0007\u0011\u0011M\u0001\u0010\u0013:lU-\\8ss\u000e\u000bG/\u00197pOB\u0011!\rS\n\u0003\u0011n#\"\u0001b\u0005\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t!iBK\u0002g\u0007k\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TC\u0001C\u0012U\rY7Q\u000f")
public class InMemoryCatalog
implements ExternalCatalog {
    private final Configuration hadoopConfig;
    private final HashMap<String, DatabaseDesc> catalog;

    public static Configuration $lessinit$greater$default$2() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$2();
    }

    public static SparkConf $lessinit$greater$default$1() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void requireDbExists(String db) {
        ExternalCatalog.requireDbExists$(this, db);
    }

    @Override
    public void requireTableExists(String db, String table) {
        ExternalCatalog.requireTableExists$(this, db, table);
    }

    @Override
    public void requireFunctionExists(String db, String funcName) {
        ExternalCatalog.requireFunctionExists$(this, db, funcName);
    }

    @Override
    public void requireFunctionNotExists(String db, String funcName) {
        ExternalCatalog.requireFunctionNotExists$(this, db, funcName);
    }

    private HashMap<String, DatabaseDesc> catalog() {
        return this.catalog;
    }

    private boolean partitionExists(String db, String table, Map<String, String> spec) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().contains(spec);
    }

    private void requireTableNotExists(String db, String table) {
        if (this.tableExists(db, table)) {
            throw new TableAlreadyExistsException(db, table);
        }
    }

    private void requirePartitionsExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private void requirePartitionsNotExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsNotExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private Function1<Map<String, String>, Map<String, String>> toCatalogPartitionSpec() {
        return (Function1 & Serializable & scala.Serializable)x$1 -> ExternalCatalogUtils$.MODULE$.convertNullPartitionValues((Map<String, String>)x$1);
    }

    private Seq<Map<String, String>> toCatalogPartitionSpecs(Seq<Map<String, String>> specs) {
        return (Seq)specs.map(this.toCatalogPartitionSpec(), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<CatalogTablePartition> toCatalogPartitionSpec(Seq<CatalogTablePartition> parts) {
        return (Seq)parts.map((Function1 & Serializable & scala.Serializable)part -> part.copy((Map<String, String>)((Map)this.toCatalogPartitionSpec().apply(part.spec())), part.copy$default$2(), part.copy$default$3(), part.copy$default$4(), part.copy$default$5(), part.copy$default$6()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)dbDefinition.name())) {
                if (!ignoreIfExists) {
                    throw new DatabaseAlreadyExistsException(dbDefinition.name());
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.liftedTree1$1(dbDefinition);
                boxedUnit = this.catalog().put((Object)dbDefinition.name(), (Object)new DatabaseDesc(this, dbDefinition));
            }
        }
    }

    @Override
    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)db)) {
                if (!cascade) {
                    if (((DatabaseDesc)this.catalog().apply((Object)db)).tables().nonEmpty()) {
                        throw new AnalysisException(new StringBuilder(49).append("Database ").append(db).append(" is not empty. One or more tables exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    if (((DatabaseDesc)this.catalog().apply((Object)db)).functions().nonEmpty()) {
                        throw new AnalysisException(new StringBuilder(54).append("Database '").append(db).append("' is not empty. One or more functions exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                }
                CatalogDatabase dbDefinition = ((DatabaseDesc)this.catalog().apply((Object)db)).db();
                this.liftedTree2$1(dbDefinition);
                boxedUnit = this.catalog().remove((Object)db);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchDatabaseException(db);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public synchronized void alterDatabase(CatalogDatabase dbDefinition) {
        this.requireDbExists(dbDefinition.name());
        ((DatabaseDesc)this.catalog().apply((Object)dbDefinition.name())).db_$eq(dbDefinition);
    }

    @Override
    public synchronized CatalogDatabase getDatabase(String db) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).db();
    }

    @Override
    public synchronized boolean databaseExists(String db) {
        return this.catalog().contains((Object)db);
    }

    @Override
    public synchronized Seq<String> listDatabases() {
        return (Seq)this.catalog().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listDatabases(String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listDatabases(), pattern);
    }

    @Override
    public void setCurrentDatabase(String db) {
    }

    @Override
    public void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
            String db = (String)tableDefinition.identifier().database().get();
            this.requireDbExists(db);
            String table = tableDefinition.identifier().table();
            if (this.tableExists(db, table)) {
                if (!ignoreIfExists) {
                    throw new TableAlreadyExistsException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Map tableProp;
                CatalogTable catalogTable;
                boolean needDefaultTableLocation;
                CatalogTableType catalogTableType = tableDefinition.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                boolean bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null) && tableDefinition.storage().locationUri().isEmpty() ? true : (needDefaultTableLocation = false);
                if (needDefaultTableLocation) {
                    Path defaultTableLocation = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), table);
                    this.liftedTree3$1(defaultTableLocation, table);
                    catalogTable = tableDefinition.withNewStorage((Option<URI>)new Some((Object)defaultTableLocation.toUri()), tableDefinition.withNewStorage$default$2(), tableDefinition.withNewStorage$default$3(), tableDefinition.withNewStorage$default$4(), tableDefinition.withNewStorage$default$5(), tableDefinition.withNewStorage$default$6());
                } else {
                    catalogTable = tableDefinition;
                }
                CatalogTable tableWithLocation = catalogTable;
                Map x$1 = tableProp = (Map)tableWithLocation.properties().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$createTable$1(x$2)));
                TableIdentifier x$22 = tableWithLocation.copy$default$1();
                CatalogTableType x$3 = tableWithLocation.copy$default$2();
                CatalogStorageFormat x$4 = tableWithLocation.copy$default$3();
                StructType x$5 = tableWithLocation.copy$default$4();
                Option<String> x$6 = tableWithLocation.copy$default$5();
                Seq<String> x$7 = tableWithLocation.copy$default$6();
                Option<BucketSpec> x$8 = tableWithLocation.copy$default$7();
                String x$9 = tableWithLocation.copy$default$8();
                long x$10 = tableWithLocation.copy$default$9();
                long x$11 = tableWithLocation.copy$default$10();
                String x$12 = tableWithLocation.copy$default$11();
                Option<CatalogStatistics> x$13 = tableWithLocation.copy$default$13();
                Option<String> x$14 = tableWithLocation.copy$default$14();
                Option<String> x$15 = tableWithLocation.copy$default$15();
                Seq<String> x$16 = tableWithLocation.copy$default$16();
                boolean x$17 = tableWithLocation.copy$default$17();
                boolean x$18 = tableWithLocation.copy$default$18();
                Map<String, String> x$19 = tableWithLocation.copy$default$19();
                Option<String> x$20 = tableWithLocation.copy$default$20();
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)table, (Object)new TableDesc(this, tableWithLocation.copy(x$22, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20)));
            }
        }
    }

    @Override
    public void dropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            this.requireDbExists(db);
            if (this.tableExists(db, table)) {
                Object object;
                CatalogTable tableMeta = this.getTable(db, table);
                CatalogTableType catalogTableType = tableMeta.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                    Seq locationAllParts = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.location(), Seq$.MODULE$.canBuildFrom());
                    locationAllParts.foreach((Function1 & Serializable & scala.Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$dropTable$2(this, loc)));
                    Predef$.MODULE$.assert(tableMeta.storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                    Path dir = new Path(tableMeta.location());
                    object = BoxesRunTime.boxToBoolean((boolean)this.liftedTree4$1(dir, table));
                } else {
                    object = BoxedUnit.UNIT;
                }
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)table);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchTableException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void renameTable(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireTableExists(db, oldName);
            this.requireTableNotExists(db, newName);
            TableDesc oldDesc = (TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)oldName);
            CatalogTable qual$1 = oldDesc.table();
            TableIdentifier x$1 = new TableIdentifier(newName, (Option<String>)new Some((Object)db));
            CatalogTableType x$2 = qual$1.copy$default$2();
            CatalogStorageFormat x$3 = qual$1.copy$default$3();
            StructType x$4 = qual$1.copy$default$4();
            Option<String> x$5 = qual$1.copy$default$5();
            Seq<String> x$6 = qual$1.copy$default$6();
            Option<BucketSpec> x$7 = qual$1.copy$default$7();
            String x$8 = qual$1.copy$default$8();
            long x$9 = qual$1.copy$default$9();
            long x$10 = qual$1.copy$default$10();
            String x$11 = qual$1.copy$default$11();
            Map<String, String> x$12 = qual$1.copy$default$12();
            Option<CatalogStatistics> x$13 = qual$1.copy$default$13();
            Option<String> x$14 = qual$1.copy$default$14();
            Option<String> x$15 = qual$1.copy$default$15();
            Seq<String> x$16 = qual$1.copy$default$16();
            boolean x$17 = qual$1.copy$default$17();
            boolean x$18 = qual$1.copy$default$18();
            Map<String, String> x$19 = qual$1.copy$default$19();
            Option<String> x$20 = qual$1.copy$default$20();
            oldDesc.table_$eq(qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
            CatalogTableType catalogTableType = oldDesc.table().tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                Predef$.MODULE$.assert(oldDesc.table().storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                Path oldDir = new Path(oldDesc.table().location());
                Path newDir = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), newName);
                this.liftedTree5$1(oldDir, newDir, oldName, newName);
                CatalogTable qual$2 = oldDesc.table();
                Some x$21 = new Some((Object)newDir.toUri());
                Option<String> x$22 = qual$2.withNewStorage$default$2();
                Option<String> x$23 = qual$2.withNewStorage$default$3();
                boolean x$24 = qual$2.withNewStorage$default$4();
                Option<String> x$25 = qual$2.withNewStorage$default$5();
                Map<String, String> x$26 = qual$2.withNewStorage$default$6();
                oldDesc.table_$eq(qual$2.withNewStorage((Option<URI>)x$21, x$22, x$23, x$24, x$25, x$26));
            }
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)newName, (Object)oldDesc);
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)oldName);
        }
    }

    @Override
    public synchronized void alterTable(CatalogTable tableDefinition) {
        Map updatedProperties;
        Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
        String db = (String)tableDefinition.identifier().database().get();
        this.requireTableExists(db, tableDefinition.identifier().table());
        Map x$1 = updatedProperties = (Map)tableDefinition.properties().filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$alterTable$1(kv)));
        TableIdentifier x$2 = tableDefinition.copy$default$1();
        CatalogTableType x$3 = tableDefinition.copy$default$2();
        CatalogStorageFormat x$4 = tableDefinition.copy$default$3();
        StructType x$5 = tableDefinition.copy$default$4();
        Option<String> x$6 = tableDefinition.copy$default$5();
        Seq<String> x$7 = tableDefinition.copy$default$6();
        Option<BucketSpec> x$8 = tableDefinition.copy$default$7();
        String x$9 = tableDefinition.copy$default$8();
        long x$10 = tableDefinition.copy$default$9();
        long x$11 = tableDefinition.copy$default$10();
        String x$12 = tableDefinition.copy$default$11();
        Option<CatalogStatistics> x$13 = tableDefinition.copy$default$13();
        Option<String> x$14 = tableDefinition.copy$default$14();
        Option<String> x$15 = tableDefinition.copy$default$15();
        Seq<String> x$16 = tableDefinition.copy$default$16();
        boolean x$17 = tableDefinition.copy$default$17();
        boolean x$18 = tableDefinition.copy$default$18();
        Map<String, String> x$19 = tableDefinition.copy$default$19();
        Option<String> x$20 = tableDefinition.copy$default$20();
        CatalogTable newTableDefinition = tableDefinition.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)tableDefinition.identifier().table())).table_$eq(newTableDefinition);
    }

    @Override
    public synchronized void alterTableDataSchema(String db, String table, StructType newDataSchema) {
        StructType newSchema;
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        StructType x$1 = newSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)newDataSchema.$plus$plus(origTable.partitionSchema(), Seq$.MODULE$.canBuildFrom())));
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        Option<String> x$5 = origTable.copy$default$5();
        Seq<String> x$6 = origTable.copy$default$6();
        Option<BucketSpec> x$7 = origTable.copy$default$7();
        String x$8 = origTable.copy$default$8();
        long x$9 = origTable.copy$default$9();
        long x$10 = origTable.copy$default$10();
        String x$11 = origTable.copy$default$11();
        Map<String, String> x$12 = origTable.copy$default$12();
        Option<CatalogStatistics> x$13 = origTable.copy$default$13();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Seq<String> x$16 = origTable.copy$default$16();
        boolean x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        Map<String, String> x$19 = origTable.copy$default$19();
        Option<String> x$20 = origTable.copy$default$20();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    @Override
    public synchronized void alterTableStats(String db, String table, Option<CatalogStatistics> stats) {
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        Option<CatalogStatistics> x$1 = stats;
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        StructType x$5 = origTable.copy$default$4();
        Option<String> x$6 = origTable.copy$default$5();
        Seq<String> x$7 = origTable.copy$default$6();
        Option<BucketSpec> x$8 = origTable.copy$default$7();
        String x$9 = origTable.copy$default$8();
        long x$10 = origTable.copy$default$9();
        long x$11 = origTable.copy$default$10();
        String x$12 = origTable.copy$default$11();
        Map<String, String> x$13 = origTable.copy$default$12();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Seq<String> x$16 = origTable.copy$default$16();
        boolean x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        Map<String, String> x$19 = origTable.copy$default$19();
        Option<String> x$20 = origTable.copy$default$20();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$1, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    @Override
    public synchronized CatalogTable getTable(String db, String table) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
    }

    @Override
    public Seq<CatalogTable> getTablesByName(String db, Seq<String> tables) {
        this.requireDbExists(db);
        HashMap<String, TableDesc> hashMap = ((DatabaseDesc)this.catalog().apply((Object)db)).tables();
        return (Seq)((TraversableLike)tables.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(hashMap.get(key)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.table(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public synchronized boolean tableExists(String db, String table) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).tables().contains((Object)table);
    }

    @Override
    public synchronized Seq<String> listTables(String db) {
        this.requireDbExists(db);
        return (Seq)((DatabaseDesc)this.catalog().apply((Object)db)).tables().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listTables(String db, String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listTables(db), pattern);
    }

    @Override
    public synchronized Seq<String> listViews(String db, String pattern) {
        this.requireDbExists(db);
        Set views = ((HashMap)((DatabaseDesc)this.catalog().apply((Object)db)).tables().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$listViews$1(x$5)))).keySet();
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((Seq)views.toSeq().sorted((Ordering)Ordering.String$.MODULE$)), pattern);
    }

    @Override
    public void loadTable(String db, String table, String loadPath, boolean isOverwrite, boolean isSrcLocal) {
        throw new UnsupportedOperationException("loadTable is not implemented");
    }

    @Override
    public void loadPartition(String db, String table, String loadPath, Map<String, String> partition, boolean isOverwrite, boolean inheritTableSpecs, boolean isSrcLocal) {
        throw new UnsupportedOperationException("loadPartition is not implemented.");
    }

    @Override
    public void loadDynamicPartitions(String db, String table, String loadPath, Map<String, String> partition, boolean replace, int numDP) {
        throw new UnsupportedOperationException("loadDynamicPartitions is not implemented.");
    }

    @Override
    public synchronized void createPartitions(String db, String table, Seq<CatalogTablePartition> newParts, boolean ignoreIfExists) {
        Seq dupSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        Seq<CatalogTablePartition> parts = this.toCatalogPartitionSpec(newParts);
        if (!ignoreIfExists && (dupSpecs = (Seq)parts.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$1;

            public final <A1 extends CatalogTablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.existingParts$1.contains(A1.spec()) ? A1.spec() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CatalogTablePartition x1) {
                CatalogTablePartition catalogTablePartition = x1;
                boolean bl = this.existingParts$1.contains(catalogTablePartition.spec());
                return bl;
            }
            {
                this.existingParts$1 = existingParts$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new PartitionsAlreadyExistException(db, table, (Seq<Map<String, String>>)dupSpecs);
        }
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Path partitionPath = (Path)p.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$6 -> new Path(x$6)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ExternalCatalogUtils$.MODULE$.generatePartitionPath(p.spec(), partitionColumnNames, tablePath));
            try {
                FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                Object object = !fs.exists(partitionPath) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(partitionPath)) : BoxedUnit.UNIT;
            }
            catch (IOException e) {
                throw new SparkException(new StringBuilder(32).append("Unable to create partition path ").append(partitionPath).toString(), (Throwable)e);
            }
            CatalogStorageFormat x$1 = p.storage().copy((Option<URI>)new Some((Object)partitionPath.toUri()), p.storage().copy$default$2(), p.storage().copy$default$3(), p.storage().copy$default$4(), p.storage().copy$default$5(), p.storage().copy$default$6());
            Map<String, String> x$2 = p.copy$default$1();
            Map<String, String> x$3 = p.copy$default$3();
            long x$4 = p.copy$default$4();
            long x$5 = p.copy$default$5();
            Option<CatalogStatistics> x$62 = p.copy$default$6();
            return existingParts.put(p.spec(), (Object)p.copy(x$2, x$1, x$3, x$4, x$5, x$62));
        });
    }

    @Override
    public synchronized void dropPartitions(String db, String table, Seq<Map<String, String>> parts, boolean ignoreIfNotExists, boolean purge, boolean retainData) {
        boolean bl;
        Seq missingSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        Seq<Map<String, String>> partSpecs = this.toCatalogPartitionSpecs(parts);
        if (!ignoreIfNotExists && (missingSpecs = (Seq)partSpecs.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$2;

            public final <A1 extends Map<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = !this.existingParts$2.contains(A1) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Map<String, String> x1) {
                Map<String, String> map = x1;
                boolean bl = !this.existingParts$2.contains(map);
                return bl;
            }
            {
                this.existingParts$2 = existingParts$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new NoSuchPartitionsException(db, table, (Seq<Map<String, String>>)missingSpecs);
        }
        if (retainData) {
            bl = false;
        } else {
            CatalogTableType catalogTableType = this.getTable(db, table).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        }
        boolean shouldRemovePartitionLocation = bl;
        partSpecs.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Object object;
            if (existingParts.contains(p) && shouldRemovePartitionLocation) {
                boolean bl;
                Path partitionPath = new Path(((CatalogTablePartition)existingParts.apply(p)).location());
                try {
                    FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
                    bl = fs.delete(partitionPath, true);
                }
                catch (IOException e) {
                    throw new SparkException(new StringBuilder(32).append("Unable to delete partition path ").append(partitionPath).toString(), (Throwable)e);
                }
                object = BoxesRunTime.boxToBoolean((boolean)bl);
            } else {
                object = BoxedUnit.UNIT;
            }
            return existingParts.remove(p);
        });
    }

    @Override
    public synchronized void renamePartitions(String db, String table, Seq<Map<String, String>> fromSpecs, Seq<Map<String, String>> toSpecs) {
        Seq<Map<String, String>> specs = this.toCatalogPartitionSpecs(fromSpecs);
        Seq<Map<String, String>> newSpecs = this.toCatalogPartitionSpecs(toSpecs);
        Predef$.MODULE$.require(specs.size() == newSpecs.size(), (Function0 & Serializable & scala.Serializable)() -> "number of old and new partition specs differ");
        this.requirePartitionsExist(db, table, specs);
        this.requirePartitionsNotExist(db, table, newSpecs);
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        CatalogTableType catalogTableType = this.getTable(db, table).tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        boolean shouldUpdatePartitionLocation = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        ((IterableLike)specs.zip(newSpecs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CatalogTablePartition catalogTablePartition;
            Map newSpec;
            Map oldSpec;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                oldSpec = (Map)tuple2._1();
                newSpec = (Map)tuple2._2();
                CatalogTablePartition oldPartition = this.getPartition(db, table, (Map<String, String>)oldSpec);
                if (shouldUpdatePartitionLocation) {
                    Path oldPartPath = new Path(oldPartition.location());
                    Path newPartPath = ExternalCatalogUtils$.MODULE$.generatePartitionPath((Map<String, String>)newSpec, partitionColumnNames, tablePath);
                    try {
                        FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                        fs.rename(oldPartPath, newPartPath);
                    }
                    catch (IOException e) {
                        throw new SparkException(new StringBuilder(32).append("Unable to rename partition path ").append(oldPartPath).toString(), (Throwable)e);
                    }
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.storage().copy((Option<URI>)new Some((Object)newPartPath.toUri()), oldPartition.storage().copy$default$2(), oldPartition.storage().copy$default$3(), oldPartition.storage().copy$default$4(), oldPartition.storage().copy$default$5(), oldPartition.storage().copy$default$6()), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                } else {
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.copy$default$2(), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CatalogTablePartition newPartition = catalogTablePartition;
            existingParts.remove((Object)oldSpec);
            Option option = existingParts.put((Object)newSpec, (Object)newPartition);
            return option;
        });
    }

    @Override
    public synchronized void alterPartitions(String db, String table, Seq<CatalogTablePartition> alterParts) {
        Seq<CatalogTablePartition> parts = this.toCatalogPartitionSpec(alterParts);
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)parts.map((Function1 & Serializable & scala.Serializable)p -> p.spec(), Seq$.MODULE$.canBuildFrom())));
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().put(p.spec(), p));
    }

    @Override
    public synchronized CatalogTablePartition getPartition(String db, String table, Map<String, String> partSpec) {
        Map spec = (Map)this.toCatalogPartitionSpec().apply(partSpec);
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec}))));
        return (CatalogTablePartition)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply((Object)spec);
    }

    @Override
    public synchronized Option<CatalogTablePartition> getPartitionOption(String db, String table, Map<String, String> partSpec) {
        Map spec = (Map)this.toCatalogPartitionSpec().apply(partSpec);
        return !this.partitionExists(db, table, (Map<String, String>)spec) ? None$.MODULE$ : Option$.MODULE$.apply(((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply((Object)spec));
    }

    @Override
    public synchronized Seq<String> listPartitionNames(String db, String table, Option<Map<String, String>> partSpec) {
        Seq<String> partitionColumnNames = this.getTable(db, table).partitionColumnNames();
        Option partialSpec = partSpec.map(this.toCatalogPartitionSpec());
        return (Seq)((SeqLike)this.listPartitions(db, table, (Option<Map<String, String>>)partialSpec).map((Function1 & Serializable & scala.Serializable)partition -> ((TraversableOnce)partitionColumnNames.map((Function1 & Serializable & scala.Serializable)name -> {
            String partValue = partition.spec().apply(name) == null ? ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME() : ExternalCatalogUtils$.MODULE$.escapePathName((String)partition.spec().apply(name));
            return new StringBuilder(1).append(ExternalCatalogUtils$.MODULE$.escapePathName((String)name)).append("=").append(partValue).toString();
        }, Seq$.MODULE$.canBuildFrom())).mkString("/"), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    @Override
    public synchronized Seq<CatalogTablePartition> listPartitions(String db, String table, Option<Map<String, String>> partialSpec) {
        Seq seq;
        this.requireTableExists(db, table);
        Option option = partialSpec.map(this.toCatalogPartitionSpec());
        if (None$.MODULE$.equals(option)) {
            seq = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Map partial = (Map)some.value();
            seq = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().toSeq().collect((PartialFunction)new scala.Serializable(null, partial){
                public static final long serialVersionUID = 0L;
                private final Map partial$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Map<String, String>, CatalogTablePartition>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        Map spec = (Map)A1._1();
                        CatalogTablePartition partition = (CatalogTablePartition)A1._2();
                        if (ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)spec)) {
                            object = partition;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Map<String, String>, CatalogTablePartition> x1) {
                    Map spec;
                    Tuple2<Map<String, String>, CatalogTablePartition> tuple2 = x1;
                    boolean bl = tuple2 != null && ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)(spec = (Map)tuple2._1()));
                    return bl;
                }
                {
                    this.partial$1 = partial$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        return seq;
    }

    @Override
    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Seq<CatalogTablePartition> listPartitionsByFilter(String db, String table, Seq<Expression> predicates, String defaultTimeZoneId) {
        CatalogTable catalogTable = this.getTable(db, table);
        Seq<CatalogTablePartition> allPartitions = this.listPartitions(db, table, this.listPartitions$default$3());
        return ExternalCatalogUtils$.MODULE$.prunePartitionsByFilter(catalogTable, allPartitions, predicates, defaultTimeZoneId);
    }

    @Override
    public Option<CatalogStatistics> getStatsByPartitions(CatalogTable catalogTable, Seq<Map<String, String>> parts, ExpressionSet expressionSet, Seq<NamedExpression> projectList) {
        return None$.MODULE$;
    }

    @Override
    public void createFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionNotExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void dropFunction(String db, String funcName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, funcName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)funcName);
        }
    }

    @Override
    public void alterFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void renameFunction(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, oldName);
            this.requireFunctionNotExists(db, newName);
            CatalogFunction qual$1 = this.getFunction(db, oldName);
            FunctionIdentifier x$1 = new FunctionIdentifier(newName, (Option<String>)new Some((Object)db));
            String x$2 = qual$1.copy$default$2();
            Seq<FunctionResource> x$3 = qual$1.copy$default$3();
            CatalogFunction newFunc = qual$1.copy(x$1, x$2, x$3);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)oldName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)newName, (Object)newFunc);
        }
    }

    @Override
    public synchronized CatalogFunction getFunction(String db, String funcName) {
        this.requireFunctionExists(db, funcName);
        return (CatalogFunction)((DatabaseDesc)this.catalog().apply((Object)db)).functions().apply((Object)funcName);
    }

    @Override
    public synchronized boolean functionExists(String db, String funcName) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).functions().contains((Object)funcName);
    }

    @Override
    public synchronized Seq<String> listFunctions(String db, String pattern) {
        this.requireDbExists(db);
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((DatabaseDesc)this.catalog().apply((Object)db)).functions().keysIterator().toSeq(), pattern);
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsExist$1(InMemoryCatalog $this, String db$1, String table$1, Map s) {
        if (!$this.partitionExists(db$1, table$1, (Map<String, String>)s)) {
            throw new NoSuchPartitionException(db$1, table$1, (Map<String, String>)s);
        }
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsNotExist$1(InMemoryCatalog $this, String db$2, String table$2, Map s) {
        if ($this.partitionExists(db$2, table$2, (Map<String, String>)s)) {
            throw new PartitionAlreadyExistsException(db$2, table$2, (Map<String, String>)s);
        }
    }

    private final boolean liftedTree1$1(CatalogDatabase dbDefinition$1) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$1.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(location);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(61).append("Unable to create database ").append(dbDefinition$1.name()).append(" as failed ").append("to create its directory ").append(dbDefinition$1.locationUri()).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree2$1(CatalogDatabase dbDefinition$2) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$2.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.delete(location, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(59).append("Unable to drop database ").append(dbDefinition$2.name()).append(" as failed ").append("to delete its directory ").append(dbDefinition$2.locationUri()).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree3$1(Path defaultTableLocation$1, String table$3) {
        boolean bl;
        try {
            FileSystem fs = defaultTableLocation$1.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(defaultTableLocation$1);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(58).append("Unable to create table ").append(table$3).append(" as failed ").append("to create its directory ").append(defaultTableLocation$1).toString(), (Throwable)e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createTable$1(Tuple2 x$2) {
        Object object = x$2._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$2(InMemoryCatalog $this, URI loc) {
        boolean bl;
        Path partitionPath = new Path(loc);
        try {
            FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
            bl = fs.delete(partitionPath, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(32).append("Unable to delete partition path ").append(partitionPath).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree4$1(Path dir$1, String table$4) {
        boolean bl;
        try {
            FileSystem fs = dir$1.getFileSystem(this.hadoopConfig);
            bl = fs.delete(dir$1, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(56).append("Unable to drop table ").append(table$4).append(" as failed ").append("to delete its directory ").append(dir$1).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree5$1(Path oldDir$1, Path newDir$1, String oldName$1, String newName$1) {
        boolean bl;
        try {
            FileSystem fs = oldDir$1.getFileSystem(this.hadoopConfig);
            bl = fs.rename(oldDir$1, newDir$1);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(62).append("Unable to rename table ").append(oldName$1).append(" to ").append(newName$1).append(" as failed ").append("to rename its directory ").append(oldDir$1).toString(), (Throwable)e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$alterTable$1(Tuple2 kv) {
        Object object = kv._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listViews$1(Tuple2 x$5) {
        CatalogTableType catalogTableType = ((TableDesc)x$5._2()).table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        return !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
    }

    public InMemoryCatalog(SparkConf conf, Configuration hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
        ExternalCatalog.$init$(this);
        this.catalog = new HashMap();
    }

    public class DatabaseDesc {
        private CatalogDatabase db;
        private final HashMap<String, TableDesc> tables;
        private final HashMap<String, CatalogFunction> functions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogDatabase db() {
            return this.db;
        }

        public void db_$eq(CatalogDatabase x$1) {
            this.db = x$1;
        }

        public HashMap<String, TableDesc> tables() {
            return this.tables;
        }

        public HashMap<String, CatalogFunction> functions() {
            return this.functions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$DatabaseDesc$$$outer() {
            return this.$outer;
        }

        public DatabaseDesc(InMemoryCatalog $outer, CatalogDatabase db) {
            this.db = db;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.tables = new HashMap();
            this.functions = new HashMap();
        }
    }

    public class TableDesc {
        private CatalogTable table;
        private final HashMap<Map<String, String>, CatalogTablePartition> partitions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogTable table() {
            return this.table;
        }

        public void table_$eq(CatalogTable x$1) {
            this.table = x$1;
        }

        public HashMap<Map<String, String>, CatalogTablePartition> partitions() {
            return this.partitions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$TableDesc$$$outer() {
            return this.$outer;
        }

        public TableDesc(InMemoryCatalog $outer, CatalogTable table) {
            this.table = table;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = new HashMap();
        }
    }
}

