/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AnsiCast;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$StoreAssignmentPolicy$;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.Metadata;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;

public final class TableOutputResolver$ {
    public static TableOutputResolver$ MODULE$;

    static {
        new TableOutputResolver$();
    }

    public LogicalPlan resolveOutputColumns(String tableName, Seq<Attribute> expected, LogicalPlan query, boolean byName, SQLConf conf) {
        Seq resolved2;
        Seq seq;
        if (expected.size() < query.output().size()) {
            throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(97).append("Cannot write to '").append(tableName).append("', too many data columns:\n           |Table columns: ").append(((TraversableOnce)expected.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append(c.name()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("\n           |Data columns: ").append(((TraversableOnce)query.output().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append(c.name()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        ArrayBuffer errors = new ArrayBuffer();
        if (byName) {
            seq = (Seq)expected.flatMap((Function1 & Serializable & scala.Serializable)tableAttr -> {
                Iterable iterable;
                Option<NamedExpression> option = query.resolve((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableAttr.name()}))), conf.resolver());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    NamedExpression queryExpr = (NamedExpression)some.value();
                    iterable = Option$.MODULE$.option2Iterable(MODULE$.checkField((Attribute)tableAttr, queryExpr, byName, conf, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)err -> {
                        errors.$plus$eq((Object)err);
                        return BoxedUnit.UNIT;
                    }));
                } else if (None$.MODULE$.equals(option)) {
                    errors.$plus$eq((Object)new StringBuilder(37).append("Cannot find data for output column '").append(tableAttr.name()).append("'").toString());
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    throw new MatchError(option);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            if (expected.size() > query.output().size()) {
                throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(103).append("Cannot write to '").append(tableName).append("', not enough data columns:\n             |Table columns: ").append(((TraversableOnce)expected.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append(c.name()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("\n             |Data columns: ").append(((TraversableOnce)query.output().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append(c.name()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            seq = resolved2 = (Seq)((TraversableLike)query.output().zip(expected, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Attribute queryExpr = (Attribute)tuple2._1();
                Attribute tableAttr = (Attribute)tuple2._2();
                Iterable iterable = Option$.MODULE$.option2Iterable(MODULE$.checkField(tableAttr, queryExpr, byName, conf, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)err -> {
                    errors.$plus$eq((Object)err);
                    return BoxedUnit.UNIT;
                }));
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
        }
        if (errors.nonEmpty()) {
            throw new AnalysisException(new StringBuilder(46).append("Cannot write incompatible data to table '").append(tableName).append("':\n- ").append(errors.mkString("\n- ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Seq seq2 = resolved2;
        Seq<Attribute> seq3 = query.output();
        return !(seq2 != null ? !seq2.equals(seq3) : seq3 != null) ? query : new Project((Seq<NamedExpression>)resolved2, query);
    }

    private Option<NamedExpression> checkField(Attribute tableAttr, NamedExpression queryExpr, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError) {
        Some some;
        Enumeration.Value storeAssignmentPolicy;
        LazyRef outputField$lzy = new LazyRef();
        Enumeration.Value value = storeAssignmentPolicy = conf.storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            some = TableOutputResolver$.outputField$1(outputField$lzy, tableAttr, queryExpr, storeAssignmentPolicy, conf);
        } else {
            boolean bl;
            Enumeration.Value value4 = SQLConf$StoreAssignmentPolicy$.MODULE$.STRICT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
                Enumeration.Value value7 = value;
                bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
            }
            if (bl) {
                Object object;
                boolean canWrite = DataType$.MODULE$.canWrite(((Expression)((Object)queryExpr)).dataType(), tableAttr.dataType(), byName, conf.resolver(), tableAttr.name(), storeAssignmentPolicy, addError);
                if (((Expression)((Object)queryExpr)).nullable() && !tableAttr.nullable()) {
                    addError.apply((Object)new StringBuilder(50).append("Cannot write nullable values to non-null column '").append(tableAttr.name()).append("'").toString());
                    object = None$.MODULE$;
                } else {
                    object = !canWrite ? None$.MODULE$ : TableOutputResolver$.outputField$1(outputField$lzy, tableAttr, queryExpr, storeAssignmentPolicy, conf);
                }
                some = object;
            } else {
                throw new MatchError((Object)value);
            }
        }
        return some;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final /* synthetic */ Some outputField$lzycompute$1(LazyRef outputField$lzy$1, Attribute tableAttr$1, NamedExpression queryExpr$1, Enumeration.Value storeAssignmentPolicy$1, SQLConf conf$2) {
        var6_5 = outputField$lzy$1;
        synchronized (var6_5) {
            block6: {
                block5: {
                    if (!outputField$lzy$1.initialized()) break block5;
                    v0 = (Some)outputField$lzy$1.value();
                    break block6;
                }
                if (!tableAttr$1.dataType().sameType(((Expression)queryExpr$1).dataType())) ** GOTO lbl-1000
                v1 = tableAttr$1.name();
                var8_6 = queryExpr$1.name();
                if (v1 != null ? v1.equals(var8_6) == false : var8_6 != null) ** GOTO lbl-1000
                v2 = tableAttr$1.metadata();
                var9_7 = queryExpr$1.metadata();
                if (!(v2 != null ? v2.equals(var9_7) == false : var9_7 != null)) {
                    v3 = new Some((Object)queryExpr$1);
                } else lbl-1000:
                // 3 sources

                {
                    var11_8 = storeAssignmentPolicy$1;
                    v4 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
                    var12_9 = var11_8;
                    var5_10 /* !! */  = !(v4 != null ? v4.equals(var12_9) == false : var12_9 != null) ? new AnsiCast((Expression)queryExpr$1, tableAttr$1.dataType(), (Option<String>)Option$.MODULE$.apply((Object)conf$2.sessionLocalTimeZone())) : new Cast((Expression)queryExpr$1, tableAttr$1.dataType(), (Option<String>)Option$.MODULE$.apply((Object)conf$2.sessionLocalTimeZone()));
                    casted /* !! */  = var5_10 /* !! */ ;
                    x$1 = exprWithStrLenCheck = CharVarcharUtils$.MODULE$.stringLengthCheck((Expression)casted /* !! */ , tableAttr$1);
                    x$2 = tableAttr$1.name();
                    x$3 = new Some((Object)tableAttr$1.metadata());
                    x$4 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                    x$5 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                    x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                    v5 = new Some((Object)new Alias(x$1, x$2, x$4, x$5, (Option<Metadata>)x$3, x$6));
                    v3 = v5;
                }
                v0 = (Some)outputField$lzy$1.initialize((Object)v3);
            }
            var7_19 = v0;
        }
        return var7_19;
    }

    private static final Some outputField$1(LazyRef outputField$lzy$1, Attribute tableAttr$1, NamedExpression queryExpr$1, Enumeration.Value storeAssignmentPolicy$1, SQLConf conf$2) {
        return outputField$lzy$1.initialized() ? (Some)outputField$lzy$1.value() : TableOutputResolver$.outputField$lzycompute$1(outputField$lzy$1, tableAttr$1, queryExpr$1, storeAssignmentPolicy$1, conf$2);
    }

    private TableOutputResolver$() {
        MODULE$ = this;
    }
}

