/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.DispatcherType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.ExecutorProcessLost;
import org.apache.spark.scheduler.ExecutorProcessLost$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.ui.DelegatingServletContextHandler;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r5bAB#G\u0003\u0003Q\u0005\u000b\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\"B0\u0001\t\u0003\u0001\u0007b\u00023\u0001\u0005\u0004%I!\u001a\u0005\u0007e\u0002\u0001\u000b\u0011\u00024\t\u000fM\u0004!\u0019!C!i\"11\u0010\u0001Q\u0001\nUDq\u0001 \u0001A\u0002\u0013EQ\u0010C\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0005\u0002\u0006!9\u0011\u0011\u0003\u0001!B\u0013q\b\"CA\n\u0001\t\u0007I\u0011BA\u000b\u0011!\tY\n\u0001Q\u0001\n\u0005]\u0001\"CAO\u0001\u0001\u0007I\u0011CAP\u0011%\ti\u000b\u0001a\u0001\n#\ty\u000b\u0003\u0005\u00024\u0002\u0001\u000b\u0015BAQ\u0011%\t)\f\u0001b\u0001\n\u0013\t9\f\u0003\u0005\u0002:\u0002\u0001\u000b\u0011BAT\u0011%\tY\f\u0001b\u0001\n\u0017\ti\f\u0003\u0005\u0002F\u0002\u0001\u000b\u0011BA`\u0011%\t9\r\u0001b\u0001\n\u0017\tI\r\u0003\u0005\u0002V\u0002\u0001\u000b\u0011BAf\u0011%\t9\u000e\u0001a\u0001\n#\tI\u000eC\u0005\u0002v\u0002\u0001\r\u0011\"\u0005\u0002x\"A\u00111 \u0001!B\u0013\tY\u000eC\u0005\u0002~\u0002\u0001\r\u0011\"\u0003\u0002\u0000\"I!\u0011\u0002\u0001A\u0002\u0013%!1\u0002\u0005\t\u0005\u001f\u0001\u0001\u0015)\u0003\u0003\u0002!I!\u0011\u0003\u0001C\u0002\u0013%!1\u0003\u0005\t\u0005C\u0001\u0001\u0015!\u0003\u0003\u0016!A!1\u0005\u0001C\u0002\u0013%A\u000fC\u0004\u0003&\u0001\u0001\u000b\u0011B;\t\u0011\t\u001d\u0002A1A\u0005\nQDqA!\u000b\u0001A\u0003%Q\u000f\u0003\u0005\u0003,\u0001\u0011\r\u0011\"\u0003~\u0011\u001d\u0011i\u0003\u0001Q\u0001\nyD\u0001Ba\f\u0001\u0005\u0004%I! \u0005\b\u0005c\u0001\u0001\u0015!\u0003\u007f\u0011\u001d\u0011\u0019\u0004\u0001C\t\u0005kAqAa\u000f\u0001\t#\u0011i\u0004C\u0004\u0003@\u0001!\tE!\u0010\t\u000f\t\u0005\u0003\u0001\"\u0011\u0003D!9!q\t\u0001\u0005B\t%\u0003\u0002\u0003B&\u0001\u0011\u0005aI!\u0014\t\u000f\t\u001d\u0005\u0001\"\u0011\u0003\n\"9!\u0011\u0014\u0001\u0005B\tm\u0005b\u0002BZ\u0001\u0011\u0005#Q\u0017\u0005\b\u0005o\u0003A\u0011\tB]\u0011!\u0011Y\r\u0001C\u0001\r\n5\u0007b\u0002Bo\u0001\u0011\u0005#q\u001c\u0005\t\u0005O\u0004A\u0011\u000b%\u0003>!9!\u0011\u001e\u0001\u0005R\t-hA\u0002B\u0000\u0001\u0011\u0019\t\u0001\u0003\u0004`i\u0011\u000511\u0001\u0005\b\u0003W\"D\u0011IB\u0004\r\u0019\tY\u0002\u0001\u0003\u0002\u001e!Q\u0011QH\u001c\u0003\u0006\u0004%\t%a\u0010\t\u0015\u0005\u001dsG!A!\u0002\u0013\t\t\u0005\u0003\u0004`o\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u001b:D\u0011IA(\u0011\u001d\tif\u000eC!\u0003?Bq!a\u001b8\t\u0003\ni\u0007\u0003\u0007\u0002z]\u0012\t\u0011!A\u0005\u0002\u0001\tY\b\u0003\b\u0004\u000e\u0001\u0001\n1!A\u0001\n\u0013\u0011Iea\u0004\b\u0011\rUa\t#\u0001K\u0007/1q!\u0012$\t\u0002)\u001bI\u0002\u0003\u0004`\u0003\u0012\u000511\u0004\u0005\n\u0007;\t%\u0019!C\u0001\u0007?A\u0001ba\u000bBA\u0003%1\u0011\u0005\u0002\u00153\u0006\u0014hnU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u000b\u0005\u001dC\u0015aB2mkN$XM\u001d\u0006\u0003\u0013*\u000b\u0011b]2iK\u0012,H.\u001a:\u000b\u0005-c\u0015!B:qCJ\\'BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001e\u001c\"\u0001A)\u0011\u0005I\u001bV\"\u0001$\n\u0005Q3%!H\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0004\u0001A\u0011q\u000bW\u0007\u0002\u0011&\u0011\u0011\f\u0013\u0002\u0012)\u0006\u001c8nU2iK\u0012,H.\u001a:J[Bd\u0017AA:d!\taV,D\u0001K\u0013\tq&J\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0004C\n\u001c\u0007C\u0001*\u0001\u0011\u0015I5\u00011\u0001W\u0011\u0015Q6\u00011\u0001\\\u0003\u001d\u0019Ho\u001c9qK\u0012,\u0012A\u001a\t\u0003OBl\u0011\u0001\u001b\u0006\u0003S*\fa!\u0019;p[&\u001c'BA6m\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003[:\fA!\u001e;jY*\tq.\u0001\u0003kCZ\f\u0017BA9i\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006A1\u000f^8qa\u0016$\u0007%\u0001\nnS:\u0014VmZ5ti\u0016\u0014X\r\u001a*bi&|W#A;\u0011\u0005YLX\"A<\u000b\u0003a\fQa]2bY\u0006L!A_<\u0003\r\u0011{WO\u00197f\u0003Mi\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8!\u0003Y!x\u000e^1m\u000bb\u0004Xm\u0019;fI\u0016CXmY;u_J\u001cX#\u0001@\u0011\u0005Y|\u0018bAA\u0001o\n\u0019\u0011J\u001c;\u00025Q|G/\u00197FqB,7\r^3e\u000bb,7-\u001e;peN|F%Z9\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004m\u0006%\u0011bAA\u0006o\n!QK\\5u\u0011!\ty!CA\u0001\u0002\u0004q\u0018a\u0001=%c\u00059Bo\u001c;bY\u0016C\b/Z2uK\u0012,\u00050Z2vi>\u00148\u000fI\u0001\u0016s\u0006\u0014hnU2iK\u0012,H.\u001a:F]\u0012\u0004x.\u001b8u+\t\t9\u0002E\u0002\u0002\u001a]j\u0011\u0001\u0001\u0002\u00163\u0006\u0014hnU2iK\u0012,H.\u001a:F]\u0012\u0004x.\u001b8u'\u001d9\u0014qDA\u0013\u0003c\u00012A^A\u0011\u0013\r\t\u0019c\u001e\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000bK\u0003\r\u0011\boY\u0005\u0005\u0003_\tICA\u000bUQJ,\u0017\rZ*bM\u0016\u0014\u0006oY#oIB|\u0017N\u001c;\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000eK\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA\u001e\u0003k\u0011q\u0001T8hO&tw-\u0001\u0004sa\u000e,eN^\u000b\u0003\u0003\u0003\u0002B!a\n\u0002D%!\u0011QIA\u0015\u0005\u0019\u0011\u0006oY#om\u00069!\u000f]2F]Z\u0004C\u0003BA\f\u0003\u0017Bq!!\u0010;\u0001\u0004\t\t%A\u0004sK\u000e,\u0017N^3\u0016\u0005\u0005E\u0003c\u0002<\u0002T\u0005]\u0013qA\u0005\u0004\u0003+:(a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\u0011\u0007Y\fI&C\u0002\u0002\\]\u00141!\u00118z\u0003=\u0011XmY3jm\u0016\fe\u000e\u001a*fa2LH\u0003BA)\u0003CBq!a\u0019=\u0001\u0004\t)'A\u0004d_:$X\r\u001f;\u0011\t\u0005\u001d\u0012qM\u0005\u0005\u0003S\nIC\u0001\bSa\u000e\u001c\u0015\r\u001c7D_:$X\r\u001f;\u0002\u001d=tG)[:d_:tWm\u0019;fIR!\u0011qAA8\u0011\u001d\t\t(\u0010a\u0001\u0003g\nQB]3n_R,\u0017\t\u001a3sKN\u001c\b\u0003BA\u0014\u0003kJA!a\u001e\u0002*\tQ!\u000b]2BI\u0012\u0014Xm]:\u0002;>\u0014x\rJ1qC\u000eDW\rJ:qCJ\\Ge]2iK\u0012,H.\u001a:%G2,8\u000f^3sIe\u000b'O\\*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8eI\u0011B\u0017M\u001c3mK\u0016CXmY;u_J$\u0015n]2p]:,7\r^3e\rJ|W\u000e\u0012:jm\u0016\u0014HCBA\u0004\u0003{\n9\nC\u0004\u0002\u0000y\u0002\r!!!\u0002\u0015\u0015DXmY;u_JLE\r\u0005\u0003\u0002\u0004\u0006Ee\u0002BAC\u0003\u001b\u00032!a\"x\u001b\t\tIIC\u0002\u0002\fV\u000ba\u0001\u0010:p_Rt\u0014bAAHo\u00061\u0001K]3eK\u001aLA!a%\u0002\u0016\n11\u000b\u001e:j]\u001eT1!a$x\u0011\u001d\tIJ\u0010a\u0001\u0003g\n!#\u001a=fGV$xN\u001d*qG\u0006#GM]3tg\u00061\u00120\u0019:o'\u000eDW\rZ;mKJ,e\u000e\u001a9pS:$\b%\u0001\u0006b[\u0016sG\r]8j]R,\"!!)\u0011\u000bY\f\u0019+a*\n\u0007\u0005\u0015vO\u0001\u0004PaRLwN\u001c\t\u0005\u0003O\tI+\u0003\u0003\u0002,\u0006%\"A\u0004*qG\u0016sG\r]8j]R\u0014VMZ\u0001\u000fC6,e\u000e\u001a9pS:$x\fJ3r)\u0011\t9!!-\t\u0013\u0005=a\"!AA\u0002\u0005\u0005\u0016aC1n\u000b:$\u0007o\\5oi\u0002\n\u0001$_1s]N\u001b\u0007.\u001a3vY\u0016\u0014XI\u001c3q_&tGOU3g+\t\t9+A\rzCJt7k\u00195fIVdWM]#oIB|\u0017N\u001c;SK\u001a\u0004\u0013AC1tWRKW.Z8viV\u0011\u0011q\u0018\t\u0005\u0003O\t\t-\u0003\u0003\u0002D\u0006%\"A\u0003*qGRKW.Z8vi\u0006Y\u0011m]6US6,w.\u001e;!\u0003M\u00198\r[3ek2,'/\u00128ea>Lg\u000e^#D+\t\tY\r\u0005\u0003\u0002N\u0006EWBAAh\u0015\tYw/\u0003\u0003\u0002T\u0006='aH#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peN+'O^5dK\u0006!2o\u00195fIVdWM]#oIB|\u0017N\u001c;F\u0007\u0002\nQ!\u00199q\u0013\u0012,\"!a7\u0011\u000bY\f\u0019+!8\u0011\t\u0005}\u0017\u0011_\u0007\u0003\u0003CTA!a9\u0002f\u00069!/Z2pe\u0012\u001c(\u0002BAt\u0003S\f1!\u00199j\u0015\u0011\tY/!<\u0002\te\f'O\u001c\u0006\u0004\u0003_d\u0015A\u00025bI>|\u0007/\u0003\u0003\u0002t\u0006\u0005(!D!qa2L7-\u0019;j_:LE-A\u0005baBLEm\u0018\u0013fcR!\u0011qAA}\u0011%\tyaFA\u0001\u0002\u0004\tY.\u0001\u0004baBLE\rI\u0001\nCR$X-\u001c9u\u0013\u0012,\"A!\u0001\u0011\u000bY\f\u0019Ka\u0001\u0011\t\u0005}'QA\u0005\u0005\u0005\u000f\t\tO\u0001\u000bBaBd\u0017nY1uS>t\u0017\t\u001e;f[B$\u0018\nZ\u0001\u000eCR$X-\u001c9u\u0013\u0012|F%Z9\u0015\t\u0005\u001d!Q\u0002\u0005\n\u0003\u001fQ\u0012\u0011!a\u0001\u0005\u0003\t!\"\u0019;uK6\u0004H/\u00133!\u0003I\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u001b\u0006\u001cH/\u001a:\u0016\u0005\tU\u0001\u0003\u0002B\f\u0005;i!A!\u0007\u000b\u0007\tm!*A\u0004ti>\u0014\u0018mZ3\n\t\t}!\u0011\u0004\u0002\u0013\u00052|7m['b]\u0006<WM]'bgR,'/A\ncY>\u001c7.T1oC\u001e,'/T1ti\u0016\u0014\b%\u0001\rnS:lUM]4feN$\u0006N]3tQ>dGMU1uS>\f\u0011$\\5o\u001b\u0016\u0014x-\u001a:t)\"\u0014Xm\u001d5pY\u0012\u0014\u0016\r^5pA\u0005IR.\u001b8NKJ<WM]:Ti\u0006$\u0018n\u0019+ie\u0016\u001c\bn\u001c7e\u0003ii\u0017N\\'fe\u001e,'o]*uCRL7\r\u00165sKNDw\u000e\u001c3!\u0003=i\u0017\r\u001f(v[\u0016CXmY;u_J\u001c\u0018\u0001E7bq:+X.\u0012=fGV$xN]:!\u00031qW/\\#yK\u000e,Ho\u001c:t\u00035qW/\\#yK\u000e,Ho\u001c:tA\u0005Q!-\u001b8e)>L\u0016M\u001d8\u0015\r\u0005\u001d!q\u0007B\u001d\u0011\u001d\t9N\na\u0001\u0003;Dq!!@'\u0001\u0004\u0011\t!A\u0007ti\u0006\u0014HOQ5oI&twm\u001d\u000b\u0003\u0003\u000f\tAa\u001d;pa\u0006!\u0012\r\u001d9mS\u000e\fG/[8o\u0003R$X-\u001c9u\u0013\u0012$\"A!\u0012\u0011\u000bY\f\u0019+!!\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e)\t\t\t)A\fqe\u0016\u0004\u0018M]3SKF,Xm\u001d;Fq\u0016\u001cW\u000f^8sgR!!q\nB9!\u0011\u0011\tFa\u001b\u000f\t\tM#q\r\b\u0005\u0005+\u0012)G\u0004\u0003\u0003X\t\rd\u0002\u0002B-\u0005CrAAa\u0017\u0003`9!\u0011q\u0011B/\u0013\u0005y\u0015BA'O\u0013\tYE*\u0003\u0002J\u0015&\u0011q\tS\u0005\u0004\u0005S2\u0015\u0001H\"pCJ\u001cXm\u0012:bS:,Gm\u00117vgR,'/T3tg\u0006<Wm]\u0005\u0005\u0005[\u0012yG\u0001\tSKF,Xm\u001d;Fq\u0016\u001cW\u000f^8sg*\u0019!\u0011\u000e$\t\u000f\tM4\u00061\u0001\u0003v\u0005Y\"/Z:pkJ\u001cW\r\u0015:pM&dW\rV8U_R\fG.\u0012=fGN\u0004r!a!\u0003x\tmd0\u0003\u0003\u0003z\u0005U%aA'baB!!Q\u0010BB\u001b\t\u0011yHC\u0002\u0003\u0002*\u000b\u0001B]3t_V\u00148-Z\u0005\u0005\u0005\u000b\u0013yHA\bSKN|WO]2f!J|g-\u001b7f\u0003]!wNU3rk\u0016\u001cH\u000fV8uC2,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0003\f\n]\u0005CBAg\u0005\u001b\u0013\t*\u0003\u0003\u0003\u0010\u0006='A\u0002$viV\u0014X\rE\u0002w\u0005'K1A!&x\u0005\u001d\u0011un\u001c7fC:DqAa\u001d-\u0001\u0004\u0011)(A\be_.KG\u000e\\#yK\u000e,Ho\u001c:t)\u0011\u0011YI!(\t\u000f\t}U\u00061\u0001\u0003\"\u0006YQ\r_3dkR|'/\u00133t!\u0019\u0011\u0019K!,\u0002\u0002:!!Q\u0015BU\u001d\u0011\t9Ia*\n\u0003aL1Aa+x\u0003\u001d\u0001\u0018mY6bO\u0016LAAa,\u00032\n\u00191+Z9\u000b\u0007\t-v/A\u000ftk\u001a4\u0017nY5f]R\u0014Vm]8ve\u000e,7OU3hSN$XM]3e)\t\u0011\t*A\u000fhKR\u001c\u0006.\u001e4gY\u0016\u0004Vo\u001d5NKJ<WM\u001d'pG\u0006$\u0018n\u001c8t)\u0019\u0011YLa1\u0003HB1!1\u0015BW\u0005{\u0003BAa\u0006\u0003@&!!\u0011\u0019B\r\u00059\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012DaA!20\u0001\u0004q\u0018!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0003\u0004\u0003J>\u0002\rA`\u0001\u0012e\u0016\u001cx.\u001e:dKB\u0013xNZ5mK&#\u0017AD1eI^+'-V%GS2$XM\u001d\u000b\t\u0003\u000f\u0011yMa5\u0003Z\"9!\u0011\u001b\u0019A\u0002\u0005\u0005\u0015A\u00034jYR,'OT1nK\"9!Q\u001b\u0019A\u0002\t]\u0017\u0001\u00044jYR,'\u000fU1sC6\u001c\b\u0003CAB\u0005o\n\t)!!\t\u000f\tm\u0007\u00071\u0001\u0002\u0002\u0006I\u0001O]8ys\n\u000b7/Z\u0001\u0015GJ,\u0017\r^3Ee&4XM]#oIB|\u0017N\u001c;\u0015\u0005\t\u0005\b\u0003BA\r\u0005GL1A!:T\u00059!%/\u001b<fe\u0016sG\r]8j]R\fQA]3tKR\f!c\u0019:fCR,Gk\\6f]6\u000bg.Y4feR\u0011!Q\u001e\t\u0006m\u0006\r&q\u001e\t\u0005\u0005c\u0014Y0\u0004\u0002\u0003t*!!Q\u001fB|\u0003!\u0019XmY;sSRL(b\u0001B}\u0015\u00061A-\u001a9m_fLAA!@\u0003t\na\u0002*\u00193p_B$U\r\\3hCRLwN\u001c+pW\u0016tW*\u00198bO\u0016\u0014(AE-be:$%/\u001b<fe\u0016sG\r]8j]R\u001c2\u0001\u000eBq)\t\u0019)\u0001E\u0002\u0002\u001aQ\"B!a\u0002\u0004\n!911\u0002\u001cA\u0002\u0005M\u0014A\u0003:qG\u0006#GM]3tg\u0006\u00192/\u001e9fe\u0012\n\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JI&!!qIB\t\u0013\r\u0019\u0019\u0002\u0013\u0002\u0011'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\fA#W1s]N\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007C\u0001*B'\r\t\u0015q\u0004\u000b\u0003\u0007/\tQ\"\u0012(E!>Ke\nV0O\u00036+UCAB\u0011!\u0011\u0019\u0019c!\u000b\u000e\u0005\r\u0015\"bAB\u0014]\u0006!A.\u00198h\u0013\u0011\t\u0019j!\n\u0002\u001d\u0015sE\tU(J\u001dR{f*Q'FA\u0001")
public abstract class YarnSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final TaskSchedulerImpl scheduler;
    private final SparkContext sc;
    private final AtomicBoolean org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped;
    private final double minRegisteredRatio;
    private int totalExpectedExecutors;
    private final YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint;
    private Option<RpcEndpointRef> amEndpoint;
    private final RpcEndpointRef yarnSchedulerEndpointRef;
    private final RpcTimeout org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout;
    private final ExecutionContextExecutorService org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$schedulerEndpointEC;
    private Option<ApplicationId> appId;
    private Option<ApplicationAttemptId> attemptId;
    private final BlockManagerMaster blockManagerMaster;
    private final double minMergersThresholdRatio;
    private final double minMergersStaticThreshold;
    private final int maxNumExecutors;
    private final int numExecutors;

    public static String ENDPOINT_NAME() {
        return YarnSchedulerBackend$.MODULE$.ENDPOINT_NAME();
    }

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    public AtomicBoolean org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    public int totalExpectedExecutors() {
        return this.totalExpectedExecutors;
    }

    public void totalExpectedExecutors_$eq(int x$1) {
        this.totalExpectedExecutors = x$1;
    }

    public YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint;
    }

    public Option<RpcEndpointRef> amEndpoint() {
        return this.amEndpoint;
    }

    public void amEndpoint_$eq(Option<RpcEndpointRef> x$1) {
        this.amEndpoint = x$1;
    }

    private RpcEndpointRef yarnSchedulerEndpointRef() {
        return this.yarnSchedulerEndpointRef;
    }

    public RpcTimeout org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout;
    }

    public ExecutionContextExecutorService org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$schedulerEndpointEC() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$schedulerEndpointEC;
    }

    public Option<ApplicationId> appId() {
        return this.appId;
    }

    public void appId_$eq(Option<ApplicationId> x$1) {
        this.appId = x$1;
    }

    private Option<ApplicationAttemptId> attemptId() {
        return this.attemptId;
    }

    private void attemptId_$eq(Option<ApplicationAttemptId> x$1) {
        this.attemptId = x$1;
    }

    private BlockManagerMaster blockManagerMaster() {
        return this.blockManagerMaster;
    }

    private double minMergersThresholdRatio() {
        return this.minMergersThresholdRatio;
    }

    private double minMergersStaticThreshold() {
        return this.minMergersStaticThreshold;
    }

    private int maxNumExecutors() {
        return this.maxNumExecutors;
    }

    private int numExecutors() {
        return this.numExecutors;
    }

    public void bindToYarn(ApplicationId appId, Option<ApplicationAttemptId> attemptId) {
        this.appId_$eq((Option<ApplicationId>)new Some((Object)appId));
        this.attemptId_$eq(attemptId);
    }

    public void startBindings() {
        Predef$.MODULE$.require(this.appId().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "application ID unset");
    }

    public void stop() {
        try {
            this.requestTotalExecutors(Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty());
            super.stop();
        }
        finally {
            this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().set(true);
        }
    }

    public Option<String> applicationAttemptId() {
        return this.attemptId().map((Function1 & Serializable & scala.Serializable)x$1 -> ((Object)BoxesRunTime.boxToInteger((int)x$1.getAttemptId())).toString());
    }

    public String applicationId() {
        return (String)this.appId().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Application ID is not initialized yet.");
            return this.super$applicationId();
        });
    }

    public CoarseGrainedClusterMessages.RequestExecutors prepareRequestExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        Set excludedNodes = this.scheduler.excludedNodes();
        Map filteredRPHostToLocalTaskCount = (Map)this.rpHostToLocalTaskCount().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int rpid = tuple2._1$mcI$sp();
            Map v = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)rpid), v.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)YarnSchedulerBackend.$anonfun$prepareRequestExecutors$2(excludedNodes, x0$2))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return new CoarseGrainedClusterMessages.RequestExecutors(resourceProfileToTotalExecs, this.numLocalityAwareTasksPerResourceProfileId(), filteredRPHostToLocalTaskCount, excludedNodes);
    }

    public Future<Object> doRequestTotalExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        return this.yarnSchedulerEndpointRef().ask((Object)this.prepareRequestExecutors(resourceProfileToTotalExecs), ClassTag$.MODULE$.Boolean());
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return this.yarnSchedulerEndpointRef().ask((Object)new CoarseGrainedClusterMessages.KillExecutors(executorIds), ClassTag$.MODULE$.Boolean());
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.totalExpectedExecutors() * this.minRegisteredRatio();
    }

    public Seq<BlockManagerId> getShufflePushMergerLocations(int numPartitions, int resourceProfileId) {
        Seq seq;
        int maxExecutors = Utils$.MODULE$.isDynamicAllocationEnabled(this.sc.getConf()) ? this.maxNumExecutors() : this.numExecutors();
        int tasksPerExecutor = this.sc.resourceProfileManager().resourceProfileFromId(resourceProfileId).maxTasksPerExecutor(this.sc.conf());
        int numMergersDesired = package$.MODULE$.min(package$.MODULE$.max(1, (int)package$.MODULE$.ceil((double)(numPartitions / tasksPerExecutor))), maxExecutors);
        double minMergersNeeded = package$.MODULE$.max(this.minMergersStaticThreshold(), (double)((int)package$.MODULE$.floor((double)numMergersDesired * this.minMergersThresholdRatio())));
        Seq mergerLocations = this.blockManagerMaster().getShufflePushMergerLocations(numMergersDesired, this.scheduler.excludedNodes());
        if (mergerLocations.size() < numMergersDesired && (double)mergerLocations.size() < minMergersNeeded) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("The number of shuffle mergers desired ").append(numMergersDesired).append(" and available locations are ").append(mergerLocations.length()).toString());
            seq = mergerLocations;
        }
        return seq;
    }

    public void addWebUIFilter(String filterName, Map<String, String> filterParams, String proxyBase) {
        block0: {
            boolean hasFilter;
            Object object = proxyBase != null && new StringOps(Predef$.MODULE$.augmentString(proxyBase)).nonEmpty() ? System.setProperty("spark.ui.proxyBase", proxyBase) : BoxedUnit.UNIT;
            boolean bl = hasFilter = filterName != null && new StringOps(Predef$.MODULE$.augmentString(filterName)).nonEmpty() && filterParams != null && filterParams.nonEmpty();
            if (!hasFilter) break block0;
            Seq allFilters = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{filterName}))).$plus$plus((GenTraversableOnce)this.conf().get(UI$.MODULE$.UI_FILTERS()), Seq$.MODULE$.canBuildFrom());
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Add WebUI Filter. ").append(filterName).append(", ").append(filterParams).append(", ").append(proxyBase).toString());
            this.scheduler.sc().ui().foreach((Function1 & Serializable & scala.Serializable)ui -> {
                YarnSchedulerBackend.$anonfun$addWebUIFilter$2(this, filterParams, filterName, allFilters, ui);
                return BoxedUnit.UNIT;
            });
        }
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new YarnDriverEndpoint(this);
    }

    public void reset() {
        super.reset();
        this.sc.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.reset();
            return BoxedUnit.UNIT;
        });
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.sc.conf(), this.sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public static final /* synthetic */ boolean $anonfun$prepareRequestExecutors$2(Set excludedNodes$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String host = (String)tuple2._1();
        boolean bl = !excludedNodes$1.contains((Object)host);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addWebUIFilter$4(String filterName$1, Map filterParams$1, DelegatingServletContextHandler h) {
        h.addFilter(filterName$1, filterName$1, filterParams$1);
        h.prependFilterMapping(filterName$1, "/*", EnumSet.allOf(DispatcherType.class));
    }

    public static final /* synthetic */ void $anonfun$addWebUIFilter$2(YarnSchedulerBackend $this, Map filterParams$1, String filterName$1, Seq allFilters$1, SparkUI ui) {
        SparkUI sparkUI = ui;
        synchronized (sparkUI) {
            filterParams$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                SparkConf sparkConf = $this.conf().set(new StringBuilder(13).append("spark.").append(filterName$1).append(".param.").append(k).toString(), v);
                return sparkConf;
            });
            $this.conf().set(UI$.MODULE$.UI_FILTERS(), (Object)allFilters$1);
            ui.getDelegatingHandlers().foreach((Function1 & Serializable & scala.Serializable)h -> {
                YarnSchedulerBackend.$anonfun$addWebUIFilter$4(filterName$1, filterParams$1, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public YarnSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.scheduler = scheduler;
        this.sc = sc;
        super(scheduler, sc.env().rpcEnv());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped = new AtomicBoolean(false);
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.totalExpectedExecutors = 0;
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint = new YarnSchedulerEndpoint(this, this.rpcEnv());
        this.amEndpoint = None$.MODULE$;
        this.yarnSchedulerEndpointRef = this.rpcEnv().setupEndpoint(YarnSchedulerBackend$.MODULE$.ENDPOINT_NAME(), (RpcEndpoint)this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout = RpcUtils$.MODULE$.askRpcTimeout(sc.conf());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$schedulerEndpointEC = ExecutionContext$.MODULE$.fromExecutorService(ThreadUtils$.MODULE$.newDaemonSingleThreadExecutor("yarn-scheduler-endpoint"));
        this.appId = None$.MODULE$;
        this.attemptId = None$.MODULE$;
        this.blockManagerMaster = sc.env().blockManager().master();
        this.minMergersThresholdRatio = BoxesRunTime.unboxToDouble((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MERGER_LOCATIONS_MIN_THRESHOLD_RATIO()));
        this.minMergersStaticThreshold = BoxesRunTime.unboxToDouble((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MERGER_LOCATIONS_MIN_STATIC_THRESHOLD()));
        this.maxNumExecutors = BoxesRunTime.unboxToInt((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MAX_EXECUTORS()));
        this.numExecutors = BoxesRunTime.unboxToInt((Object)((Option)this.conf().get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public class YarnDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> {
                YarnDriverEndpoint.$anonfun$onDisconnected$1(this, rpcAddress, executorId);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ YarnSchedulerBackend org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer() {
            return (YarnSchedulerBackend)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onDisconnected$1(YarnDriverEndpoint $this, RpcAddress rpcAddress$1, String executorId) {
            block0: {
                if ($this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().get() || !$this.disableExecutor(executorId)) break block0;
                $this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver(executorId, rpcAddress$1);
            }
        }

        public YarnDriverEndpoint(YarnSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }

    public class YarnSchedulerEndpoint
    implements ThreadSafeRpcEndpoint,
    Logging {
        private final RpcEnv rpcEnv;
        private transient Logger org$apache$spark$internal$Logging$$log_;
        public final /* synthetic */ YarnSchedulerBackend $outer;

        public String logName() {
            return Logging.logName$((Logging)this);
        }

        public Logger log() {
            return Logging.log$((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.logInfo$((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.logDebug$((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.logTrace$((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.logWarning$((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.logError$((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$((Logging)this);
        }

        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
        }

        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
        }

        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$((Logging)this);
        }

        public void initializeForcefully(boolean isInterpreter, boolean silent) {
            Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
        }

        public final RpcEndpointRef self() {
            return RpcEndpoint.self$((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public void onStart() {
            RpcEndpoint.onStart$((RpcEndpoint)this);
        }

        public void onStop() {
            RpcEndpoint.onStop$((RpcEndpoint)this);
        }

        public final void stop() {
            RpcEndpoint.stop$((RpcEndpoint)this);
        }

        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public void org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver(String executorId, RpcAddress executorRpcAddress) {
            Future future;
            Option<RpcEndpointRef> option = this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint();
            if (option instanceof Some) {
                Some some = (Some)option;
                RpcEndpointRef am = (RpcEndpointRef)some.value();
                CoarseGrainedClusterMessages.GetExecutorLossReason lossReasonRequest = new CoarseGrainedClusterMessages.GetExecutorLossReason(executorId);
                future = am.ask((Object)lossReasonRequest, this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout(), ClassTag$.MODULE$.apply(ExecutorLossReason.class)).map((Function1 & Serializable & scala.Serializable)reason -> new CoarseGrainedClusterMessages.RemoveExecutor(executorId, reason), (ExecutionContext)ThreadUtils$.MODULE$.sameThread()).recover((PartialFunction)new scala.Serializable(this, executorId, executorRpcAddress){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ YarnSchedulerEndpoint $outer;
                    private final String executorId$1;
                    private final RpcAddress executorRpcAddress$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("Attempted to get executor loss reason").append(" for executor id ").append($this.executorId$1).append(" at RPC address ").append($this.executorRpcAddress$1).append(",").append(" but got no response. Marking as agent lost.").toString(), e);
                            object = new CoarseGrainedClusterMessages.RemoveExecutor(this.executorId$1, (ExecutorLossReason)new ExecutorProcessLost(ExecutorProcessLost$.MODULE$.apply$default$1(), ExecutorProcessLost$.MODULE$.apply$default$2(), ExecutorProcessLost$.MODULE$.apply$default$3()));
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executorId$1 = executorId$1;
                        this.executorRpcAddress$1 = executorRpcAddress$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$1 )}, serializedLambda);
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            } else if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to check for an executor loss reason before the AM has registered!");
                future = Future$.MODULE$.successful((Object)new CoarseGrainedClusterMessages.RemoveExecutor(executorId, (ExecutorLossReason)new ExecutorProcessLost("AM is not yet registered.", ExecutorProcessLost$.MODULE$.apply$default$2(), ExecutorProcessLost$.MODULE$.apply$default$3())));
            } else {
                throw new MatchError(option);
            }
            Future removeExecutorMessage = future;
            removeExecutorMessage.foreach((Function1 & Serializable & scala.Serializable)message -> {
                YarnSchedulerEndpoint.$anonfun$org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver$3(this, message);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$schedulerEndpointEC());
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnSchedulerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterClusterManager) {
                        CoarseGrainedClusterMessages.RegisterClusterManager registerClusterManager = (CoarseGrainedClusterMessages.RegisterClusterManager)A1;
                        RpcEndpointRef am = registerClusterManager.am();
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("ApplicationMaster registered as ").append(am).toString());
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint_$eq((Option<RpcEndpointRef>)Option$.MODULE$.apply((Object)am));
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().reset();
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.AddWebUIFilter) {
                        CoarseGrainedClusterMessages.AddWebUIFilter addWebUIFilter = (CoarseGrainedClusterMessages.AddWebUIFilter)A1;
                        String filterName = addWebUIFilter.filterName();
                        Map filterParams = addWebUIFilter.filterParams();
                        String proxyBase = addWebUIFilter.proxyBase();
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().addWebUIFilter(filterName, (Map<String, String>)filterParams, proxyBase);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.RemoveExecutor removeExecutor = (CoarseGrainedClusterMessages.RemoveExecutor)A1;
                        String executorId = removeExecutor.executorId();
                        ExecutorLossReason reason = removeExecutor.reason();
                        if (!this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().get()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Requesting driver to remove executor ").append(executorId).append(" for reason ").append(reason).toString());
                            this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)removeExecutor);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RegisterClusterManager ? true : (object instanceof CoarseGrainedClusterMessages.AddWebUIFilter ? true : object instanceof CoarseGrainedClusterMessages.RemoveExecutor);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.rpc.RpcEndpointRef ), $anonfun$applyOrElse$3(java.lang.String org.apache.spark.scheduler.ExecutorLossReason )}, serializedLambda);
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new scala.Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnSchedulerEndpoint $outer;
                public final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RequestExecutors) {
                        CoarseGrainedClusterMessages.RequestExecutors requestExecutors = (CoarseGrainedClusterMessages.RequestExecutors)A1;
                        Option<RpcEndpointRef> option = this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RpcEndpointRef am = (RpcEndpointRef)some.value();
                            am.ask((Object)requestExecutors, ClassTag$.MODULE$.Boolean()).andThen((PartialFunction)new scala.Serializable(this, requestExecutors){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ YarnSchedulerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final CoarseGrainedClusterMessages.RequestExecutors x2$1;

                                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Object object;
                                    A1 A1 = x1;
                                    if (A1 instanceof Success) {
                                        Success success = (Success)A1;
                                        boolean b = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)b));
                                        object = BoxedUnit.UNIT;
                                    } else if (A1 instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)A1).exception())).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending ").append($this.x2$1).append(" to AM was unsuccessful").toString(), e);
                                        this.$outer.context$1.sendFailure(e);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x1);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Try<Object> x1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Try<Object> try_ = x1;
                                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty();
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x2$1 = x2$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$receiveAndReply$1$$anonfun$applyOrElse$4 )}, serializedLambda);
                                }
                            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to request executors before the AM has registered!");
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(option);
                        }
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.KillExecutors) {
                        CoarseGrainedClusterMessages.KillExecutors killExecutors = (CoarseGrainedClusterMessages.KillExecutors)A1;
                        Option<RpcEndpointRef> option = this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RpcEndpointRef am = (RpcEndpointRef)some.value();
                            am.ask((Object)killExecutors, ClassTag$.MODULE$.Boolean()).andThen((PartialFunction)new scala.Serializable(this, killExecutors){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ YarnSchedulerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final CoarseGrainedClusterMessages.KillExecutors x3$1;

                                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Object object;
                                    A1 A1 = x2;
                                    if (A1 instanceof Success) {
                                        Success success = (Success)A1;
                                        boolean b = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)b));
                                        object = BoxedUnit.UNIT;
                                    } else if (A1 instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)A1).exception())).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending ").append($this.x3$1).append(" to AM was unsuccessful").toString(), e);
                                        this.$outer.context$1.sendFailure(e);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x2);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Try<Object> x2) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Try<Object> try_ = x2;
                                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty();
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x3$1 = x3$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$8(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$receiveAndReply$1$$anonfun$applyOrElse$7 )}, serializedLambda);
                                }
                            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to kill executors before the AM has registered!");
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(option);
                        }
                        object = BoxedUnit.UNIT;
                    } else if (CoarseGrainedClusterMessages.RetrieveLastAllocatedExecutorId$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().currentExecutorIdCounter()));
                        object = BoxedUnit.UNIT;
                    } else if (CoarseGrainedClusterMessages.RetrieveDelegationTokens$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().currentDelegationTokens());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RequestExecutors ? true : (object instanceof CoarseGrainedClusterMessages.KillExecutors ? true : (CoarseGrainedClusterMessages.RetrieveLastAllocatedExecutorId$.MODULE$.equals(object) ? true : CoarseGrainedClusterMessages.RetrieveDelegationTokens$.MODULE$.equals(object)));
                    return bl;
                }

                public /* synthetic */ YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(), $anonfun$applyOrElse$9()}, serializedLambda);
                }
            };
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            block0: {
                if (!this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)YarnSchedulerEndpoint.$anonfun$onDisconnected$2(remoteAddress, x$4)))) break block0;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("ApplicationMaster has disassociated: ").append(remoteAddress).toString());
                this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint_$eq((Option<RpcEndpointRef>)None$.MODULE$);
            }
        }

        public /* synthetic */ YarnSchedulerBackend org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver$3(YarnSchedulerEndpoint $this, CoarseGrainedClusterMessages.RemoveExecutor message) {
            $this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)message);
        }

        public static final /* synthetic */ boolean $anonfun$onDisconnected$2(RpcAddress remoteAddress$1, RpcEndpointRef x$4) {
            RpcAddress rpcAddress = x$4.address();
            RpcAddress rpcAddress2 = remoteAddress$1;
            return !(rpcAddress != null ? !rpcAddress.equals(rpcAddress2) : rpcAddress2 != null);
        }

        public YarnSchedulerEndpoint(YarnSchedulerBackend $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.$init$((RpcEndpoint)this);
            Logging.$init$((Logging)this);
        }
    }
}

