/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ContainerLocalityPreferences;
import org.apache.spark.deploy.yarn.SparkRackResolver;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005mc!B\u0006\r\u000111\u0002\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011A\u0010\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0001B\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\t_\u0001\u0011\t\u0011)A\u0005O!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00036\u0001\u0011\u0005a\u0007C\u0003<\u0001\u0011\u0005A\bC\u0004\u00024\u0001!I!!\u000e\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u0011Q\n\u0001\u0005\n\u0005=#a\u000b'pG\u0006d\u0017\u000e^=Qe\u00164WM\u001d:fI\u000e{g\u000e^1j]\u0016\u0014\b\u000b\\1dK6,g\u000e^*ue\u0006$XmZ=\u000b\u00055q\u0011\u0001B=be:T!a\u0004\t\u0002\r\u0011,\u0007\u000f\\8z\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u0006I1\u000f]1sW\u000e{gNZ\u0002\u0001+\u0005\u0001\u0003CA\u0011#\u001b\u0005\u0001\u0012BA\u0012\u0011\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0006ta\u0006\u00148nQ8oM\u0002\n\u0001\"_1s]\u000e{gNZ\u000b\u0002OA\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0005G>tgM\u0003\u0002-%\u00051\u0001.\u00193p_BL!AL\u0015\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003%I\u0018M\u001d8D_:4\u0007%\u0001\u0005sKN|GN^3s!\t\u00114'D\u0001\r\u0013\t!DBA\tTa\u0006\u00148NU1dWJ+7o\u001c7wKJ\fa\u0001P5oSRtD\u0003B\u001c9si\u0002\"A\r\u0001\t\u000bu1\u0001\u0019\u0001\u0011\t\u000b\u00152\u0001\u0019A\u0014\t\u000bA2\u0001\u0019A\u0019\u0002;1|7-\u00197jif|eMU3rk\u0016\u001cH/\u001a3D_:$\u0018-\u001b8feN$\u0002\"P\"I\u0015j\u0003\u00181\u0005\t\u00041y\u0002\u0015BA \u001a\u0005\u0015\t%O]1z!\t\u0011\u0014)\u0003\u0002C\u0019\ta2i\u001c8uC&tWM\u001d'pG\u0006d\u0017\u000e^=Qe\u00164WM]3oG\u0016\u001c\b\"\u0002#\b\u0001\u0004)\u0015\u0001\u00048v[\u000e{g\u000e^1j]\u0016\u0014\bC\u0001\rG\u0013\t9\u0015DA\u0002J]RDQ!S\u0004A\u0002\u0015\u000bQC\\;n\u0019>\u001c\u0017\r\\5us\u0006;\u0018M]3UCN\\7\u000fC\u0003L\u000f\u0001\u0007A*\u0001\u000bi_N$Hk\u001c'pG\u0006dG+Y:l\u0007>,h\u000e\u001e\t\u0005\u001bR;VI\u0004\u0002O%B\u0011q*G\u0007\u0002!*\u0011\u0011KH\u0001\u0007yI|w\u000e\u001e \n\u0005MK\u0012A\u0002)sK\u0012,g-\u0003\u0002V-\n\u0019Q*\u00199\u000b\u0005MK\u0002CA'Y\u0013\tIfK\u0001\u0004TiJLgn\u001a\u0005\u00067\u001e\u0001\r\u0001X\u0001\u001dC2dwnY1uK\u0012Dun\u001d;U_\u000e{g\u000e^1j]\u0016\u00148/T1q!\u0011i&m\u00163\u000e\u0003yS!a\u00181\u0002\u000f5,H/\u00192mK*\u0011\u0011-G\u0001\u000bG>dG.Z2uS>t\u0017BA2_\u0005\u001dA\u0015m\u001d5NCB\u00042!X3h\u0013\t1gLA\u0002TKR\u0004\"\u0001\u001b8\u000e\u0003%T!A[6\u0002\u000fI,7m\u001c:eg*\u0011A.\\\u0001\u0004CBL'BA\u0007,\u0013\ty\u0017NA\u0006D_:$\u0018-\u001b8fe&#\u0007\"B9\b\u0001\u0004\u0011\u0018!\t7pG\u0006d\u0017\u000e^=NCR\u001c\u0007.\u001a3QK:$\u0017N\\4BY2|7-\u0019;j_:\u001c\bcA:yw:\u0011AO\u001e\b\u0003\u001fVL\u0011AG\u0005\u0003of\tq\u0001]1dW\u0006<W-\u0003\u0002zu\n\u00191+Z9\u000b\u0005]L\u0002c\u0001?\u0002\u001e9\u0019Q0a\u0006\u000f\u0007y\f\u0019BD\u0002\u0000\u0003\u001fqA!!\u0001\u0002\u000e9!\u00111AA\u0006\u001d\u0011\t)!!\u0003\u000f\u0007=\u000b9!C\u0001\u0016\u0013\t\u0019B#\u0003\u0002-%%\u0011QbK\u0005\u0004\u0003#i\u0017AB2mS\u0016tG/C\u0002m\u0003+Q1!!\u0005n\u0013\u0011\tI\"a\u0007\u0002\u0015\u0005k%+T\"mS\u0016tGOC\u0002m\u0003+IA!a\b\u0002\"\t\u00012i\u001c8uC&tWM\u001d*fcV,7\u000f\u001e\u0006\u0005\u00033\tY\u0002C\u0004\u0002&\u001d\u0001\r!a\n\u0002\u0005I\u0004\b\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055\u0002#\u0001\u0005sKN|WO]2f\u0013\u0011\t\t$a\u000b\u0003\u001fI+7o\\;sG\u0016\u0004&o\u001c4jY\u0016\f1C\\;n\u000bb,7-\u001e;peN\u0004VM\u001c3j]\u001e$R!RA\u001c\u0003wAa!!\u000f\t\u0001\u0004)\u0015a\u00048v[R\u000b7o[:QK:$\u0017N\\4\t\u000f\u0005\u0015\u0002\u00021\u0001\u0002(\u0005aR\r\u001f9fGR,G\rS8tiR{7i\u001c8uC&tWM]\"pk:$Hc\u0003'\u0002B\u0005\u0015\u0013qIA%\u0003\u0017Ba!a\u0011\n\u0001\u0004)\u0015A\u00057pG\u0006d\u0017\u000e^=Bo\u0006\u0014X\rV1tWNDQaS\u0005A\u00021CQaW\u0005A\u0002qCQ!]\u0005A\u0002IDq!!\n\n\u0001\u0004\t9#A\u000eqK:$\u0017N\\4I_N$Hk\\\"p]R\f\u0017N\\3s\u0007>,h\u000e\u001e\u000b\u0005\u0003#\nI\u0006E\u0003N)^\u000b\u0019\u0006E\u0002\u0019\u0003+J1!a\u0016\u001a\u0005\u0019!u.\u001e2mK\")\u0011O\u0003a\u0001e\u0002")
public class LocalityPreferredContainerPlacementStrategy {
    private final SparkConf sparkConf;
    private final Configuration yarnConf;
    private final SparkRackResolver resolver;

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Configuration yarnConf() {
        return this.yarnConf;
    }

    public ContainerLocalityPreferences[] localityOfRequestedContainers(int numContainer, int numLocalityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap, Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations, ResourceProfile rp) {
        ArrayBuffer containerLocalityPreferences;
        block1: {
            Map<String, Object> updatedHostToContainerCount = this.expectedHostToContainerCount(numLocalityAwareTasks, hostToLocalTaskCount, allocatedHostToContainersMap, localityMatchedPendingAllocations, rp);
            int updatedLocalityAwareContainerNum = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            int requiredLocalityFreeContainerNum = scala.math.package$.MODULE$.max(0, numContainer - updatedLocalityAwareContainerNum);
            int requiredLocalityAwareContainerNum = numContainer - requiredLocalityFreeContainerNum;
            containerLocalityPreferences = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (requiredLocalityFreeContainerNum > 0) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityFreeContainerNum).foreach((Function1 & Serializable & scala.Serializable)i -> containerLocalityPreferences.$plus$eq((Object)new ContainerLocalityPreferences(null, null)));
            }
            if (requiredLocalityAwareContainerNum <= 0) break block1;
            int largestRatio = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().max((Ordering)Ordering.Int$.MODULE$));
            ObjectRef preferredLocalityRatio = ObjectRef.create((Object)((Map)updatedHostToContainerCount.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                int ratio = tuple2._2$mcI$sp();
                double adjustedRatio = (double)ratio * (double)requiredLocalityAwareContainerNum / (double)largestRatio;
                Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(adjustedRatio)))));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())));
            int maxLocalities = BoxesRunTime.unboxToInt((Object)this.sparkConf().get(package$.MODULE$.MAX_CONTAINER_LOCALITIES()));
            Random rand = new Random(Utils$.MODULE$.random().nextLong());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityAwareContainerNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                String[] hosts = (String[])((MapLike)((Map)preferredLocalityRatio$1.elem).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LocalityPreferredContainerPlacementStrategy.$anonfun$localityOfRequestedContainers$4(x$1)))).keys().toArray(ClassTag$.MODULE$.apply(String.class));
                if (maxLocalities >= 0 && maxLocalities < hosts.length) {
                    hosts = (String[])((TraversableOnce)((IterableLike)rand.shuffle((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hosts)).toSeq(), Seq$.MODULE$.canBuildFrom())).take(maxLocalities)).toArray(ClassTag$.MODULE$.apply(String.class));
                }
                scala.collection.immutable.Set racks = ((TraversableOnce)((TraversableLike)$this.resolver.resolve((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])hosts)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getNetworkLocation(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LocalityPreferredContainerPlacementStrategy.$anonfun$localityOfRequestedContainers$6(x$3)))).toSet();
                ArrayBuffer arrayBuffer = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hosts)).nonEmpty() ? containerLocalityPreferences.$plus$eq((Object)new ContainerLocalityPreferences(hosts, (String[])racks.toArray(ClassTag$.MODULE$.apply(String.class)))) : containerLocalityPreferences.$plus$eq((Object)new ContainerLocalityPreferences(null, null));
                preferredLocalityRatio$1.elem = (Map)((Map)preferredLocalityRatio$1.elem).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    int v = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)(v - 1)));
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom());
            });
        }
        return (ContainerLocalityPreferences[])containerLocalityPreferences.toArray(ClassTag$.MODULE$.apply(ContainerLocalityPreferences.class));
    }

    private int numExecutorsPending(int numTasksPending, ResourceProfile rp) {
        int tasksPerExec = rp.maxTasksPerExecutor(this.sparkConf());
        return (int)scala.math.package$.MODULE$.ceil((double)numTasksPending / (double)tasksPerExec);
    }

    private Map<String, Object> expectedHostToContainerCount(int localityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap, Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations, ResourceProfile rp) {
        int totalLocalTaskNum = BoxesRunTime.unboxToInt((Object)hostToLocalTaskCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Map<String, Object> pendingHostToContainersMap = this.pendingHostToContainerCount(localityMatchedPendingAllocations);
        return (Map)hostToLocalTaskCount.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            double expectedCount = (double)count * (double)this.numExecutorsPending(localityAwareTasks, rp) / (double)totalLocalTaskNum;
            double existedCount = (double)BoxesRunTime.unboxToInt((Object)allocatedHostToContainersMap.get((Object)host).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + BoxesRunTime.unboxToDouble((Object)pendingHostToContainersMap.getOrElse((Object)host, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
            Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(0, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(expectedCount - existedCount)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    private Map<String, Object> pendingHostToContainerCount(Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        HashMap pendingHostToContainerCount = new HashMap();
        localityMatchedPendingAllocations.foreach((Function1 & Serializable & scala.Serializable)cr -> {
            LocalityPreferredContainerPlacementStrategy.$anonfun$pendingHostToContainerCount$1(pendingHostToContainerCount, cr);
            return BoxedUnit.UNIT;
        });
        int possibleTotalContainerNum = BoxesRunTime.unboxToInt((Object)pendingHostToContainerCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        double localityMatchedPendingNum = localityMatchedPendingAllocations.size();
        return ((TraversableOnce)pendingHostToContainerCount.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            int v = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToDouble((double)((double)v * localityMatchedPendingNum / (double)possibleTotalContainerNum)));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$localityOfRequestedContainers$4(Tuple2 x$1) {
        return x$1._2$mcI$sp() > 0;
    }

    public static final /* synthetic */ boolean $anonfun$localityOfRequestedContainers$6(String x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ void $anonfun$pendingHostToContainerCount$2(HashMap pendingHostToContainerCount$1, String n) {
        int count = BoxesRunTime.unboxToInt((Object)pendingHostToContainerCount$1.getOrElse((Object)n, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1;
        pendingHostToContainerCount$1.update((Object)n, (Object)BoxesRunTime.boxToInteger((int)count));
    }

    public static final /* synthetic */ void $anonfun$pendingHostToContainerCount$1(HashMap pendingHostToContainerCount$1, AMRMClient.ContainerRequest cr) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cr.getNodes()).asScala()).foreach((Function1 & Serializable & scala.Serializable)n -> {
            LocalityPreferredContainerPlacementStrategy.$anonfun$pendingHostToContainerCount$2(pendingHostToContainerCount$1, n);
            return BoxedUnit.UNIT;
        });
    }

    public LocalityPreferredContainerPlacementStrategy(SparkConf sparkConf, Configuration yarnConf, SparkRackResolver resolver) {
        this.sparkConf = sparkConf;
        this.yarnConf = yarnConf;
        this.resolver = resolver;
    }
}

