/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.fs.common;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.fs.Path;
import java.io.IOException;
import java.net.URI;
import java.util.StringTokenizer;

public class PanguUtils {
    private static String JOBID;
    private static Object mutex;
    private static final String DEFAULT_FS_PREFIX = "pangu://localcluster";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetJobId(String jobId) {
        Object object = mutex;
        synchronized (object) {
            JOBID = jobId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetJobId() {
        Object object = mutex;
        synchronized (object) {
            return JOBID;
        }
    }

    public static long getNextCntr(Configuration conf, long cntr, boolean isMem) {
        long statBase;
        long l = statBase = isMem ? conf.getLong("odps.mapred.instance.memory.stat.base", 10000L) : conf.getLong("odps.mapred.instance.record.stat.base", 1000000L);
        if (cntr >= statBase) {
            return cntr + statBase;
        }
        long statIncrFactor = isMem ? conf.getLong("odps.mapred.instance.memory.stat.increase.factor", 10L) : conf.getLong("odps.mapred.instance.record.stat.increase.factor", 10L);
        return statIncrFactor * cntr;
    }

    public static String getFsPrefix(Configuration conf, String path) {
        String fsPrefix = conf.get("fs.pangu.prefix");
        if (!PanguUtils.isEmptyStr(fsPrefix)) {
            return fsPrefix;
        }
        if (path.startsWith("pangu://")) {
            int pos = path.indexOf(47, 8);
            if (pos == -1) {
                return path;
            }
            return path.substring(0, pos);
        }
        return DEFAULT_FS_PREFIX;
    }

    public static String getRealUri(Configuration conf, String path) throws IOException {
        String fsPrefix = PanguUtils.getFsPrefix(conf, path);
        if (!fsPrefix.startsWith("pangu://")) {
            return path;
        }
        fsPrefix = fsPrefix.replaceAll("/+$", "");
        String subPath = PanguUtils.getSubPath(path);
        String tempDir = PanguUtils.getJobTempPath(conf);
        if (tempDir != null && subPath.contains(tempDir)) {
            URI uri = URI.create(fsPrefix);
            return uri.getScheme() + "://" + uri.getHost() + subPath;
        }
        return fsPrefix + subPath;
    }

    public static String getRealUri(Configuration conf, Path path) throws IOException {
        return PanguUtils.getRealUri(conf, path.toString());
    }

    public static String getWorkingDir(Configuration conf) {
        return conf.get("odps.mapred.working.dir", "/tmp/" + conf.get("odps.mapred.fuxi.user.name", "Odps"));
    }

    public static String getJobTempPath(Configuration conf) {
        String jobId = conf.get("odps.mapred.job.id");
        if (jobId == null) {
            jobId = JOBID;
        }
        if (jobId == null) {
            return null;
        }
        return conf.get("odps.mapred.pangu.job.temp.dir");
    }

    public static String getSubPath(String path) {
        if (path.startsWith("file:") || path.startsWith("pfile:")) {
            int idx = path.indexOf(47);
            while (idx + 1 < path.length() && path.charAt(idx + 1) == '/') {
                ++idx;
            }
            return path.substring(idx);
        }
        if (path.startsWith("pangu://") || path.startsWith("hdfs://")) {
            int pos = path.startsWith("pangu://") ? 8 : 7;
            path = path.substring(pos);
            int idx = path.indexOf(47);
            return path.substring(idx);
        }
        if (path.startsWith("/")) {
            return path;
        }
        throw new IllegalArgumentException("Illegal Path: " + path);
    }

    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".") && element.indexOf(":") < 0 && element.indexOf("/") < 0) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmptyStr(String str) {
        return str == null || str.length() == 0;
    }

    static {
        mutex = new Object();
    }
}

