/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.fs;

import com.aliyun.odps.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class TempResourceMapper {
    private static final String[] SPECIAL_POSTFIXES = new String[]{"tar.gz"};
    private static Map<String, String> pathMapping = new ConcurrentHashMap<String, String>();

    public static String get(String srcPath) {
        String fileName;
        String[] splits;
        String resourceInfo = TempResourceMapper.getResourceInfo(srcPath);
        if (resourceInfo != null) {
            return TempResourceMapper.getResourceName(resourceInfo);
        }
        String postfix = null;
        boolean isSpecialPostfix = false;
        for (int i = 0; i < SPECIAL_POSTFIXES.length; ++i) {
            if (!srcPath.toLowerCase().endsWith(SPECIAL_POSTFIXES[i])) continue;
            isSpecialPostfix = true;
            postfix = SPECIAL_POSTFIXES[i];
            break;
        }
        if (!isSpecialPostfix && (splits = (fileName = new File(srcPath).getName()).split("\\.")).length > 0) {
            postfix = splits[splits.length - 1];
        }
        fileName = DigestUtils.md5Hex((byte[])srcPath.getBytes());
        if (postfix != null) {
            fileName = fileName + "." + postfix;
        }
        return fileName;
    }

    public static String getResourceInfo(String srcPath) {
        return pathMapping.get(srcPath);
    }

    public static String getResourceName(String resourceInfo) {
        return resourceInfo.split(",")[0];
    }

    public static long getResourceSize(String resourceInfo) {
        return Long.valueOf(resourceInfo.split(",")[1]);
    }

    public static long getResourceLastModifiedTime(String resourceInfo) {
        return Long.valueOf(resourceInfo.split(",")[2]);
    }

    public static void put(String srcPath, String resourceInfo) {
        pathMapping.put(srcPath, resourceInfo);
    }

    public static String getPathMappingInfo(String appId) {
        HashMap filterdPathMapping = new HashMap();
        if (appId != null) {
            for (Map.Entry<String, String> entry : pathMapping.entrySet()) {
                if (!entry.getKey().contains(appId)) continue;
                filterdPathMapping.put(entry.getKey(), entry.getValue());
            }
        } else {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : filterdPathMapping.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append((String)entry.getValue());
            sb.append("\n");
            pathMapping.remove(entry.getKey());
        }
        String content = sb.toString();
        return Base64.encodeBase64String((byte[])content.getBytes());
    }

    public static void load() {
        String pathMappingInfoBase64 = System.getenv("TRFS_PATH_MAPPING");
        if (!StringUtils.isEmpty((String)pathMappingInfoBase64)) {
            String[] lines;
            String pathMappingInfo = new String(Base64.decodeBase64((String)pathMappingInfoBase64));
            for (String line : lines = pathMappingInfo.split("\n")) {
                String entry = line.trim();
                String[] kv = entry.split("=");
                if (kv.length != 2) continue;
                pathMapping.put(kv[0], kv[1]);
                String tempResourceName = TempResourceMapper.getResourceName(kv[1]);
                pathMapping.put("trfs:/" + tempResourceName, kv[1]);
            }
        }
    }
}

