/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.fs;

import com.aliyun.odps.fs.FSInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class LocalFSFileInputStream
extends FSInputStream {
    FileInputStream fis;
    private long position;

    public LocalFSFileInputStream(File file) throws IOException {
        this.fis = new FileInputStream(file);
    }

    @Override
    public void seek(long pos) throws IOException {
        this.fis.getChannel().position(pos);
        this.position = pos;
    }

    @Override
    public long getPos() throws IOException {
        return this.position;
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public int available() throws IOException {
        return this.fis.available();
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }

    public boolean markSupport() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int value = this.fis.read();
        if (value >= 0) {
            ++this.position;
        }
        return value;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int value = this.fis.read(b, off, len);
        if (value > 0) {
            this.position += (long)value;
        }
        return value;
    }

    @Override
    public int read(long position, byte[] b, int off, int len) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(b, off, len);
        return this.fis.getChannel().read(bb, position);
    }

    @Override
    public long skip(long n) throws IOException {
        long value = this.fis.skip(n);
        if (value > 0L) {
            this.position += value;
        }
        return value;
    }
}

