/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.fs;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.conf.Configured;
import com.aliyun.odps.fs.FSDataInputStream;
import com.aliyun.odps.fs.FSDataOutputStream;
import com.aliyun.odps.fs.FileStatus;
import com.aliyun.odps.fs.Path;
import com.aliyun.odps.fs.PathFilter;
import com.aliyun.odps.util.Progressable;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FileSystem
extends Configured
implements Closeable {
    private static final String FS_DEFAULT_NAME_KEY = "fs.default.name";
    public static final Log LOG = LogFactory.getLog(FileSystem.class);
    private static final Cache CACHE = new Cache();
    private Cache.Key key;
    private Set<Path> deleteOnExit = new TreeSet<Path>();
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path file) {
            return true;
        }
    };

    public static FileSystem get(Configuration conf) throws IOException {
        return FileSystem.get(FileSystem.getDefaultUri(conf), conf);
    }

    public static URI getDefaultUri(Configuration conf) {
        return URI.create(FileSystem.fixName(conf.get(FS_DEFAULT_NAME_KEY, "file:///")));
    }

    public static void setDefaultUri(Configuration conf, URI uri) {
        conf.set(FS_DEFAULT_NAME_KEY, uri.toString());
    }

    public static void setDefaultUri(Configuration conf, String uri) {
        FileSystem.setDefaultUri(conf, URI.create(FileSystem.fixName(uri)));
    }

    public abstract void initialize(URI var1, Configuration var2) throws IOException;

    public abstract URI getUri();

    private static String fixName(String name) {
        if (name.equals("local")) {
            LOG.warn((Object)"\"local\" is a deprecated filesystem name. Use \"file:///\" instead.");
            name = "file:///";
        } else if (name.indexOf(47) == -1) {
            LOG.warn((Object)("\"" + name + "\" is a deprecated filesystem name. Use \"hdfs://" + name + "/\" instead."));
            name = "hdfs://" + name;
        }
        return name;
    }

    public static FileSystem get(URI uri, Configuration conf) throws IOException {
        URI defaultUri;
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        LOG.info((Object)("FileSystem:get scheme=" + scheme + " authority=" + authority));
        if (scheme == null) {
            return FileSystem.get(conf);
        }
        if (authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri(conf)).getScheme()) && defaultUri.getAuthority() != null) {
            return FileSystem.get(defaultUri, conf);
        }
        return CACHE.get(uri, conf);
    }

    public Path makeQualified(Path path) {
        this.checkPath(path);
        return path.makeQualified(this);
    }

    protected FileSystem() {
        super(null);
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        if (uri.getScheme() == null) {
            return;
        }
        String thisScheme = this.getUri().getScheme();
        String thatScheme = uri.getScheme();
        String thisAuthority = this.getUri().getAuthority();
        String thatAuthority = uri.getAuthority();
        if (thisScheme.equalsIgnoreCase(thatScheme)) {
            URI defaultUri;
            if (thisAuthority == thatAuthority || thisAuthority != null && thisAuthority.equalsIgnoreCase(thatAuthority) || thisAuthority != null && thatAuthority != null && thatAuthority.toLowerCase().contains(thisAuthority.toLowerCase())) {
                return;
            }
            if (thatAuthority == null && thisAuthority != null && thisScheme.equalsIgnoreCase((defaultUri = FileSystem.getDefaultUri(this.getConf())).getScheme()) && thisAuthority.equalsIgnoreCase(defaultUri.getAuthority())) {
                return;
            }
        }
        throw new IllegalArgumentException("Wrong FS: " + path + ", expected: " + this.getUri());
    }

    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    public FSDataInputStream open(Path f) throws IOException {
        return this.open(f, this.getConf().getInt("io.file.buffer.size", 4096));
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return this.create(f, true);
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.create(f, overwrite, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(), this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(), this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), replication, this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), replication, this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.create(f, overwrite, bufferSize, this.getDefaultReplication(), this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.create(f, overwrite, bufferSize, this.getDefaultReplication(), this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.create(f, overwrite, bufferSize, replication, blockSize, null);
    }

    public abstract FSDataOutputStream create(Path var1, boolean var2, int var3, short var4, long var5, Progressable var7) throws IOException;

    public boolean createNewFile(Path f) throws IOException {
        if (this.exists(f)) {
            return false;
        }
        this.create(f, false, this.getConf().getInt("io.file.buffer.size", 4096)).close();
        return true;
    }

    public FSDataOutputStream append(Path f) throws IOException {
        return this.append(f, this.getConf().getInt("io.file.buffer.size", 4096), null);
    }

    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        return this.append(f, bufferSize, null);
    }

    public abstract FSDataOutputStream append(Path var1, int var2, Progressable var3) throws IOException;

    public boolean setReplication(Path src, short replication) throws IOException {
        return true;
    }

    public abstract boolean rename(Path var1, Path var2) throws IOException;

    public abstract boolean delete(Path var1) throws IOException;

    public abstract boolean delete(Path var1, boolean var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteOnExit(Path f) throws IOException {
        if (!this.exists(f)) {
            return false;
        }
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            this.deleteOnExit.add(f);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeleteOnExit() {
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            Iterator<Path> iter = this.deleteOnExit.iterator();
            while (iter.hasNext()) {
                Path path = iter.next();
                try {
                    this.delete(path, true);
                }
                catch (IOException e) {
                    LOG.info((Object)("Ignoring failure to deleteOnExit for path " + path));
                }
                iter.remove();
            }
        }
    }

    public boolean exists(Path f) throws IOException {
        try {
            return this.getFileStatus(f) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isDirectory(Path f) throws IOException {
        try {
            return this.getFileStatus(f).isDir();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isFile(Path f) throws IOException {
        try {
            return !this.getFileStatus(f).isDir();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public abstract FileStatus[] listStatus(Path var1) throws IOException;

    private void listStatus(ArrayList<FileStatus> results, Path f, PathFilter filter) throws IOException {
        FileStatus[] listing = this.listStatus(f);
        if (listing != null) {
            for (int i = 0; i < listing.length; ++i) {
                if (!filter.accept(listing[i].getPath())) continue;
                results.add(listing[i]);
            }
        }
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        this.listStatus(results, f, filter);
        return results.toArray(new FileStatus[results.size()]);
    }

    public FileStatus[] listStatus(Path[] files) throws IOException {
        return this.listStatus(files, DEFAULT_FILTER);
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        for (int i = 0; i < files.length; ++i) {
            this.listStatus(results, files[i], filter);
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    public Path getHomeDirectory() {
        return new Path("/user/" + System.getProperty("user.name")).makeQualified(this);
    }

    public abstract void setWorkingDirectory(Path var1);

    public abstract Path getWorkingDirectory();

    public abstract boolean mkdirs(Path var1) throws IOException;

    public long getUsed() throws IOException {
        FileStatus[] files;
        long used = 0L;
        for (FileStatus file : files = this.listStatus(new Path("/"))) {
            used += file.getLen();
        }
        return used;
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.local.block.size", 0x2000000L);
    }

    public short getDefaultReplication() {
        return 1;
    }

    public abstract FileStatus getFileStatus(Path var1) throws IOException;

    public void setOwner(Path p, String username, String groupname) throws IOException {
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
    }

    private static FileSystem createFileSystem(URI uri, Configuration conf) throws IOException {
        Class clazz = conf.getClass("fs." + uri.getScheme() + ".impl", null);
        if (clazz == null) {
            throw new IOException("No FileSystem for scheme: " + uri.getScheme());
        }
        FileSystem fs = (FileSystem)ReflectionUtils.newInstanceFast((Class)clazz, (Configuration)conf);
        fs.initialize(uri, conf);
        return fs;
    }

    @Override
    public void close() throws IOException {
    }

    static class Cache {
        private final Map<Key, FileSystem> map = new HashMap<Key, FileSystem>();

        Cache() {
        }

        synchronized FileSystem get(URI uri, Configuration conf) throws IOException {
            Key key = new Key(uri, conf);
            FileSystem fs = this.map.get(key);
            if (fs == null) {
                fs = FileSystem.createFileSystem(uri, conf);
                fs.key = key;
                this.map.put(key, fs);
            }
            return fs;
        }

        synchronized void remove(Key key, FileSystem fs) {
            if (this.map.containsKey(key) && fs == this.map.get(key)) {
                this.map.remove(key);
            }
        }

        synchronized void closeAll() throws IOException {
            ArrayList<IOException> exceptions = new ArrayList<IOException>();
            while (!this.map.isEmpty()) {
                Map.Entry<Key, FileSystem> e = this.map.entrySet().iterator().next();
                Key key = e.getKey();
                FileSystem fs = e.getValue();
                this.remove(key, fs);
                if (fs == null) continue;
                try {
                    fs.close();
                }
                catch (IOException ioe) {
                    exceptions.add(ioe);
                }
            }
            if (!exceptions.isEmpty()) {
                throw new IOException("FileSystem:closeAll");
            }
        }

        static class Key {
            final String scheme;
            final String authority;
            final String username;

            Key(URI uri, Configuration conf) throws IOException {
                this.scheme = uri.getScheme() == null ? "" : uri.getScheme().toLowerCase();
                this.authority = uri.getAuthority() == null ? "" : uri.getAuthority().toLowerCase();
                this.username = null;
            }

            public int hashCode() {
                return (this.scheme + this.authority + this.username).hashCode();
            }

            static boolean isEqual(Object a, Object b) {
                return a == b || a != null && a.equals(b);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj != null && obj instanceof Key) {
                    Key that = (Key)obj;
                    return Key.isEqual(this.scheme, that.scheme) && Key.isEqual(this.authority, that.authority) && Key.isEqual(this.username, that.username);
                }
                return false;
            }

            public String toString() {
                return this.username + "@" + this.scheme + "://" + this.authority;
            }
        }
    }
}

