/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.fs;

import com.aliyun.odps.fs.Syncable;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FSDataOutputStream
extends DataOutputStream
implements Syncable {
    private OutputStream wrappedStream;

    public FSDataOutputStream(OutputStream out) throws IOException {
        this(out, 0L);
    }

    public FSDataOutputStream(OutputStream out, long startPosition) throws IOException {
        super(new PositionCache(out, startPosition));
        this.wrappedStream = out;
    }

    public long getPos() throws IOException {
        return ((PositionCache)this.out).getPos();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public OutputStream getWrappedStream() {
        return this.wrappedStream;
    }

    @Override
    public void sync() throws IOException {
        if (this.wrappedStream instanceof Syncable) {
            ((Syncable)((Object)this.wrappedStream)).sync();
        }
    }

    private static class PositionCache
    extends FilterOutputStream {
        long position;

        public PositionCache(OutputStream out, long pos) throws IOException {
            super(out);
            this.position = pos;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.position;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.position += (long)len;
        }

        public long getPos() throws IOException {
            return this.position;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

