/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.fs;

import com.aliyun.odps.fs.FSInputStream;
import com.aliyun.odps.fs.PositionedReadable;
import com.aliyun.odps.fs.Seekable;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;

public class BufferedFSInputStream
extends BufferedInputStream
implements Seekable,
PositionedReadable {
    public BufferedFSInputStream(FSInputStream in, int size) {
        super(in, size);
    }

    @Override
    public long getPos() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
        return ((FSInputStream)this.in).getPos() - (long)(this.count - this.pos);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.seek(this.getPos() + n);
        return n;
    }

    @Override
    public void seek(long pos) throws IOException {
        long end;
        long start;
        if (pos < 0L) {
            throw new EOFException("Cannot seek to negative offset");
        }
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
        if (this.pos != this.count && pos >= (start = (end = ((FSInputStream)this.in).getPos()) - (long)this.count) && pos < end) {
            this.pos = (int)(pos - start);
            return;
        }
        this.pos = 0;
        this.count = 0;
        ((FSInputStream)this.in).seek(pos);
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        this.pos = 0;
        this.count = 0;
        return ((FSInputStream)this.in).seekToNewSource(targetPos);
    }

    @Override
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return ((FSInputStream)this.in).read(position, buffer, offset, length);
    }

    @Override
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        ((FSInputStream)this.in).readFully(position, buffer, offset, length);
    }

    @Override
    public void readFully(long position, byte[] buffer) throws IOException {
        ((FSInputStream)this.in).readFully(position, buffer);
    }
}

