/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.requestcupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.FileResource;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.CupidUtil;
import com.aliyun.odps.cupid.requestcupid.CupidTaskRunningMode;
import com.aliyun.odps.cupid.requestcupid.RetryConst;
import com.aliyun.odps.cupid.requestcupid.RetryUtil;
import com.aliyun.odps.cupid.utils.JTuple;
import com.aliyun.odps.task.CupidTask;
import com.github.rholder.retry.RetryException;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class SubmitJobUtil {
    private static Logger logger = Logger.getLogger(SubmitJobUtil.class);
    private static final String[] SENSITIVE_KEYS = new String[]{"password", "secret", "access", "eventlog"};
    public static final String HIDDEN_CONTENT = "******";

    private static String uploadRes(CupidTaskParamProtos.CupidTaskParam cupidTaskParamPB, boolean planUseResource, CupidSession cupidSession) throws OdpsException {
        CupidSession submitCupidSession = cupidSession == null ? CupidSession.get() : cupidSession;
        String tmpResName = "cupid_plan_" + UUID.randomUUID().toString();
        FileResource res = new FileResource();
        res.setName(tmpResName);
        if (!planUseResource) {
            res.setIsTempResource(true);
        } else {
            logger.info((Object)("as longtime job,cupid plan use resource " + tmpResName));
        }
        Odps odps = submitCupidSession.odps();
        if (odps.resources().exists(odps.getDefaultProject(), tmpResName)) {
            odps.resources().update(odps.getDefaultProject(), res, (InputStream)new ByteArrayInputStream(cupidTaskParamPB.toByteArray()));
        } else {
            odps.resources().create(odps.getDefaultProject(), res, (InputStream)new ByteArrayInputStream(cupidTaskParamPB.toByteArray()));
        }
        return tmpResName;
    }

    protected static CupidTaskParamProtos.GetPartitionSizeResult getPartitionSizeSubmitJob(CupidTaskParamProtos.CupidTaskParam cupidTaskParamPB) throws Exception {
        Instance partitionSizeInstance = SubmitJobUtil.submitJob(cupidTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob);
        logger.info((Object)("partitionSizeInstance id = " + partitionSizeInstance.getId()));
        String getPartitionSizeResultStr = CupidUtil.pollSuccessResult(partitionSizeInstance, "getting partition size");
        return CupidTaskParamProtos.GetPartitionSizeResult.parseFrom(Base64.decodeBase64((String)getPartitionSizeResultStr));
    }

    protected static String genVolumePanguPathSubmitJob(CupidTaskParamProtos.CupidTaskParam cupidTaskParamPB) throws Exception {
        Instance genVolumePanguPathInstance = SubmitJobUtil.submitJob(cupidTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob);
        logger.info((Object)("genVolumePanguPathInfoInstance id = " + genVolumePanguPathInstance.getId()));
        String genVolumePanguPathResult = CupidUtil.pollSuccessResult(genVolumePanguPathInstance, "genVolumePanguPath size");
        return genVolumePanguPathResult;
    }

    protected static void ddlTaskSubmitJob(CupidTaskParamProtos.CupidTaskParam moyeTaskParamPB) throws Exception {
        Instance ddlTaskInstance = SubmitJobUtil.submitJob(moyeTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob);
        logger.info((Object)("ddlTaskSubmitJob instanceid = " + ddlTaskInstance.getId()));
        CupidUtil.pollSuccessResult(ddlTaskInstance, "do ddltask");
    }

    protected static void copyTempResourceSubmitJob(CupidSession session, CupidTaskParamProtos.CupidTaskParam moyeTaskParamPB) throws Exception {
        Instance cpInstance = SubmitJobUtil.submitJob(moyeTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob, null, false, session);
        logger.info((Object)("copy temp resource instanceid = " + cpInstance.getId()));
        CupidUtil.pollSuccessResult(cpInstance, "copy temp resource");
    }

    protected static void upgradeApplicationSubmitJob(CupidSession session, CupidTaskParamProtos.CupidTaskParam moyeTaskParamPB) throws Exception {
        Instance instance = SubmitJobUtil.submitJob(moyeTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob, null, false, session);
        logger.info((Object)("upgrade application instanceid = " + instance.getId()));
        CupidUtil.pollSuccessResult(instance, "upgrade application");
    }

    protected static CupidTaskParamProtos.ApplicationMeta getApplicationMetaSubmitJob(CupidTaskParamProtos.CupidTaskParam moyeTaskParamPB, CupidSession cupidSession) throws Exception {
        Instance cpInstance = SubmitJobUtil.submitJob(moyeTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob, cupidSession);
        logger.debug((Object)("getApplicationMeta instanceid = " + cpInstance.getId()));
        String getApplicationMetaResultStr = CupidUtil.pollSuccessResult(cpInstance, "getApplicationMeta");
        return CupidTaskParamProtos.ApplicationMeta.parseFrom(Base64.decodeBase64((byte[])getApplicationMetaResultStr.getBytes()));
    }

    protected static void createApplicationMetaSubmitJob(CupidTaskParamProtos.CupidTaskParam moyeTaskParamPB, CupidSession cupidSession) throws Exception {
        Instance cpInstance = SubmitJobUtil.submitJob(moyeTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob, cupidSession);
        logger.debug((Object)("createApplicationMeta instanceid = " + cpInstance.getId()));
        CupidUtil.pollSuccessResult(cpInstance, "createApplicationMeta");
    }

    protected static CupidTaskParamProtos.ApplicationMetaList listApplicationMetaSubmitJob(CupidTaskParamProtos.CupidTaskParam moyeTaskParamPB, CupidSession cupidSession) throws Exception {
        Instance cpInstance = SubmitJobUtil.submitJob(moyeTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob, cupidSession);
        logger.debug((Object)("listApplicationMeta instanceid = " + cpInstance.getId()));
        String listApplicationMetaResultStr = CupidUtil.pollSuccessResult(cpInstance, "listApplicationMeta");
        return CupidTaskParamProtos.ApplicationMetaList.parseFrom(Base64.decodeBase64((String)listApplicationMetaResultStr));
    }

    protected static void updateApplicationMetaSubmitJob(CupidTaskParamProtos.CupidTaskParam moyeTaskParamPB, CupidSession cupidSession) throws Exception {
        Instance cpInstance = SubmitJobUtil.submitJob(moyeTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob, cupidSession);
        logger.debug((Object)("updateApplicationMeta instanceid = " + cpInstance.getId()));
        CupidUtil.pollSuccessResult(cpInstance, "updateApplicationMeta");
    }

    protected static String getProxyTokenSubmitJob(CupidTaskParamProtos.CupidTaskParam moyeTaskParamPB, CupidSession cupidSession) throws Exception {
        Instance cpInstance = SubmitJobUtil.submitJob(moyeTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob, cupidSession);
        logger.debug((Object)("getProxyTokenSubmitJob instanceid = " + cpInstance.getId()));
        return CupidUtil.pollSuccessResult(cpInstance, "getCupidProxyToken");
    }

    protected static void cupidSetInformationSubmitJob(CupidTaskParamProtos.CupidTaskParam moyeTaskParamPB, CupidSession cupidSession) throws Exception {
        Instance cpInstance = SubmitJobUtil.submitJob(moyeTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob, cupidSession);
        logger.debug((Object)("cupidSetInformation instanceid = " + cpInstance.getId()));
        CupidUtil.pollSuccessResult(cpInstance, "cupidSetInformation");
    }

    protected static String sendTaskServiceRequestSubmitJob(CupidTaskParamProtos.CupidTaskParam moyeTaskParamPB, CupidSession cupidSession) throws Exception {
        Instance cpInstance = SubmitJobUtil.submitJob(moyeTaskParamPB, CupidTaskRunningMode.eAsyncNotFuxiJob, cupidSession);
        logger.info((Object)("sendTaskServiceRequestSubmitJob instanceid = " + cpInstance.getId()));
        return CupidUtil.pollSuccessResult(cpInstance, "sendTaskServiceRequest");
    }

    public static Instance submitJob(CupidTaskParamProtos.CupidTaskParam cupidTaskParamPB, String runningMode) throws ExecutionException, RetryException, OdpsException, FileNotFoundException {
        return SubmitJobUtil.submitJob(cupidTaskParamPB, runningMode, null, false, null);
    }

    public static Instance submitJob(CupidTaskParamProtos.CupidTaskParam cupidTaskParamPB, String runningMode, Integer priority) throws ExecutionException, RetryException, OdpsException, FileNotFoundException {
        return SubmitJobUtil.submitJob(cupidTaskParamPB, runningMode, priority, false, null);
    }

    public static Instance submitJob(CupidTaskParamProtos.CupidTaskParam cupidTaskParamPB, String runningMode, CupidSession cupidSession) throws ExecutionException, RetryException, OdpsException, FileNotFoundException {
        return SubmitJobUtil.submitJob(cupidTaskParamPB, runningMode, null, false, cupidSession);
    }

    public static Instance submitJob(final CupidTaskParamProtos.CupidTaskParam cupidTaskParamPB, String runningMode, Integer priority, final Boolean planUseResource, CupidSession cupidSession) throws ExecutionException, RetryException, FileNotFoundException, OdpsException {
        String runningCluster;
        final CupidSession submitCupidSession = cupidSession == null ? CupidSession.get() : cupidSession;
        String operator = "";
        if (cupidTaskParamPB.hasMcupidtaskoperator() && cupidTaskParamPB.getMcupidtaskoperator().hasMoperator()) {
            operator = cupidTaskParamPB.getMcupidtaskoperator().getMoperator();
        }
        logger.info((Object)("submitting CupidTask with " + submitCupidSession.odps().getAccount().getType() + " type, operator: " + operator));
        Callable<String> uploadResCallable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return SubmitJobUtil.uploadRes(cupidTaskParamPB, planUseResource, submitCupidSession);
            }
        };
        String cupidTaskInfo = RetryUtil.retryFunction(uploadResCallable, RetryConst.UPLOAD_RESOURCE, 2) + "," + submitCupidSession.odps().getDefaultProject() + "," + runningMode;
        if (submitCupidSession.isDryRunMode()) {
            if (CupidTaskRunningMode.eHasFuxiJob.equals(runningMode)) {
                System.out.println("CUPID_TASK_PLAN_INFO:" + cupidTaskInfo);
            }
            return null;
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("biz_id", submitCupidSession.biz_id);
        if (submitCupidSession.flightingMajorVersion != null) {
            propMap.put("odps.task.major.version", submitCupidSession.flightingMajorVersion);
        }
        for (JTuple.JTuple2<String, String> item : submitCupidSession.conf.getAll()) {
            String key = item._1();
            String value = item._2();
            propMap.put(key, SubmitJobUtil.isSensitive(key) ? HIDDEN_CONTENT : value);
        }
        if (System.getProperty("odps.exec.context.file") != null) {
            String path = System.getProperty("odps.exec.context.file");
            File file = new File(path);
            if (file.exists()) {
                InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
                Gson gson = new GsonBuilder().create();
                HashMap map = (HashMap)gson.fromJson((Reader)reader, new TypeToken<HashMap<Object, Object>>(){}.getType());
                Map smap = (Map)map.get("settings");
                for (Map.Entry item : smap.entrySet()) {
                    propMap.put((String)item.getKey(), (String)item.getValue());
                }
            } else {
                logger.warn((Object)("odps.exec.context.file not exist: " + path));
            }
        }
        if ((runningCluster = submitCupidSession.conf.get("odps.cupid.task.running.cluster", null)) == null) {
            if (priority != null) {
                return CupidTask.run((Odps)submitCupidSession.odps(), (String)submitCupidSession.odps().getDefaultProject(), (String)cupidTaskInfo, propMap, (int)priority);
            }
            return CupidTask.run((Odps)submitCupidSession.odps(), (String)submitCupidSession.odps().getDefaultProject(), (String)cupidTaskInfo, propMap);
        }
        return CupidTask.run((Odps)submitCupidSession.odps(), (String)submitCupidSession.odps().getDefaultProject(), (String)cupidTaskInfo, propMap, (Integer)priority, (String)runningCluster, null);
    }

    public static boolean isSensitive(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        String keyInLower = key.toLowerCase();
        for (String hideKey : SENSITIVE_KEYS) {
            if (keyInLower.length() < hideKey.length() || !keyInLower.contains(hideKey)) continue;
            return true;
        }
        return false;
    }
}

