/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.requestcupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.CupidTaskBaseUtil;
import com.aliyun.odps.cupid.requestcupid.CupidTaskOperatorConst;
import com.aliyun.odps.cupid.requestcupid.SubmitJobUtil;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;

public class DDLTaskUtil {
    private static Logger logger = Logger.getLogger(DDLTaskUtil.class);

    private static CupidTaskParamProtos.CupidTaskParam.Builder getMoyeTaskParamInfo() {
        CupidTaskParamProtos.CupidTaskParam.Builder cupidTaskParamBuilder = CupidTaskBaseUtil.getOperationBaseInfo(CupidSession.get(), CupidTaskOperatorConst.CUPID_TASK_DDLTASK, CupidSession.get().getJobLookupName(), null);
        return cupidTaskParamBuilder;
    }

    public static String ParsePartSpec(String partSpecIn) {
        PartitionSpec parsePartSpec = new PartitionSpec(partSpecIn);
        String parsePartOut = parsePartSpec.toString().trim().replaceAll("'", "");
        return parsePartOut;
    }

    private static CupidTaskParamProtos.DDLInfo.Builder getDDLTaskBaseInfo(String project, String table, boolean isOverWrite) {
        CupidTaskParamProtos.DDLInfo.Builder ddlInfoBuilder = CupidTaskParamProtos.DDLInfo.newBuilder();
        ddlInfoBuilder.setSaveTableProject(project);
        ddlInfoBuilder.setSaveTableName(table);
        ddlInfoBuilder.setIsOverWrite(isOverWrite);
        return ddlInfoBuilder;
    }

    private static void addDDLInfoItermForSaveMultiParittion(CupidTaskParamProtos.DDLInfo.Builder ddlInfoBuilder, Set<String> ddlTaskPaths) {
        String[] ddlTaskPathsArray = ddlTaskPaths.toArray(new String[ddlTaskPaths.size()]);
        CupidTaskParamProtos.DDLInfoIterm.Builder ddlInfoItermBuilder = CupidTaskParamProtos.DDLInfoIterm.newBuilder();
        ArrayList<String> outPutPartitionInfo = new ArrayList<String>();
        for (String ddlTaskPath : ddlTaskPathsArray) {
            String[] pathParams = ddlTaskPath.split("/");
            String pathPectOut = DDLTaskUtil.ParsePartSpec(pathParams[pathParams.length - 1]);
            ddlInfoItermBuilder.setPanguTempDirPath(ddlTaskPath);
            ddlInfoItermBuilder.setPartSpec(pathPectOut);
            if (outPutPartitionInfo.size() < 3) {
                outPutPartitionInfo.add(pathPectOut.toString());
            }
            ddlInfoBuilder.addDdlInfoIterms(ddlInfoItermBuilder.build());
        }
        String outputPartitionMesg = "the saved partition num = " + ddlTaskPathsArray.length + ", show some partition\n";
        for (String f : outPutPartitionInfo) {
            outputPartitionMesg = outputPartitionMesg + f + "\n";
        }
        logger.info((Object)outputPartitionMesg);
    }

    public static void doDDLTaskForSaveMultiParittion(String project, String table, boolean isOverWrite, Set<String> ddlTaskPaths) throws Exception {
        CupidTaskParamProtos.DDLInfo.Builder ddlInfoBuilder = DDLTaskUtil.getDDLTaskBaseInfo(project, table, isOverWrite);
        DDLTaskUtil.addDDLInfoItermForSaveMultiParittion(ddlInfoBuilder, ddlTaskPaths);
        CupidTaskParamProtos.CupidTaskParam.Builder moyeTaskParamBuilder = DDLTaskUtil.getMoyeTaskParamInfo();
        moyeTaskParamBuilder.setDdlInfo(ddlInfoBuilder.build());
        SubmitJobUtil.ddlTaskSubmitJob(moyeTaskParamBuilder.build());
    }

    public static void doDDLTaskForSaveMultiTables(CupidTaskParamProtos.DDLMultiTableInfos ddlMultiTables) throws Exception {
        CupidTaskParamProtos.CupidTaskParam.Builder moyeTaskParamBuilder = DDLTaskUtil.getMoyeTaskParamInfo();
        moyeTaskParamBuilder.setDdlMultiTableInfos(ddlMultiTables);
        SubmitJobUtil.ddlTaskSubmitJob(moyeTaskParamBuilder.build());
    }

    public static void doDDLTaskForNoarmalSave(String project, String table, String partSpecOut, boolean isOverWrite, String panguTempDirPath) throws Exception {
        CupidTaskParamProtos.DDLInfo.Builder ddlInfoBuilder = DDLTaskUtil.getDDLTaskBaseInfo(project, table, isOverWrite);
        CupidTaskParamProtos.DDLInfoIterm.Builder ddlInfoItermBuilder = CupidTaskParamProtos.DDLInfoIterm.newBuilder();
        ddlInfoItermBuilder.setPanguTempDirPath(panguTempDirPath);
        ddlInfoItermBuilder.setPartSpec(partSpecOut);
        ddlInfoBuilder.addDdlInfoIterms(ddlInfoItermBuilder.build());
        CupidTaskParamProtos.CupidTaskParam.Builder moyeTaskParamBuilder = DDLTaskUtil.getMoyeTaskParamInfo();
        moyeTaskParamBuilder.setDdlInfo(ddlInfoBuilder.build());
        SubmitJobUtil.ddlTaskSubmitJob(moyeTaskParamBuilder.build());
    }
}

