/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.requestcupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.FileResource;
import com.aliyun.odps.Odps;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.CupidTaskBaseUtil;
import com.aliyun.odps.cupid.requestcupid.CupidTaskOperatorConst;
import com.aliyun.odps.cupid.requestcupid.SubmitJobUtil;
import com.aliyun.odps.cupid.utils.JTuple;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class CopyTempResourceUtil {
    private static Logger logger = Logger.getLogger(CopyTempResourceUtil.class);

    private static String[] copyTempResourceToFuxiJobDir(CupidSession session, String[] tmpResources) throws Exception {
        CupidTaskParamProtos.CupidTaskParam.Builder cupidTaskParamBuilder = CupidTaskBaseUtil.getOperationBaseInfo(session, CupidTaskOperatorConst.CUPID_TASK_COPY_TEMPRESOURCE, session.getJobLookupName(), null);
        CupidTaskParamProtos.OdpsLocalResource.Builder odpsLocalResourceBuilder = CupidTaskParamProtos.OdpsLocalResource.newBuilder();
        CupidTaskParamProtos.OdpsLocalResourceItem.Builder odpsLocalResourceBuilderItemBuilder = CupidTaskParamProtos.OdpsLocalResourceItem.newBuilder();
        ArrayList<String> ret = new ArrayList<String>();
        for (String res : tmpResources) {
            ret.add(res);
            odpsLocalResourceBuilderItemBuilder.setProjectname(session.conf.get("odps.project.name"));
            odpsLocalResourceBuilderItemBuilder.setRelativefilepath(res);
            odpsLocalResourceBuilderItemBuilder.setType(CupidTaskParamProtos.LocalResourceType.TempResource);
            odpsLocalResourceBuilder.addLocalresourceitem(odpsLocalResourceBuilderItemBuilder.build());
        }
        cupidTaskParamBuilder.setLocalresource(odpsLocalResourceBuilder.build());
        SubmitJobUtil.copyTempResourceSubmitJob(session, cupidTaskParamBuilder.build());
        return ret.toArray(new String[ret.size()]);
    }

    public static void addTempResource(String tmpResName, String file, Odps odps) throws Throwable {
        CopyTempResourceUtil.addTempResource(CupidSession.get(), tmpResName, file, odps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTempResource(CupidSession session, String tmpResName, String file, Odps odps) throws Throwable {
        FileResource res = new FileResource();
        res.setName(tmpResName);
        res.setIsTempResource(true);
        logger.info((Object)("begin creating tempResource: " + tmpResName));
        CupidConf conf = session.conf;
        int retryCount = Integer.parseInt(conf.get("spark.copyFileToRemote.retry.count", "3"));
        while (retryCount > 0) {
            try (FileInputStream in = new FileInputStream(file);){
                if (odps.resources().exists(odps.getDefaultProject(), tmpResName)) {
                    logger.info((Object)("tempResource existed: " + tmpResName));
                } else {
                    odps.resources().create(odps.getDefaultProject(), res, (InputStream)in);
                    logger.info((Object)("create tempResource " + tmpResName + " success"));
                }
                retryCount = 0;
            }
        }
    }

    public static JTuple.JTuple2<String, String> addAndCopyTempResource(String srcPath, Odps odps) throws Throwable {
        return CopyTempResourceUtil.addAndCopyTempResource(CupidSession.get(), srcPath, odps);
    }

    public static JTuple.JTuple2<String, String> addAndCopyTempResource(CupidSession session, String srcPath, Odps odps) throws Throwable {
        File file = new File(srcPath);
        FileInputStream in0 = new FileInputStream(file);
        String md5 = DigestUtils.md5Hex((InputStream)in0);
        in0.close();
        String tmpResName = md5 + "_" + file.getName();
        CopyTempResourceUtil.addTempResource(session, tmpResName, file.getAbsolutePath(), odps);
        String[] resources = new String[]{tmpResName};
        return JTuple.tuple(tmpResName, CopyTempResourceUtil.copyTempResourceToFuxiJobDir(session, resources)[0]);
    }
}

