/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.client.rpc;

import apsara.odps.cupid.client.protocol.CupidClientRpc;
import com.aliyun.odps.cupid.client.rpc.CupidRpcChannelProxy;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CupidClientRpcChannel
implements RpcChannel {
    private static final Logger LOG = LoggerFactory.getLogger(CupidClientRpcChannel.class);
    CupidRpcChannelProxy cupidRpcChannelProxy = null;

    public CupidClientRpcChannel(CupidRpcChannelProxy cupidRpcChannelProxy) {
        this.cupidRpcChannelProxy = cupidRpcChannelProxy;
    }

    public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
        try {
            int index = method.getIndex();
            CupidClientRpc.RpcProtocol.Builder rpcProtocolBuilder = CupidClientRpc.RpcProtocol.newBuilder();
            rpcProtocolBuilder.setServiceName(method.getService().getFullName());
            rpcProtocolBuilder.setMethodId(index);
            rpcProtocolBuilder.setRequestBody(request.toByteString());
            byte[] res = this.cupidRpcChannelProxy.SyncCall(rpcProtocolBuilder.build().toByteArray());
            Message resMessage = responsePrototype.newBuilderForType().mergeFrom(res).build();
            done.run((Object)resMessage);
        }
        catch (IOException e) {
            controller.setFailed(e.toString());
        }
    }
}

