/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.basic.rpc;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.TaskServiceRequestUtil;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CupidTaskServiceRpcChannel
implements RpcChannel {
    private static final Logger LOG = LoggerFactory.getLogger(CupidTaskServiceRpcChannel.class);
    private CupidSession cupidSession = null;

    public CupidTaskServiceRpcChannel(CupidSession cupidSession) {
        this.cupidSession = cupidSession;
    }

    public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
        try {
            CupidTaskParamProtos.TaskServiceRequest.Builder taskServiceReq = CupidTaskParamProtos.TaskServiceRequest.newBuilder();
            taskServiceReq.setMethodName(method.getName());
            taskServiceReq.setRequestInBytes(request.toByteString());
            String res = TaskServiceRequestUtil.sendTaskServiceRequest(taskServiceReq, this.cupidSession);
            Message resMessage = responsePrototype.newBuilderForType().mergeFrom(Base64.decodeBase64((byte[])res.getBytes())).build();
            done.run((Object)resMessage);
        }
        catch (Exception ex) {
            controller.setFailed(ex.toString());
        }
    }
}

