/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.Instance;
import com.aliyun.odps.LogView;
import com.aliyun.odps.cupid.CupidException;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.InstanceRecycledException;
import com.aliyun.odps.cupid.UserException;
import com.aliyun.odps.cupid.requestcupid.RetryConst;
import com.aliyun.odps.cupid.requestcupid.RetryUtil;
import com.github.rholder.retry.RetryException;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class CupidUtil {
    private static Logger logger = Logger.getLogger(CupidUtil.class);
    private static Map<String, String> taskStatus = new ConcurrentHashMap<String, String>();
    private static AtomicInteger waitCounter = new AtomicInteger();

    public static CupidException errMsg2SparkException(String errMsg) {
        if (errMsg.startsWith("runTask failed:") || errMsg.startsWith("app run failed!")) {
            return new UserException(errMsg);
        }
        return new CupidException(errMsg);
    }

    public static String getTaskDetailJson(final Instance ins) throws ExecutionException, RetryException {
        Callable<String> getTaskDetailJsonCallable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ins.getTaskDetailJson("cupid_task");
            }
        };
        return RetryUtil.retryFunction(getTaskDetailJsonCallable, RetryConst.GET_TASK_DETAIL_JSON, 2);
    }

    public static CupidTaskParamProtos.CupidTaskDetailResultParam getInsStatus(Instance ins) throws ExecutionException, RetryException, InstanceRecycledException, InvalidProtocolBufferException {
        String detailResult = CupidUtil.getTaskDetailJson(ins);
        if (detailResult.equals(InstanceRecycledException.InstanceRecycledMsg)) {
            throw new InstanceRecycledException(detailResult);
        }
        CupidTaskParamProtos.CupidTaskDetailResultParam taskDetailResultParam = CupidTaskParamProtos.CupidTaskDetailResultParam.parseFrom(Base64.decodeBase64((byte[])detailResult.getBytes()));
        if (taskDetailResultParam.hasReady() || taskDetailResultParam.hasWaiting() || taskDetailResultParam.hasRunning() || taskDetailResultParam.hasSuccess() || taskDetailResultParam.hasFailed() || taskDetailResultParam.hasCancelled() || taskDetailResultParam.hasWaitForReRun()) {
            return taskDetailResultParam;
        }
        logger.debug((Object)"taskDetailResultParam is empty, set Ready!");
        return taskDetailResultParam.toBuilder().setReady(CupidTaskParamProtos.Ready.newBuilder().build()).build();
    }

    public static String pollSuccessResult(Instance ins, String msg) throws InvalidProtocolBufferException, ExecutionException, RetryException, InterruptedException, CupidException {
        boolean _break = false;
        while (!_break) {
            CupidTaskParamProtos.CupidTaskDetailResultParam re = CupidUtil.getResult(ins);
            if (re.hasFailed()) {
                if (!re.getFailed().hasBizFailed()) continue;
                throw CupidUtil.errMsg2SparkException(re.getFailed().getBizFailed().getBizFailedMsg());
            }
            if (re.hasCancelled()) {
                throw new UserException("instance be cancelled");
            }
            if (re.hasRunning()) {
                logger.info((Object)msg);
                Thread.sleep(1000L);
                continue;
            }
            if (re.hasSuccess()) {
                return re.getSuccess().getSuccessMsg();
            }
            if (re.toString() != "") {
                logger.info((Object)("unexpected status: " + re.toString()));
            }
            Thread.sleep(1000L);
        }
        return "";
    }

    public static CupidTaskParamProtos.CupidTaskDetailResultParam getResult(Instance ins) throws InvalidProtocolBufferException, ExecutionException, RetryException, CupidException, InterruptedException {
        CupidTaskParamProtos.CupidTaskDetailResultParam result = null;
        boolean _break = false;
        while (!_break) {
            result = CupidUtil.getInsStatus(ins);
            CupidUtil.updateTaskStatus(ins, result);
            if (result.hasFailed() && result.getFailed().hasCupidTaskFailed()) {
                throw CupidUtil.errMsg2SparkException(result.getFailed().getCupidTaskFailed().getCupidTaskFailedMsg());
            }
            if (result.hasReady()) {
                Thread.sleep(1000L);
                continue;
            }
            if (result.hasWaiting()) {
                Thread.sleep(1000L);
                continue;
            }
            if (result.hasWaitForReRun()) {
                String reRunMsg = result.getWaitForReRun().getWaitMsg();
                logger.info((Object)("waiting for ReRun, instanceId: " + ins.getId() + ", Msg: " + reRunMsg + "!!!"));
                Thread.sleep(30000L);
                continue;
            }
            _break = true;
        }
        return result;
    }

    public static String getLogViewUrl(final Instance instance) throws ExecutionException, RetryException {
        final LogView logViewHandler = new LogView(CupidSession.get().odps());
        Callable<String> generateLogViewCallable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return logViewHandler.generateLogView(instance, 168L);
            }
        };
        String logViewUrl = RetryUtil.retryFunction(generateLogViewCallable, RetryConst.GET_LOG_VIEW_URL, 60);
        return logViewUrl;
    }

    public static String getEngineLookupName() {
        return CupidSession.get().getJobLookupName();
    }

    private static void updateTaskStatus(Instance ins, CupidTaskParamProtos.CupidTaskDetailResultParam result) {
        boolean changed;
        String status = "";
        boolean terminated = false;
        if (result.hasReady()) {
            status = "Ready";
        } else if (result.hasWaiting()) {
            status = "Waiting";
        } else if (result.hasRunning()) {
            status = "Running";
        } else if (result.hasSuccess()) {
            status = "Success";
            terminated = true;
        } else if (result.hasFailed()) {
            status = "Failed";
            terminated = true;
        } else if (result.hasCancelled()) {
            status = "Cancelled";
            terminated = true;
        } else if (result.hasWaitForReRun()) {
            status = "WaitForReRun";
        }
        String key = CupidUtil.getTaskStatusKey(ins);
        boolean bl = changed = !taskStatus.containsKey(key) || !taskStatus.get(key).equals(status);
        if (changed) {
            if (waitCounter.getAndSet(0) > 0) {
                System.err.println();
            }
            String suffix = "";
            if (status.equals("Ready")) {
                suffix = ", expecting next status: Waiting/Running/Success";
            } else if (status.equals("Waiting")) {
                suffix = ", expecting next status: Running/Success";
            }
            logger.info((Object)("CupidTask status changed: " + status + suffix));
            taskStatus.put(key, status);
        } else if (!status.equals("Running")) {
            waitCounter.incrementAndGet();
            System.err.print(".");
            System.err.flush();
            System.out.flush();
        }
        if (terminated) {
            taskStatus.remove(key);
        }
    }

    private static String getTaskStatusKey(Instance ins) {
        return ins.getProject() + "_" + ins.getId();
    }
}

