/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid;

import com.aliyun.odps.Odps;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.account.BearerTokenAccount;
import com.aliyun.odps.account.StsAccount;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidJobInstance;
import com.aliyun.odps.cupid.requestcupid.JobViewUtil;
import com.aliyun.odps.cupid.runtime.RuntimeContext;
import com.aliyun.odps.utils.StringUtils;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class CupidSession {
    private static Logger logger = Logger.getLogger(CupidSession.class);
    private CupidJobInstance cupidJobInstance = new CupidJobInstance("", false, new Object());
    public AtomicInteger saveId;
    public CupidConf conf;
    private Odps odps;
    private final Object odpsLock = new Object();
    private boolean isDryRunMode = false;
    private boolean isEMR = false;
    private String accessKeyIdFromEMR;
    private String accessKeySecretFromEMR;
    private String securityTokenFromEMR;
    public String biz_id;
    public String flightingMajorVersion;
    private static final Object confLock = new Object();
    private static CupidSession cupidSession = null;
    public static CupidConf globalConf = new CupidConf();

    public CupidSession(CupidConf conf) {
        if (conf.isEmpty()) {
            throw new RuntimeException("Cannot create CupidSession with empty CupidConf.");
        }
        conf.sanitize();
        this.conf = conf;
        this.biz_id = conf.get("com.aliyun.biz_id", "");
        this.flightingMajorVersion = conf.get("odps.task.major.version", null);
        this.saveId = new AtomicInteger(0);
        this.checkEMREnv();
        this.odps = this.initOdps();
        if (Boolean.parseBoolean(conf.get("odps.cupid.bearer.token.enable", "true")) && System.getenv("META_LOOKUP_NAME") != null) {
            long interval = Long.parseLong(conf.get("odps.cupid.bearer.token.refresh.interval.seconds", "600"));
            Timer timer = new Timer("BearerTokenRefresher", true);
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    CupidSession.this.refreshOdps();
                }
            }, 0L, interval * 1000L);
        }
    }

    public JobViewUtil jobView() {
        return new JobViewUtil(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Odps odps() {
        Object object = this.odpsLock;
        synchronized (object) {
            return this.odps;
        }
    }

    public boolean isDryRunMode() {
        return this.isDryRunMode;
    }

    public void setDryRunMode(boolean dryRunMode) {
        this.isDryRunMode = dryRunMode;
    }

    public void setJobLookupName(String lookUpName) {
        this.cupidJobInstance.lookupName = lookUpName;
    }

    public String getJobLookupName() {
        return this.cupidJobInstance.lookupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobRunning() {
        Object object = this.cupidJobInstance.jobRunningLock;
        synchronized (object) {
            this.cupidJobInstance.jobisRunning = true;
            this.cupidJobInstance.jobRunningLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJobRunning() throws InterruptedException {
        int waitAmStartTime = Integer.parseInt(this.conf.get("odps.cupid.wait.am.start.time", "600")) * 1000;
        Object object = this.cupidJobInstance.jobRunningLock;
        synchronized (object) {
            if (!this.cupidJobInstance.jobisRunning) {
                this.cupidJobInstance.jobRunningLock.wait(waitAmStartTime);
            }
        }
        return this.cupidJobInstance.jobisRunning;
    }

    private Account getAccount() {
        if (this.isEMR) {
            this.fetchEMRStsToken();
            return new StsAccount(this.accessKeyIdFromEMR, this.accessKeySecretFromEMR, this.securityTokenFromEMR);
        }
        if (System.getenv("META_LOOKUP_NAME") != null && "true".equals(this.conf.get("odps.cupid.bearer.token.enable", "true").toLowerCase())) {
            try {
                return new BearerTokenAccount(RuntimeContext.get().getBearerToken());
            }
            catch (Throwable ex) {
                logger.error((Object)String.format("initialize BearerTokenAccount failed with %s, fallback to use AliyunAccount", ex.getMessage()));
                return this.getDefaultAccount();
            }
        }
        if (this.conf.get("odps.bearer.token", null) != null) {
            return new BearerTokenAccount(this.conf.get("odps.bearer.token", null));
        }
        return this.getDefaultAccount();
    }

    private Account getDefaultAccount() {
        if (this.conf.contains("odps.access.security.token") && StringUtils.isNotBlank((String)this.conf.get("odps.access.security.token"))) {
            return new StsAccount(this.conf.get("odps.access.id"), this.conf.get("odps.access.key"), this.conf.get("odps.access.security.token"));
        }
        return new AliyunAccount(this.conf.get("odps.access.id"), this.conf.get("odps.access.key"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshOdps() {
        logger.info((Object)"refresh odps object");
        Account account = this.getAccount();
        Object object = this.odpsLock;
        synchronized (object) {
            this.odps.setAccount(account);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpGet(String url) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpGet get = new HttpGet(url);
            response = httpClient.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                return string;
            }
        }
        catch (Exception ex) {
            logger.debug((Object)String.format("httpGet url: %s failed.", url), (Throwable)ex);
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception ex) {
                logger.debug((Object)"httpGet resource close failed.", (Throwable)ex);
            }
        }
        return null;
    }

    private void checkEMREnv() {
        if (System.getenv("META_LOOKUP_NAME") != null) {
            return;
        }
        String checkUrl = this.conf.get("odps.cupid.emr.end.point", "http://localhost:10011") + "/cluster-region";
        String result = this.httpGet(checkUrl);
        if (result != null) {
            this.isEMR = true;
        }
    }

    private void fetchEMRStsToken() {
        String idUrl = this.conf.get("odps.cupid.emr.end.point", "http://localhost:10011") + "/role-access-key-id";
        String keyUrl = this.conf.get("odps.cupid.emr.end.point", "http://localhost:10011") + "/role-access-key-secret";
        String tokenUrl = this.conf.get("odps.cupid.emr.end.point", "http://localhost:10011") + "/role-security-token";
        this.accessKeyIdFromEMR = this.httpGet(idUrl);
        this.accessKeySecretFromEMR = this.httpGet(keyUrl);
        this.securityTokenFromEMR = this.httpGet(tokenUrl);
        assert (this.accessKeyIdFromEMR != null && this.accessKeySecretFromEMR != null && this.securityTokenFromEMR != null);
    }

    public Odps initOdps() {
        Account account = this.getAccount();
        Odps odps = new Odps(account);
        String lookupName = System.getenv("META_LOOKUP_NAME");
        if (lookupName == null) {
            odps.setEndpoint(this.conf.get("odps.end.point"));
        } else {
            odps.setEndpoint(this.conf.get("odps.runtime.end.point", this.conf.get("odps.end.point")));
        }
        odps.setDefaultProject(this.conf.get("odps.project.name"));
        String runningCluster = this.conf.get("odps.moye.job.runningcluster", "");
        if (!"".equals(runningCluster)) {
            logger.info((Object)("user set runningCluster = " + runningCluster));
            odps.instances().setDefaultRunningCluster(runningCluster);
        }
        odps.getRestClient().setReadTimeout(this.conf.getInt("odps.socket.timeout", 300));
        odps.getRestClient().setConnectTimeout(this.conf.getInt("odps.socket.connect.timeout", 180));
        return odps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConf(CupidConf conf) {
        Object object = confLock;
        synchronized (object) {
            globalConf = conf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CupidConf getConf() throws InterruptedException {
        Object object = confLock;
        synchronized (object) {
            return globalConf;
        }
    }

    public static void reset() {
        cupidSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CupidSession get() {
        Class<CupidSession> clazz = CupidSession.class;
        synchronized (CupidSession.class) {
            if (cupidSession == null) {
                try {
                    cupidSession = new CupidSession(CupidSession.getConf());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                String lookupName = System.getenv("META_LOOKUP_NAME");
                if (lookupName == null) {
                    lookupName = "";
                }
                cupidSession.setJobLookupName(lookupName);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cupidSession;
        }
    }
}

