/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid;

import com.aliyun.odps.cupid.utils.JTuple;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class CupidConf {
    private Logger logger = Logger.getLogger(CupidConf.class);
    private ConcurrentHashMap<String, String> settings = new ConcurrentHashMap();

    public CupidConf() {
        this.loadDefaults();
    }

    private void loadDefaults() {
        File confFile;
        URL url = null;
        String confPath = System.getenv("ODPS_CONF_FILE");
        if (confPath != null && !confPath.trim().isEmpty() && (confFile = new File(confPath)).exists()) {
            try {
                url = confFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                this.logger.debug((Object)("cannot find user defined odps config file: " + confPath));
            }
        }
        if (url == null) {
            url = CupidConf.class.getClassLoader().getResource("odps.conf");
        }
        Properties props = null;
        if (url != null) {
            props = new Properties();
            try {
                InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
                props.load(reader);
            }
            catch (IOException ex) {
                props = null;
            }
        }
        if (props == null) {
            this.logger.warn((Object)"load odps default configs failed.");
            return;
        }
        for (String key : props.stringPropertyNames()) {
            String value;
            if (!key.startsWith("odps.") || (value = props.getProperty(key).trim()).isEmpty()) continue;
            this.settings.put(key, value);
        }
    }

    public void sanitize() {
        String engineType = this.settings.get("odps.moye.runtime.type");
        if (System.getenv("FLINK_CONF_DIR") != null) {
            engineType = "flink";
        }
        if (System.getenv("SPARK_ENV_LOADED") != null) {
            engineType = "spark";
        }
        if (engineType != null) {
            this.settings.put("odps.moye.runtime.type", engineType);
            if (!this.settings.containsKey("odps.moye.eventLog.dir")) {
                this.settings.put("odps.moye.eventLog.dir", "odps://admin_task_project/cupidhistory/" + engineType + "history/");
            }
        }
        if (!this.settings.containsKey("odps.cupid.disk.driver.enable")) {
            this.settings.put("odps.cupid.disk.driver.enable", "true");
        }
        if (this.get("odps.cupid.engine.running.type", "").equals("longtime") && !this.settings.containsKey("odps.cupid.job.capability.duration.hours")) {
            long durationHours = 8640L;
            this.settings.put("odps.cupid.job.capability.duration.hours", Long.toString(durationHours));
        }
        if (this.settings.containsKey("odps.end.point") && !this.settings.containsKey("odps.runtime.end.point")) {
            this.settings.put("odps.runtime.end.point", this.settings.get("odps.end.point").replace("aliyun.com", "aliyun-inc.com"));
        }
    }

    public boolean contains(String key) {
        return this.settings.containsKey(key);
    }

    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    public String get(String key) {
        if (this.settings.containsKey(key)) {
            return this.settings.get(key);
        }
        throw new NoSuchElementException(key);
    }

    public String get(String key, String defaultValue) {
        if (this.settings.containsKey(key)) {
            return this.settings.get(key);
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.settings.containsKey(key)) {
            return Boolean.parseBoolean(this.settings.get(key));
        }
        return defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        if (this.settings.containsKey(key)) {
            return Integer.parseInt(this.settings.get(key));
        }
        return defaultValue;
    }

    public long getLong(String key, long defaultValue) {
        if (this.settings.containsKey(key)) {
            return Long.parseLong(this.settings.get(key));
        }
        return defaultValue;
    }

    public JTuple.JTuple2<String, String>[] getAll() {
        ArrayList<JTuple.JTuple2<String, String>> allConfs = new ArrayList<JTuple.JTuple2<String, String>>();
        for (Map.Entry<String, String> entry : this.settings.entrySet()) {
            allConfs.add(JTuple.tuple(entry.getKey(), entry.getValue()));
        }
        return allConfs.toArray(new JTuple.JTuple2[allConfs.size()]);
    }

    public CupidConf remove(String key) {
        this.settings.remove(key);
        return this;
    }

    public CupidConf set(String key, String value) {
        if (key == null) {
            throw new NullPointerException("null key");
        }
        if (value == null) {
            throw new NullPointerException("null value for " + key);
        }
        this.settings.put(key.trim(), value.trim());
        return this;
    }
}

