/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.has.common.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.kerby.has.common.HasConfig;
import org.apache.kerby.has.common.HasException;
import org.apache.kerby.has.common.spnego.AuthenticatedURL;
import org.apache.kerby.has.common.spnego.AuthenticationException;
import org.apache.kerby.has.common.spnego.KerberosHasAuthenticator;
import org.apache.kerby.has.common.ssl.SSLFactory;
import org.apache.kerby.has.common.util.ConnectionConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
public class URLConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(URLConnectionFactory.class);
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private final ConnectionConfigurator connConfigurator;
    private static final ConnectionConfigurator DEFAULT_TIMEOUT_CONN_CONFIGURATOR = new ConnectionConfigurator(){

        @Override
        public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
            URLConnectionFactory.setTimeouts(conn, 60000, 60000);
            return conn;
        }
    };
    public static final URLConnectionFactory DEFAULT_SYSTEM_CONNECTION_FACTORY = new URLConnectionFactory(DEFAULT_TIMEOUT_CONN_CONFIGURATOR);

    public static URLConnectionFactory newDefaultURLConnectionFactory(HasConfig conf) {
        ConnectionConfigurator conn;
        try {
            conn = URLConnectionFactory.newSslConnConfigurator(60000, conf);
        }
        catch (Exception e) {
            LOG.debug("Cannot load customized ssl related configuration. Fallback to system-generic settings.", (Throwable)e);
            conn = DEFAULT_TIMEOUT_CONN_CONFIGURATOR;
        }
        return new URLConnectionFactory(conn);
    }

    URLConnectionFactory(ConnectionConfigurator connConfigurator) {
        this.connConfigurator = connConfigurator;
    }

    private static ConnectionConfigurator newSslConnConfigurator(int defaultTimeout, HasConfig conf) throws IOException, GeneralSecurityException, HasException {
        SSLFactory factory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        factory.init();
        final SSLSocketFactory sf = factory.createSSLSocketFactory();
        final HostnameVerifier hv = factory.getHostnameVerifier();
        final int connectTimeout = defaultTimeout;
        final int readTimeout = defaultTimeout;
        return new ConnectionConfigurator(){

            @Override
            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection c = (HttpsURLConnection)conn;
                    c.setSSLSocketFactory(sf);
                    c.setHostnameVerifier(hv);
                }
                URLConnectionFactory.setTimeouts(conn, connectTimeout, readTimeout);
                return conn;
            }
        };
    }

    public URLConnection openConnection(URL url) throws IOException {
        try {
            return this.openConnection(url, false, null);
        }
        catch (AuthenticationException e) {
            LOG.error("Open connection {} failed", (Object)url, (Object)e);
            return null;
        }
    }

    public URLConnection openConnection(URL url, boolean isSpnego, HasConfig hasConfig) throws IOException, AuthenticationException {
        if (isSpnego && hasConfig != null) {
            LOG.debug("open AuthenticatedURL connection {}", (Object)url);
            AuthenticatedURL.Token authToken = new AuthenticatedURL.Token();
            return new AuthenticatedURL(new KerberosHasAuthenticator(hasConfig.getAdminKeytab(), hasConfig.getAdminKeytabPrincipal()), this.connConfigurator).openConnection(url, authToken);
        }
        LOG.debug("open URL connection");
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            this.connConfigurator.configure((HttpURLConnection)connection);
        }
        return connection;
    }

    private static void setTimeouts(URLConnection connection, int connectTimeout, int readTimeout) {
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
    }
}

