/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.has.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasJaasLoginUtil {
    public static final Logger LOG = LoggerFactory.getLogger(HasJaasLoginUtil.class);
    public static final boolean ENABLE_DEBUG = true;
    private static final Map<String, String> BASIC_JAAS_OPTIONS = new HashMap<String, String>();
    private static final Map<String, String> TICKET_KERBEROS_OPTIONS;
    private static final AppConfigurationEntry TICKET_KERBEROS_LOGIN;

    private static String getKrb5LoginModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "org.apache.kerby.has.client.HasLoginModule";
    }

    public static synchronized Subject loginUserFromTgtTicket(String hadoopSecurityHas) throws IOException {
        TICKET_KERBEROS_OPTIONS.put("hadoopSecurityHas", hadoopSecurityHas);
        Subject subject = new Subject();
        HasJaasConf conf = new HasJaasConf();
        String confName = "ticket-kerberos";
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(confName, subject, null, conf);
        }
        catch (LoginException e) {
            throw new IOException("Fail to create LoginContext for " + e);
        }
        try {
            loginContext.login();
            LOG.info("Login successful for user " + subject.getPrincipals().iterator().next().getName());
        }
        catch (LoginException e) {
            throw new IOException("Login failure for " + e);
        }
        return loginContext.getSubject();
    }

    static {
        String jaasEnvVar = System.getenv("HADOOP_JAAS_DEBUG");
        if (jaasEnvVar != null && "true".equalsIgnoreCase(jaasEnvVar)) {
            BASIC_JAAS_OPTIONS.put("debug", String.valueOf(true));
        }
        TICKET_KERBEROS_OPTIONS = new HashMap<String, String>();
        TICKET_KERBEROS_OPTIONS.put("doNotPrompt", "true");
        TICKET_KERBEROS_OPTIONS.put("useTgtTicket", "true");
        TICKET_KERBEROS_OPTIONS.putAll(BASIC_JAAS_OPTIONS);
        TICKET_KERBEROS_LOGIN = new AppConfigurationEntry(HasJaasLoginUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, TICKET_KERBEROS_OPTIONS);
    }

    static class HasJaasConf
    extends Configuration {
        HasJaasConf() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return new AppConfigurationEntry[]{TICKET_KERBEROS_LOGIN};
        }
    }
}

