/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.has.common.ssl;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.kerby.has.common.HasConfig;
import org.apache.kerby.has.common.HasException;
import org.apache.kerby.has.common.ssl.KeyStoresFactory;
import org.apache.kerby.has.common.ssl.SSLHostnameVerifier;
import org.apache.kerby.has.common.util.ConnectionConfigurator;
import org.apache.kerby.has.common.util.PlatformName;
import org.apache.kerby.has.common.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SSLFactory
implements ConnectionConfigurator {
    public static final String SSL_REQUIRE_CLIENT_CERT_KEY = "hadoop.ssl.require.client.CERT";
    public static final String SSL_HOSTNAME_VERIFIER_KEY = "hadoop.ssl.hostname.verifier";
    public static final String SSL_CLIENT_CONF_KEY = "hadoop.ssl.client.conf";
    public static final String SSL_SERVER_CONF_KEY = "hadoop.ssl.server.conf";
    public static final String SSLCERTIFICATE = PlatformName.IBM_JAVA ? "ibmX509" : "SunX509";
    public static final boolean DEFAULT_SSL_REQUIRE_CLIENT_CERT = false;
    public static final String KEYSTORES_FACTORY_CLASS_KEY = "hadoop.ssl.keystores.factory.class";
    public static final String SSL_ENABLED_PROTOCOLS = "hadoop.ssl.enabled.protocols";
    private HasConfig conf;
    private Mode mode;
    private boolean requireClientCert;
    private SSLContext context;
    private HostnameVerifier hostnameVerifier;
    private KeyStoresFactory keystoresFactory;
    private String[] enabledProtocols = null;

    public SSLFactory(Mode mode, HasConfig conf) throws HasException {
        this.conf = conf;
        if (mode == null) {
            throw new IllegalArgumentException("mode cannot be NULL");
        }
        this.mode = mode;
        this.requireClientCert = conf.getBoolean(SSL_REQUIRE_CLIENT_CERT_KEY, false);
        HasConfig sslConf = this.readSSLConfiguration(mode);
        this.keystoresFactory = new KeyStoresFactory();
        this.keystoresFactory.setConf(sslConf);
        this.enabledProtocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    }

    private HasConfig readSSLConfiguration(Mode mode) throws HasException {
        HasConfig sslConf = new HasConfig();
        sslConf.setBoolean(SSL_REQUIRE_CLIENT_CERT_KEY, this.requireClientCert);
        String sslConfResource = mode == Mode.CLIENT ? this.conf.getString(SSL_CLIENT_CONF_KEY) : this.conf.getString(SSL_SERVER_CONF_KEY);
        try {
            sslConf.addIniConfig(new File(sslConfResource));
        }
        catch (IOException e) {
            throw new HasException(e);
        }
        return sslConf;
    }

    public void init() throws GeneralSecurityException, IOException {
        this.keystoresFactory.init(this.mode);
        this.context = SSLContext.getInstance("TLS");
        this.context.init(this.keystoresFactory.getKeyManagers(), this.keystoresFactory.getTrustManagers(), null);
        this.context.getDefaultSSLParameters().setProtocols(this.enabledProtocols);
        this.hostnameVerifier = this.getHostnameVerifier(this.conf);
    }

    private HostnameVerifier getHostnameVerifier(HasConfig conf) throws GeneralSecurityException, IOException {
        return SSLFactory.getHostnameVerifier(StringUtils.toUpperCase(conf.getString(SSL_HOSTNAME_VERIFIER_KEY, "DEFAULT").trim()));
    }

    public static HostnameVerifier getHostnameVerifier(String verifier) throws GeneralSecurityException, IOException {
        SSLHostnameVerifier hostnameVerifier;
        if (verifier.equals("DEFAULT")) {
            hostnameVerifier = SSLHostnameVerifier.DEFAULT;
        } else if (verifier.equals("DEFAULT_AND_LOCALHOST")) {
            hostnameVerifier = SSLHostnameVerifier.DEFAULT_AND_LOCALHOST;
        } else if (verifier.equals("STRICT")) {
            hostnameVerifier = SSLHostnameVerifier.STRICT;
        } else if (verifier.equals("STRICT_IE6")) {
            hostnameVerifier = SSLHostnameVerifier.STRICT_IE6;
        } else if (verifier.equals("ALLOW_ALL")) {
            hostnameVerifier = SSLHostnameVerifier.ALLOW_ALL;
        } else {
            throw new GeneralSecurityException("Invalid hostname verifier: " + verifier);
        }
        return hostnameVerifier;
    }

    public void destroy() {
        this.keystoresFactory.destroy();
    }

    public KeyStoresFactory getKeystoresFactory() {
        return this.keystoresFactory;
    }

    public SSLEngine createSSLEngine() throws GeneralSecurityException, IOException {
        SSLEngine sslEngine = this.context.createSSLEngine();
        if (this.mode == Mode.CLIENT) {
            sslEngine.setUseClientMode(true);
        } else {
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(this.requireClientCert);
        }
        sslEngine.setEnabledProtocols(this.enabledProtocols);
        return sslEngine;
    }

    public SSLServerSocketFactory createSSLServerSocketFactory() throws GeneralSecurityException, IOException {
        if (this.mode != Mode.SERVER) {
            throw new IllegalStateException("Factory is in CLIENT mode");
        }
        return this.context.getServerSocketFactory();
    }

    public SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException, IOException {
        if (this.mode != Mode.CLIENT) {
            throw new IllegalStateException("Factory is in CLIENT mode");
        }
        return this.context.getSocketFactory();
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.mode != Mode.CLIENT) {
            throw new IllegalStateException("Factory is in CLIENT mode");
        }
        return this.hostnameVerifier;
    }

    public boolean isClientCertRequired() {
        return this.requireClientCert;
    }

    @Override
    public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sslConn = (HttpsURLConnection)conn;
            try {
                sslConn.setSSLSocketFactory(this.createSSLSocketFactory());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            sslConn.setHostnameVerifier(this.getHostnameVerifier());
            conn = sslConn;
        }
        return conn;
    }

    @InterfaceAudience.Private
    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

