/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.has.common.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.text.MessageFormat;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.kerby.has.common.HasConfig;
import org.apache.kerby.has.common.ssl.ReloadingX509TrustManager;
import org.apache.kerby.has.common.ssl.SSLFactory;
import org.apache.kerby.has.common.util.StringUtils;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class KeyStoresFactory
extends KrbConfig {
    private static final Log LOG = LogFactory.getLog(KeyStoresFactory.class);
    public static final String SSL_KEYSTORE_LOCATION_TPL_KEY = "ssl.{0}.keystore.location";
    public static final String SSL_KEYSTORE_PASSWORD_TPL_KEY = "ssl.{0}.keystore.password";
    public static final String SSL_KEYSTORE_KEYPASSWORD_TPL_KEY = "ssl.{0}.keystore.keypassword";
    public static final String SSL_KEYSTORE_TYPE_TPL_KEY = "ssl.{0}.keystore.type";
    public static final String SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY = "ssl.{0}.truststore.reload.interval";
    public static final String SSL_TRUSTSTORE_LOCATION_TPL_KEY = "ssl.{0}.truststore.location";
    public static final String SSL_TRUSTSTORE_PASSWORD_TPL_KEY = "ssl.{0}.truststore.password";
    public static final String SSL_TRUSTSTORE_TYPE_TPL_KEY = "ssl.{0}.truststore.type";
    public static final String DEFAULT_KEYSTORE_TYPE = "jks";
    public static final long DEFAULT_SSL_TRUSTSTORE_RELOAD_INTERVAL = 10000L;
    private HasConfig conf;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private ReloadingX509TrustManager trustManager;

    public void setConf(HasConfig conf) {
        this.conf = conf;
    }

    public HasConfig getConf() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(SSLFactory.Mode mode) throws IOException, GeneralSecurityException {
        boolean requireClientCert = this.conf.getBoolean("hadoop.ssl.require.client.CERT", false);
        String keystoreType = this.conf.getString(KeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        String keystoreKeyPassword = null;
        if (requireClientCert || mode == SSLFactory.Mode.SERVER) {
            String locationProperty = KeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_LOCATION_TPL_KEY);
            String keystoreLocation = this.conf.getString(locationProperty, "");
            if (keystoreLocation.isEmpty()) {
                throw new GeneralSecurityException("The property '" + locationProperty + "' has not been set in the ssl configuration file.");
            }
            String passwordProperty = KeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_PASSWORD_TPL_KEY);
            String keystorePassword = this.getPassword(this.conf, passwordProperty, "");
            if (keystorePassword.isEmpty()) {
                throw new GeneralSecurityException("The property '" + passwordProperty + "' has not been set in the ssl configuration file.");
            }
            String keyPasswordProperty = KeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_KEYPASSWORD_TPL_KEY);
            keystoreKeyPassword = this.getPassword(this.conf, keyPasswordProperty, keystorePassword);
            LOG.debug((Object)(mode.toString() + " KeyStore: " + keystoreLocation));
            try (FileInputStream is = new FileInputStream(keystoreLocation);){
                keystore.load(is, keystorePassword.toCharArray());
            }
            LOG.debug((Object)(mode.toString() + " Loaded KeyStore: " + keystoreLocation));
        } else {
            keystore.load(null, null);
        }
        KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(SSLFactory.SSLCERTIFICATE);
        keyMgrFactory.init(keystore, keystoreKeyPassword != null ? keystoreKeyPassword.toCharArray() : null);
        this.keyManagers = keyMgrFactory.getKeyManagers();
        String truststoreType = this.conf.getString(KeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        String locationProperty = KeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_LOCATION_TPL_KEY);
        String truststoreLocation = this.conf.getString(locationProperty, "");
        if (!truststoreLocation.isEmpty()) {
            String passwordProperty = KeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_PASSWORD_TPL_KEY);
            String truststorePassword = this.getPassword(this.conf, passwordProperty, "");
            if (truststorePassword.isEmpty()) {
                throw new GeneralSecurityException("The property '" + passwordProperty + "' has not been set in the ssl configuration file.");
            }
            long truststoreReloadInterval = this.conf.getLong(KeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY), 10000L);
            LOG.debug((Object)(mode.toString() + " TrustStore: " + truststoreLocation));
            this.trustManager = new ReloadingX509TrustManager(truststoreType, truststoreLocation, truststorePassword, truststoreReloadInterval);
            this.trustManager.init();
            LOG.debug((Object)(mode.toString() + " Loaded TrustStore: " + truststoreLocation));
            this.trustManagers = new TrustManager[]{this.trustManager};
        } else {
            LOG.debug((Object)("The property '" + locationProperty + "' has not been set, no TrustStore will be loaded"));
            this.trustManagers = null;
        }
    }

    String getPassword(HasConfig conf, String alias, String defaultPass) {
        String password = defaultPass;
        password = conf.getString(alias);
        return password;
    }

    public void destroy() {
        if (this.trustManager != null) {
            this.trustManager.destroy();
            this.trustManager = null;
            this.keyManagers = null;
            this.trustManagers = null;
        }
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public static String resolvePropertyName(SSLFactory.Mode mode, String template) {
        return MessageFormat.format(template, StringUtils.toLowerCase(mode.toString()));
    }
}

