/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.has.common.spnego;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.kerby.has.common.spnego.AuthToken;
import org.apache.kerby.has.common.spnego.AuthenticatedURL;
import org.apache.kerby.has.common.spnego.AuthenticationException;
import org.apache.kerby.has.common.spnego.Authenticator;
import org.apache.kerby.has.common.spnego.KerberosUtil;
import org.apache.kerby.has.common.util.ConnectionConfigurator;
import org.apache.kerby.has.common.util.PlatformName;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosAuthenticator.class);
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String NEGOTIATE = "Negotiate";
    private static final String AUTH_HTTP_METHOD = "OPTIONS";
    private static String keytabPrincipal = null;
    private static String keytabFile = null;
    private URL url;
    private HttpURLConnection conn;
    private Base64 base64;
    private ConnectionConfigurator connConfigurator;

    @Override
    public void setConnectionConfigurator(ConnectionConfigurator configurator) {
        this.connConfigurator = configurator;
    }

    @Override
    public void authenticate(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        if (!token.isSet()) {
            this.url = url;
            this.base64 = new Base64(0);
            this.conn = (HttpURLConnection)url.openConnection();
            if (this.connConfigurator != null) {
                this.conn = this.connConfigurator.configure(this.conn);
            }
            this.conn.setRequestMethod(AUTH_HTTP_METHOD);
            this.conn.connect();
            boolean needFallback = false;
            if (this.conn.getResponseCode() == 200) {
                LOG.debug("JDK performed authentication on our behalf.");
                AuthenticatedURL.extractToken(this.conn, token);
                if (this.isTokenKerberos(token)) {
                    return;
                }
                needFallback = true;
            }
            if (!needFallback && this.isNegotiate()) {
                LOG.debug("Performing our own SPNEGO sequence.");
                this.doSpnegoSequence(token);
            } else {
                throw new IOException("Should perform our own SPNEGO sequence");
            }
        }
    }

    public void setKeyTab(String keytabFile, String keytabPrincipal) {
        KerberosAuthenticator.keytabFile = keytabFile;
        KerberosAuthenticator.keytabPrincipal = keytabPrincipal;
    }

    private boolean isTokenKerberos(AuthenticatedURL.Token token) throws AuthenticationException {
        AuthToken aToken;
        return token.isSet() && ((aToken = AuthToken.parse(token.toString())).getType().equals("kerberos") || aToken.getType().equals("kerberos-dt"));
    }

    private boolean isNegotiate() throws IOException {
        boolean negotiate = false;
        if (this.conn.getResponseCode() == 401) {
            String authHeader = this.conn.getHeaderField(WWW_AUTHENTICATE);
            negotiate = authHeader != null && authHeader.trim().startsWith(NEGOTIATE);
        }
        return negotiate;
    }

    private void doSpnegoSequence(AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        try {
            AccessControlContext context = AccessController.getContext();
            Subject subject = Subject.getSubject(context);
            if (subject == null || subject.getPrivateCredentials(KerberosKey.class).isEmpty() && subject.getPrivateCredentials(KerberosTicket.class).isEmpty()) {
                LOG.debug("No subject in context, logging in");
                subject = new Subject();
                LoginContext login = new LoginContext("", subject, null, new KerberosConfiguration());
                login.login();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using subject: " + subject);
            }
            Subject.doAs(subject, new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    GSSContext gssContext = null;
                    try {
                        GSSManager gssManager = GSSManager.getInstance();
                        String servicePrincipal = KerberosUtil.getServicePrincipal("HTTP", KerberosAuthenticator.this.url.getHost());
                        LOG.info("service principal is:" + servicePrincipal);
                        Oid oid = KerberosUtil.getOidInstance("NT_GSS_KRB5_PRINCIPAL");
                        GSSName serviceName = gssManager.createName(servicePrincipal, oid);
                        oid = KerberosUtil.getOidInstance("GSS_KRB5_MECH_OID");
                        gssContext = gssManager.createContext(serviceName, oid, null, 0);
                        gssContext.requestCredDeleg(true);
                        gssContext.requestMutualAuth(true);
                        byte[] inToken = new byte[]{};
                        boolean established = false;
                        while (!established) {
                            byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
                            if (outToken != null) {
                                KerberosAuthenticator.this.sendToken(outToken);
                            }
                            if (!gssContext.isEstablished()) {
                                inToken = KerberosAuthenticator.this.readToken();
                                continue;
                            }
                            established = true;
                        }
                    }
                    finally {
                        if (gssContext != null) {
                            gssContext.dispose();
                            gssContext = null;
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw new AuthenticationException(ex.getException());
        }
        catch (LoginException ex) {
            throw new AuthenticationException(ex);
        }
        AuthenticatedURL.extractToken(this.conn, token);
    }

    private void sendToken(byte[] outToken) throws IOException {
        String token = this.base64.encodeToString(outToken);
        this.conn = (HttpURLConnection)this.url.openConnection();
        if (this.connConfigurator != null) {
            this.conn = this.connConfigurator.configure(this.conn);
        }
        this.conn.setRequestMethod(AUTH_HTTP_METHOD);
        this.conn.setRequestProperty(AUTHORIZATION, "Negotiate " + token);
        this.conn.connect();
    }

    private byte[] readToken() throws IOException, AuthenticationException {
        int status = this.conn.getResponseCode();
        if (status == 200 || status == 401) {
            String authHeader = this.conn.getHeaderField(WWW_AUTHENTICATE);
            if (authHeader == null || !authHeader.trim().startsWith(NEGOTIATE)) {
                throw new AuthenticationException("Invalid SPNEGO sequence, 'WWW-Authenticate' header incorrect: " + authHeader);
            }
            String negotiation = authHeader.trim().substring("Negotiate ".length()).trim();
            return this.base64.decode(negotiation);
        }
        throw new AuthenticationException("Invalid SPNEGO sequence, status code: " + status);
    }

    private static class KerberosConfiguration
    extends Configuration {
        private static final String OS_LOGIN_MODULE_NAME;
        private static final boolean WINDOWS;
        private static final boolean IS_64_BIT;
        private static final boolean AIX;
        private static final AppConfigurationEntry OS_SPECIFIC_LOGIN;
        private static final Map<String, String> KEYTAB_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry USER_KERBEROS_LOGIN;
        private static final AppConfigurationEntry[] USER_KERBEROS_CONF;

        private KerberosConfiguration() {
        }

        private static String getOSLoginModuleName() {
            if (PlatformName.IBM_JAVA) {
                if (WINDOWS) {
                    return IS_64_BIT ? "com.ibm.security.auth.module.Win64LoginModule" : "com.ibm.security.auth.module.NTLoginModule";
                }
                if (AIX) {
                    return IS_64_BIT ? "com.ibm.security.auth.module.AIX64LoginModule" : "com.ibm.security.auth.module.AIXLoginModule";
                }
                return "com.ibm.security.auth.module.LinuxLoginModule";
            }
            return WINDOWS ? "com.sun.security.auth.module.NTLoginModule" : "com.sun.security.auth.module.UnixLoginModule";
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            return USER_KERBEROS_CONF;
        }

        private static String prependFileAuthority(String keytabPath) {
            return keytabPath.startsWith("file://") ? keytabPath : "file://" + keytabPath;
        }

        static {
            WINDOWS = System.getProperty("os.name").startsWith("Windows");
            IS_64_BIT = System.getProperty("os.arch").contains("64");
            AIX = System.getProperty("os.name").equals("AIX");
            OS_LOGIN_MODULE_NAME = KerberosConfiguration.getOSLoginModuleName();
            OS_SPECIFIC_LOGIN = new AppConfigurationEntry(OS_LOGIN_MODULE_NAME, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap());
            KEYTAB_KERBEROS_OPTIONS = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                KEYTAB_KERBEROS_OPTIONS.put("credsType", "both");
                KEYTAB_KERBEROS_OPTIONS.put("useKeytab", KerberosConfiguration.prependFileAuthority(keytabFile));
            } else {
                KEYTAB_KERBEROS_OPTIONS.put("doNotPrompt", "true");
                KEYTAB_KERBEROS_OPTIONS.put("useKeyTab", "true");
                KEYTAB_KERBEROS_OPTIONS.put("storeKey", "true");
                KEYTAB_KERBEROS_OPTIONS.put("keyTab", keytabFile);
            }
            KEYTAB_KERBEROS_OPTIONS.put("principal", keytabPrincipal);
            KEYTAB_KERBEROS_OPTIONS.put("refreshKrb5Config", "true");
            KEYTAB_KERBEROS_OPTIONS.put("debug", "false");
            USER_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, KEYTAB_KERBEROS_OPTIONS);
            USER_KERBEROS_CONF = new AppConfigurationEntry[]{OS_SPECIFIC_LOGIN, USER_KERBEROS_LOGIN};
        }
    }
}

