/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.has.common;

import java.io.File;
import org.apache.kerby.has.common.HasConfigKey;
import org.apache.kerby.kerberos.kerb.common.Krb5Conf;

public class HasConfig
extends Krb5Conf {
    private File confDir;

    public void setConfDir(File dir) {
        this.confDir = dir;
    }

    public File getConfDir() {
        return this.confDir;
    }

    public String getHttpsHost() {
        return this.getString(HasConfigKey.HTTPS_HOST, false, new String[]{"HAS"});
    }

    public String getHttpsPort() {
        return this.getString(HasConfigKey.HTTPS_PORT, false, new String[]{"HAS"});
    }

    public String getHttpHost() {
        return this.getString(HasConfigKey.HTTP_HOST, false, new String[]{"HAS"});
    }

    public String getHttpPort() {
        return this.getString(HasConfigKey.HTTP_PORT, false, new String[]{"HAS"});
    }

    public String getPluginName() {
        return this.getString(HasConfigKey.AUTH_TYPE, true, new String[]{"PLUGIN"});
    }

    public String getRealm() {
        return this.getString(HasConfigKey.REALM, false, new String[]{"HAS"});
    }

    public String getSslServerConf() {
        File sslSrvConf;
        String value = this.getString(HasConfigKey.SSL_SERVER_CONF, false, new String[]{"HAS"});
        if (value != null) {
            return value;
        }
        if (this.getConfDir() != null && (sslSrvConf = new File(this.getConfDir(), "ssl-server.conf")).exists() && sslSrvConf.isFile()) {
            return sslSrvConf.getAbsolutePath();
        }
        return this.getString(HasConfigKey.SSL_SERVER_CONF, true, new String[]{"HAS"});
    }

    public String getSslClientConf() {
        return this.getString(HasConfigKey.SSL_CLIENT_CONF, true, new String[]{"HAS"});
    }

    public String getFilterAuthType() {
        return this.getString(HasConfigKey.FILTER_AUTH_TYPE, true, new String[]{"HAS"});
    }

    public String getKerberosPrincipal() {
        return this.getString(HasConfigKey.KERBEROS_PRINCIPAL, false, new String[]{"HAS"});
    }

    public String getKerberosKeytab() {
        return this.getString(HasConfigKey.KERBEROS_KEYTAB, false, new String[]{"HAS"});
    }

    public String getKerberosNameRules() {
        return this.getString(HasConfigKey.KERBEROS_NAME_RULES, false, new String[]{"HAS"});
    }

    public String getAdminKeytab() {
        return this.getString(HasConfigKey.ADMIN_KEYTAB, false, new String[]{"HAS"});
    }

    public String getAdminKeytabPrincipal() {
        return this.getString(HasConfigKey.ADMIN_KEYTAB_PRINCIPAL, false, new String[]{"HAS"});
    }

    public String getEnableConf() {
        return this.getString(HasConfigKey.ENABLE_CONF, false, new String[]{"HAS"});
    }

    public String getSslClientCert() {
        return this.getString(HasConfigKey.SSL_CLIENT_CERT, true, new String[]{"HAS"});
    }
}

