/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mma.spark;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;

public class MmaSparkSubmit {
    static String logFile;

    public static void main(String[] args) throws IOException {
        String[] arr;
        logFile = args[0];
        PrintStream systemErr = System.err;
        PrintStream systemOut = System.out;
        PrintStream errToFile = new PrintStream(Files.newOutputStream(Paths.get(logFile, new String[0]), new OpenOption[0]));
        System.setErr(errToFile);
        System.err.println(String.join((CharSequence)" \\\n", args));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream outToString = new PrintStream(baos);
        System.setOut(outToString);
        try {
            Class<?> sparkSubmitCls = Class.forName("org.apache.spark.deploy.SparkSubmit");
            Method method = sparkSubmitCls.getMethod("main", String[].class);
            method.invoke(sparkSubmitCls, new Object[]{Arrays.copyOfRange(args, 1, args.length)});
        }
        catch (Exception e) {
            e.printStackTrace();
            System.setOut(systemOut);
            System.setErr(systemErr);
            System.out.println("SUBMIT_FAILED");
            return;
        }
        System.setOut(systemOut);
        System.setErr(systemErr);
        String instanceIdOutput = baos.toString();
        errToFile.println(instanceIdOutput);
        errToFile.close();
        outToString.close();
        if (instanceIdOutput != null && (arr = instanceIdOutput.split(":")).length > 1) {
            String instanceId = arr[1].trim();
            System.out.println(instanceId);
            return;
        }
        System.out.println("GET_INSTANCE_ID_FAILED");
    }
}

