/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import java.math.BigInteger;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;

public class JavaHiveDecimalObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableHiveDecimalObjectInspector {
    public JavaHiveDecimalObjectInspector() {
    }

    public JavaHiveDecimalObjectInspector(DecimalTypeInfo typeInfo) {
        super(typeInfo);
    }

    @Override
    public HiveDecimalWritable getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            HiveDecimal dec = this.enforcePrecisionScale(HiveDecimal.create((String)((String)o)));
            return dec == null ? null : new HiveDecimalWritable(dec);
        }
        HiveDecimal dec = this.enforcePrecisionScale((HiveDecimal)o);
        return dec == null ? null : new HiveDecimalWritable(dec);
    }

    @Override
    public HiveDecimal getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return this.enforcePrecisionScale(HiveDecimal.create((String)((String)o)));
        }
        return this.enforcePrecisionScale((HiveDecimal)o);
    }

    @Override
    public Object set(Object o, byte[] bytes, int scale) {
        return this.enforcePrecisionScale(HiveDecimal.create((BigInteger)new BigInteger(bytes), (int)scale));
    }

    @Override
    public Object set(Object o, HiveDecimal t) {
        return this.enforcePrecisionScale(t);
    }

    @Override
    public Object set(Object o, HiveDecimalWritable t) {
        return t == null ? null : this.enforcePrecisionScale(t.getHiveDecimal());
    }

    @Override
    public Object create(byte[] bytes, int scale) {
        return HiveDecimal.create((BigInteger)new BigInteger(bytes), (int)scale);
    }

    @Override
    public Object create(HiveDecimal t) {
        return t;
    }

    private HiveDecimal enforcePrecisionScale(HiveDecimal dec) {
        return HiveDecimalUtils.enforcePrecisionScale(dec, (DecimalTypeInfo)this.typeInfo);
    }
}

