/*
 * Decompiled with CFR 0.152.
 */
package demo.memory;

import com.aliyun.odps.cupid.table.v1.writer.FileWriter;
import com.aliyun.odps.data.ArrayRecord;
import demo.memory.MemoryStore;
import java.io.IOException;
import java.util.ArrayList;

class MemoryWriter
implements FileWriter<ArrayRecord> {
    private final String project;
    private final String table;
    private ArrayList<ArrayRecord> file;
    private int rowCount;
    private ArrayList<ArrayRecord> stagingFile;

    MemoryWriter(String project, String table) {
        this.project = project;
        this.table = table;
    }

    @Override
    public void write(ArrayRecord data) throws IOException {
        this.file.add((ArrayRecord)data.clone());
        ++this.rowCount;
    }

    @Override
    public void close() throws IOException {
        this.stagingFile = this.file;
        this.file = null;
    }

    @Override
    public void commit() throws IOException {
        MemoryStore.Table memTable = MemoryStore.getTable(this.project, this.table);
        memTable.write(this.stagingFile.toArray(new ArrayRecord[0]));
    }

    @Override
    public long getBytesWritten() {
        return -1L;
    }

    @Override
    public long getRowsWritten() {
        return this.rowCount;
    }
}

