/*
 * Decompiled with CFR 0.152.
 */
package demo.memory;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.table.v1.util.TableUtils;
import com.aliyun.odps.cupid.table.v1.writer.BucketFileInfo;
import com.aliyun.odps.cupid.table.v1.writer.TableWriteSession;
import com.aliyun.odps.cupid.table.v1.writer.WriteSessionInfo;
import demo.memory.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class MemoryWriteSession
extends TableWriteSession {
    private WriteSessionInfo writeSessionInfo;

    MemoryWriteSession(String project, String table, TableSchema tableSchema, Map<String, String> partitionSpec, boolean overwrite) {
        super(project, table, tableSchema, partitionSpec, overwrite);
    }

    @Override
    public TableSchema getTableSchema() {
        return null;
    }

    MemoryWriteSession(WriteSessionInfo writeSessionInfo) {
        super(writeSessionInfo.getProject(), writeSessionInfo.getTable(), TableUtils.toTableSchema(writeSessionInfo), writeSessionInfo.getPartitionSpec(), writeSessionInfo.isOverwrite());
        this.writeSessionInfo = writeSessionInfo;
    }

    @Override
    public WriteSessionInfo getOrCreateSessionInfo() {
        if (this.writeSessionInfo != null) {
            return this.writeSessionInfo;
        }
        return new WriteSessionInfo(this.project, this.table, Utils.toAttributes(this.tableSchema.getColumns()), Utils.toAttributes(this.tableSchema.getPartitionColumns()), this.partitionSpec){

            @Override
            public String getProvider() {
                return "memory";
            }
        };
    }

    @Override
    public void commitTable() throws IOException {
        if (this.overwrite) {
            throw new IllegalArgumentException("overwrite");
        }
    }

    @Override
    public void commitTableWithPartitions(List<Map<String, String>> partitionSpecs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commitClusteredTable(List<BucketFileInfo> partitionSpecs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanup() throws IOException {
    }
}

