/*
 * Decompiled with CFR 0.152.
 */
package demo.memory;

import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.cupid.table.v1.reader.InputSplit;
import com.aliyun.odps.data.ArrayRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryStore {
    private static Map<String, Project> projects = new ConcurrentHashMap<String, Project>();

    public static void createProject(String project) {
        projects.put(project, new Project());
    }

    public static boolean projectExists(String project) {
        return projects.containsKey(project);
    }

    public static void dropProject(String project) {
        projects.remove(project);
    }

    public static void createTable(String project, String table) {
        projects.get(project).createTable(table);
    }

    public static boolean tableExists(String project, String table) {
        return projects.get(project).tableExists(table);
    }

    public static void dropTable(String project, String table) {
        projects.get(project).dropTable(table);
    }

    static Table getTable(String project, String table) {
        return projects.get(project).getTable(table);
    }

    static class Table {
        private List<ArrayRecord[]> files = Collections.synchronizedList(new ArrayList());

        Table() {
        }

        int getFileCount() {
            return this.files.size();
        }

        ArrayRecord[] read(int index) {
            return this.files.get(index);
        }

        void write(ArrayRecord[] file) {
            this.files.add(file);
        }
    }

    static class IndexSplit
    extends InputSplit {
        private int index;

        protected IndexSplit(String project, String table, List<Attribute> dataColumns, List<Attribute> partitionColumns, List<Attribute> readDataColumns, Map<String, String> partitionSpec, int index) {
            super(project, table, dataColumns, partitionColumns, readDataColumns, partitionSpec);
            this.index = index;
        }

        @Override
        public String getProvider() {
            return "memory";
        }

        int getIndex() {
            return this.index;
        }
    }

    static class Project {
        private Map<String, Table> tables = new ConcurrentHashMap<String, Table>();

        Project() {
        }

        void createTable(String table) {
            this.tables.put(table, new Table());
        }

        boolean tableExists(String table) {
            return this.tables.containsKey(table);
        }

        void dropTable(String table) {
            this.tables.remove(table);
        }

        Table getTable(String table) {
            return this.tables.get(table);
        }
    }
}

