/*
 * Decompiled with CFR 0.152.
 */
package demo.memory;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.table.v1.reader.InputSplit;
import com.aliyun.odps.cupid.table.v1.reader.RequiredSchema;
import com.aliyun.odps.cupid.table.v1.reader.TableReadSession;
import demo.memory.MemoryStore;
import demo.memory.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class MemoryReadSession
extends TableReadSession {
    private InputSplit[] inputSplits;

    MemoryReadSession(String project, String table, TableSchema tableSchema, RequiredSchema readDataColumns, List<Map<String, String>> partitionSpecs) {
        super(project, table, tableSchema, readDataColumns, partitionSpecs);
    }

    @Override
    public InputSplit[] getOrCreateInputSplits(int splitSizeInMB) throws IOException {
        if (this.inputSplits == null) {
            if (this.tableSchema == null) {
                this.tableSchema = new TableSchema();
            }
            Map<String, String> emptyPartSpec = Collections.emptyMap();
            MemoryStore.Table memTable = MemoryStore.getTable(this.project, this.table);
            this.inputSplits = new InputSplit[memTable.getFileCount()];
            for (int i = 0; i < this.inputSplits.length; ++i) {
                this.inputSplits[i] = new MemoryStore.IndexSplit(this.project, this.table, Utils.toAttributes(this.tableSchema.getColumns()), Utils.toAttributes(this.tableSchema.getPartitionColumns()), this.readDataColumns.toList(), emptyPartSpec, i);
            }
        }
        return this.inputSplits;
    }
}

