/*
 * Decompiled with CFR 0.152.
 */
package demo.memory;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.table.v1.reader.InputSplit;
import com.aliyun.odps.cupid.table.v1.reader.ReadCapabilities;
import com.aliyun.odps.cupid.table.v1.reader.RequiredSchema;
import com.aliyun.odps.cupid.table.v1.reader.SplitReader;
import com.aliyun.odps.cupid.table.v1.reader.TableReadSession;
import com.aliyun.odps.cupid.table.v1.util.TableProvider;
import com.aliyun.odps.cupid.table.v1.vectorized.ColDataBatch;
import com.aliyun.odps.cupid.table.v1.writer.FileWriter;
import com.aliyun.odps.cupid.table.v1.writer.TableWriteSession;
import com.aliyun.odps.cupid.table.v1.writer.WriteCapabilities;
import com.aliyun.odps.cupid.table.v1.writer.WriteSessionInfo;
import com.aliyun.odps.data.ArrayRecord;
import demo.memory.MemoryReadSession;
import demo.memory.MemoryReader;
import demo.memory.MemoryStore;
import demo.memory.MemoryWriteSession;
import demo.memory.MemoryWriter;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.VectorSchemaRoot;

public class MemoryProvider
implements TableProvider {
    @Override
    public String getShortName() {
        return "memory";
    }

    @Override
    public TableReadSession createReadSession(String project, String table, TableSchema tableSchema, RequiredSchema readDataColumns, List<Map<String, String>> readPartitions) {
        return new MemoryReadSession(project, table, tableSchema, readDataColumns, readPartitions);
    }

    @Override
    public SplitReader<ArrayRecord> createRecordReader(InputSplit inputSplit) {
        MemoryStore.IndexSplit memSplit = (MemoryStore.IndexSplit)inputSplit;
        return new MemoryReader(memSplit.getProject(), memSplit.getTable(), memSplit.getIndex());
    }

    @Override
    public SplitReader<ColDataBatch> createColDataReader(InputSplit inputSplit, int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SplitReader<VectorSchemaRoot> createArrowReader(InputSplit inputSplit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WriteCapabilities getWriteCapabilities() {
        return new WriteCapabilities(false, false);
    }

    @Override
    public ReadCapabilities getReadCapabilities() {
        return new ReadCapabilities(false, false, false);
    }

    @Override
    public TableWriteSession createWriteSession(String project, String table, TableSchema tableSchema, Map<String, String> partitionSpec, boolean overwrite) {
        return new MemoryWriteSession(project, table, tableSchema, partitionSpec, overwrite);
    }

    @Override
    public TableWriteSession getWriteSession(WriteSessionInfo writeSessionInfo) {
        return new MemoryWriteSession(writeSessionInfo);
    }

    @Override
    public FileWriter<ArrayRecord> createRecordWriter(WriteSessionInfo sessionInfo, Map<String, String> partitionSpec, int fileIndex) {
        return new MemoryWriter(sessionInfo.getProject(), sessionInfo.getTable());
    }

    @Override
    public FileWriter<ColDataBatch> createColDataWriter(WriteSessionInfo sessionInfo, Map<String, String> partitionSpec, int fileIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileWriter<VectorSchemaRoot> createArrowWriter(WriteSessionInfo sessionInfo, Map<String, String> partitionSpec, int fileIndex) {
        throw new UnsupportedOperationException();
    }
}

