/*
 * Decompiled with CFR 0.152.
 */
package demo;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.table.v1.reader.InputSplit;
import com.aliyun.odps.cupid.table.v1.reader.RequiredSchema;
import com.aliyun.odps.cupid.table.v1.reader.SplitReader;
import com.aliyun.odps.cupid.table.v1.reader.SplitReaderBuilder;
import com.aliyun.odps.cupid.table.v1.reader.TableReadSession;
import com.aliyun.odps.cupid.table.v1.reader.TableReadSessionBuilder;
import com.aliyun.odps.cupid.table.v1.writer.FileWriter;
import com.aliyun.odps.cupid.table.v1.writer.FileWriterBuilder;
import com.aliyun.odps.cupid.table.v1.writer.TableWriteSession;
import com.aliyun.odps.cupid.table.v1.writer.TableWriteSessionBuilder;
import com.aliyun.odps.cupid.table.v1.writer.WriteSessionInfo;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import demo.memory.MemoryStore;
import java.io.IOException;

public class Job {
    private String provider;
    private String project;
    private String table;

    public Job(String provider, String project, String table) {
        this.provider = provider;
        this.project = project;
        this.table = table;
    }

    public void run() {
        try {
            MemoryStore.createProject(this.project);
            MemoryStore.createTable(this.project, this.table);
            this.writeTable();
            this.readTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeTable() throws ClassNotFoundException, IOException {
        TableWriteSession session = new TableWriteSessionBuilder(this.provider, this.project, this.table).tableSchema(this.getTableSchema()).build();
        WriteSessionInfo info = session.getOrCreateSessionInfo();
        this.writeData(info, 0);
        this.writeData(info, 1);
        session.commitTable();
    }

    private void writeData(WriteSessionInfo info, int index) throws ClassNotFoundException, IOException {
        FileWriter<ArrayRecord> writer = new FileWriterBuilder(info, index).buildRecordWriter();
        ArrayRecord record = new ArrayRecord(this.getOdpsColumns());
        record.set(0, (Object)(index * 10));
        record.set(1, (Object)("hello " + index));
        writer.write(record);
        record.set(0, (Object)(index * 10 + 1));
        record.set(1, (Object)("world " + index));
        writer.write(record);
        writer.close();
        writer.commit();
    }

    private void readTable() throws ClassNotFoundException, IOException {
        InputSplit[] inputSplits;
        TableReadSession session = new TableReadSessionBuilder(this.provider, this.project, this.table).readDataColumns(RequiredSchema.all()).build();
        for (InputSplit inputSplit : inputSplits = session.getOrCreateInputSplits(256)) {
            this.readSplit(inputSplit);
        }
    }

    private void readSplit(InputSplit inputSplit) throws ClassNotFoundException, IOException {
        SplitReader<ArrayRecord> reader = new SplitReaderBuilder(inputSplit).buildRecordReader();
        while (reader.hasNext()) {
            ArrayRecord record = (ArrayRecord)reader.next();
            System.out.println(record.getInt(0));
            System.out.println(record.getString(1));
        }
    }

    private TableSchema getTableSchema() {
        TableSchema tableSchema = new TableSchema();
        tableSchema.addColumn(new Column("id", (TypeInfo)TypeInfoFactory.INT));
        tableSchema.addColumn(new Column("value", (TypeInfo)TypeInfoFactory.STRING));
        return tableSchema;
    }

    private Column[] getOdpsColumns() {
        return this.getTableSchema().getColumns().toArray(new Column[0]);
    }

    public static void main(String[] args) {
        Job job = new Job("memory", "cupid", "test");
        job.run();
    }
}

