/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.writer.adaptor;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.cupid.table.v1.util.Platform;
import com.aliyun.odps.cupid.table.v1.util.Validator;
import com.aliyun.odps.cupid.table.v1.vectorized.ColDataBatch;
import com.aliyun.odps.cupid.table.v1.vectorized.ColDataVector;
import com.aliyun.odps.cupid.table.v1.writer.FileWriter;
import com.aliyun.odps.cupid.table.v1.writer.adaptor.Row;
import com.aliyun.odps.type.AbstractCharTypeInfo;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class ColDataRowWriter {
    private FileWriter<ColDataBatch> writer;
    private Column[] cols;
    private int batchSize;
    private int rowCount;
    private Map<Integer, Integer> stringColSizeMap = new HashMap<Integer, Integer>(4);
    private byte[][] dataBuf;
    private int[] dataBufSize;
    private byte[][] nulls;
    private byte[][] deepBuf;
    private ColDataVector[] vectors;
    ColDataBatch colDataBatch;

    public ColDataRowWriter(Column[] cols, FileWriter<ColDataBatch> writer) {
        this(cols, writer, 4096);
    }

    public ColDataRowWriter(Column[] cols, FileWriter<ColDataBatch> writer, int batchSize) {
        Validator.checkNotNull(cols, "columns");
        Validator.checkNotNull(writer, "writer");
        Validator.checkInteger(batchSize, 1, "batchSize");
        this.cols = cols;
        this.writer = writer;
        this.batchSize = batchSize;
        this.init();
    }

    public void init() {
        this.vectors = new ColDataVector[this.cols.length];
        this.rowCount = 0;
        this.dataBuf = new byte[this.cols.length][];
        this.dataBufSize = new int[this.cols.length];
        this.nulls = new byte[this.cols.length][];
        this.deepBuf = new byte[this.cols.length][];
        this.initColData();
        this.colDataBatch = new ColDataBatch(this.vectors);
    }

    public void insert(Row row) throws IOException {
        int i = 0;
        while (i < this.dataBuf.length) {
            TypeInfo odpsTypeInfo = this.cols[i].getTypeInfo();
            if (row.isNullAt(i)) {
                this.nulls[i][this.rowCount] = 1;
            } else {
                this.trans(odpsTypeInfo, row, i, this.rowCount);
                this.nulls[i][this.rowCount] = 0;
            }
            int n = i++;
            this.dataBufSize[n] = this.dataBufSize[n] + this.getColumnSize(odpsTypeInfo);
        }
        ++this.rowCount;
        if (this.rowCount == this.batchSize) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        if (this.rowCount > 0) {
            for (int i = 0; i < this.dataBuf.length; ++i) {
                this.vectors[i].setDataBufSize(this.dataBufSize[i]);
            }
            this.colDataBatch.setRowCount(this.rowCount);
            this.writer.write(this.colDataBatch);
            this.reset();
        }
    }

    private void reset() {
        for (int i = 0; i < this.dataBufSize.length; ++i) {
            this.dataBufSize[i] = 0;
            if (this.stringColSizeMap.containsKey(i)) {
                this.stringColSizeMap.put(i, 0);
            }
            Platform.setMemory(this.dataBuf[i], Platform.BYTE_ARRAY_OFFSET, this.dataBuf[i].length, (byte)0);
        }
        this.rowCount = 0;
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.writer.close();
        }
    }

    public void commit() throws IOException {
        this.writer.commit();
    }

    public long getBytesWritten() {
        return this.writer.getBytesWritten();
    }

    public long getRowsWritten() {
        return this.writer.getRowsWritten();
    }

    private void initColData() {
        for (int i = 0; i < this.cols.length; ++i) {
            TypeInfo odpsTypeInfo = this.cols[i].getTypeInfo();
            this.dataBuf[i] = new byte[this.getColumnSize(odpsTypeInfo) * this.batchSize];
            if (this.isString(odpsTypeInfo.getOdpsType()) || this.isOldDecimal(odpsTypeInfo)) {
                this.stringColSizeMap.put(i, 0);
                this.deepBuf[i] = new byte[8 * this.batchSize];
            } else {
                this.deepBuf[i] = null;
            }
            this.dataBufSize[i] = 0;
            this.nulls[i] = new byte[this.batchSize];
            this.vectors[i] = new ColDataVector(new Attribute(this.cols[i].getName(), this.cols[i].getTypeInfo().getTypeName()), this.dataBuf[i], 0, this.nulls[i], this.deepBuf[i]);
        }
    }

    private int getColumnSize(TypeInfo odpsTypeInfo) throws RuntimeException {
        switch (odpsTypeInfo.getOdpsType()) {
            case BOOLEAN: 
            case TINYINT: {
                return 1;
            }
            case SMALLINT: {
                return 2;
            }
            case FLOAT: 
            case INT: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case STRING: {
                return 4;
            }
            case DATE: 
            case BIGINT: 
            case DOUBLE: 
            case DATETIME: {
                return 8;
            }
            case TIMESTAMP: {
                return 12;
            }
            case DECIMAL: {
                return this.getDecimalSize((DecimalTypeInfo)odpsTypeInfo);
            }
        }
        throw new RuntimeException("Unsupport type: " + odpsTypeInfo.getOdpsType());
    }

    private int getDecimalSize(DecimalTypeInfo decimalInfo) {
        if (decimalInfo.getPrecision() > 38) {
            return 4;
        }
        if (decimalInfo.getPrecision() > 18) {
            return 16;
        }
        if (decimalInfo.getPrecision() > 9) {
            return 8;
        }
        if (decimalInfo.getPrecision() > 4) {
            return 4;
        }
        return 2;
    }

    private boolean isString(OdpsType odpsType) {
        return odpsType == OdpsType.STRING || odpsType == OdpsType.VARCHAR || odpsType == OdpsType.BINARY || odpsType == OdpsType.CHAR;
    }

    private boolean isOldDecimal(TypeInfo odpsTypeInfo) {
        return odpsTypeInfo.getOdpsType() == OdpsType.DECIMAL && ((DecimalTypeInfo)odpsTypeInfo).getPrecision() == 54 && ((DecimalTypeInfo)odpsTypeInfo).getScale() == 18;
    }

    private void trans(TypeInfo odpsTypeInfo, Row rec, int ind, int rCnt) throws UnsupportedEncodingException {
        if (this.isString(odpsTypeInfo.getOdpsType())) {
            byte[] utf8bytes = null;
            if (odpsTypeInfo.getOdpsType() == OdpsType.BINARY) {
                utf8bytes = rec.getBytes(ind);
            } else {
                String utf8String = null;
                switch (odpsTypeInfo.getOdpsType()) {
                    case CHAR: {
                        utf8String = rec.getChar(ind).getValue();
                        break;
                    }
                    case VARCHAR: {
                        utf8String = rec.getVarchar(ind).getValue();
                        break;
                    }
                    case STRING: {
                        utf8String = rec.getString(ind);
                    }
                }
                if (odpsTypeInfo.getOdpsType() == OdpsType.CHAR || odpsTypeInfo.getOdpsType() == OdpsType.VARCHAR) {
                    AbstractCharTypeInfo ti = (AbstractCharTypeInfo)odpsTypeInfo;
                    int maxLength = ti.getLength();
                    if (utf8String.length() > maxLength) {
                        utf8String = utf8String.substring(0, maxLength);
                    }
                }
                utf8bytes = utf8String.getBytes("utf-8");
            }
            int numBytes = utf8bytes.length;
            if (this.stringColSizeMap.get(ind) + numBytes > this.deepBuf[ind].length) {
                byte[] newArray = new byte[(this.deepBuf[ind].length + numBytes) * 2];
                System.arraycopy(this.deepBuf[ind], 0, newArray, 0, this.stringColSizeMap.get(ind));
                this.deepBuf[ind] = newArray;
            }
            Platform.copyMemory(utf8bytes, Platform.BYTE_ARRAY_OFFSET, this.deepBuf[ind], Platform.BYTE_ARRAY_OFFSET + this.stringColSizeMap.get(ind), numBytes);
            this.stringColSizeMap.put(ind, this.stringColSizeMap.get(ind) + numBytes);
            Platform.putInt(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 4, numBytes);
        } else {
            switch (odpsTypeInfo.getOdpsType()) {
                case BOOLEAN: {
                    Platform.putBoolean(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt, rec.getBoolean(ind));
                    break;
                }
                case TINYINT: {
                    Platform.putByte(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt, rec.getByte(ind));
                    break;
                }
                case SMALLINT: {
                    Platform.putShort(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 2, rec.getShort(ind));
                    break;
                }
                case FLOAT: {
                    Platform.putFloat(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 4, rec.getFloat(ind));
                    break;
                }
                case INT: {
                    Platform.putInt(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 4, rec.getInt(ind));
                    break;
                }
                case DATE: {
                    Platform.putLong(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 8, DateUtils.getDayOffset((Date)rec.getDate(ind)));
                    break;
                }
                case DATETIME: {
                    Platform.putLong(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 8, DateUtils.date2ms((java.util.Date)rec.getDatetime(ind)));
                    break;
                }
                case TIMESTAMP: {
                    Timestamp timeStamp = rec.getTimeStamp(ind);
                    int nanoSeconds = timeStamp.getNanos();
                    long seconds = timeStamp.getTime() - (long)(nanoSeconds / 1000000 / 1000);
                    Platform.putLong(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 12, seconds);
                    Platform.putInt(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 12 + 8, nanoSeconds);
                    break;
                }
                case BIGINT: {
                    Platform.putLong(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 8, rec.getLong(ind));
                    break;
                }
                case DOUBLE: {
                    Platform.putDouble(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 8, rec.getDouble(ind));
                    break;
                }
                case DECIMAL: {
                    DecimalTypeInfo decimalInfo = (DecimalTypeInfo)odpsTypeInfo;
                    BigDecimal decimal = rec.getDecimal(ind);
                    if (decimalInfo.getPrecision() > 38) {
                        byte[] decimalBytes = decimal.toString().getBytes();
                        int numBytes = decimalBytes.length;
                        if (this.stringColSizeMap.get(ind) + numBytes > this.deepBuf[ind].length) {
                            byte[] newArray = new byte[(this.deepBuf[ind].length + numBytes) * 2];
                            System.arraycopy(this.deepBuf[ind], 0, newArray, 0, this.stringColSizeMap.get(ind));
                            this.deepBuf[ind] = newArray;
                        }
                        System.arraycopy(decimalBytes, 0, this.deepBuf[ind], this.stringColSizeMap.get(ind), numBytes);
                        this.stringColSizeMap.put(ind, this.stringColSizeMap.get(ind) + numBytes);
                        Platform.putInt(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 4, numBytes);
                        break;
                    }
                    if (decimalInfo.getPrecision() > 18) {
                        int i;
                        byte[] byteArray = decimal.unscaledValue().toByteArray();
                        int length = byteArray.length;
                        for (i = 0; i < length; ++i) {
                            Platform.putByte(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 16 + i, byteArray[length - i - 1]);
                        }
                        if (decimal.signum() != -1) break;
                        for (i = length; i < 16; ++i) {
                            Platform.putByte(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 16 + i, (byte)-1);
                        }
                        break;
                    }
                    if (decimalInfo.getPrecision() > 9) {
                        Platform.putLong(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 8, decimal.unscaledValue().longValue());
                        break;
                    }
                    if (decimalInfo.getPrecision() > 4) {
                        Platform.putInt(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 4, decimal.unscaledValue().intValue());
                        break;
                    }
                    Platform.putShort(this.dataBuf[ind], Platform.BYTE_ARRAY_OFFSET + rCnt * 2, decimal.unscaledValue().shortValue());
                    break;
                }
                default: {
                    throw new RuntimeException("not supported type " + odpsTypeInfo.getOdpsType());
                }
            }
        }
    }
}

