/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.writer;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.table.v1.util.Builder;
import com.aliyun.odps.cupid.table.v1.util.ProviderRegistry;
import com.aliyun.odps.cupid.table.v1.util.Validator;
import com.aliyun.odps.cupid.table.v1.writer.TableWriteSession;
import com.aliyun.odps.cupid.table.v1.writer.WriteCapabilities;
import com.aliyun.odps.cupid.table.v1.writer.WriteSessionInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class TableWriteSessionBuilder
extends Builder {
    private String provider;
    private String project;
    private String table;
    private boolean overwrite;
    private TableSchema tableSchema;
    private Map<String, String> partitionSpec;
    private WriteSessionInfo writeSessionInfo;

    public TableWriteSessionBuilder(String provider, String project, String table) {
        Validator.checkString(provider, "provider");
        Validator.checkString(project, "project");
        Validator.checkString(table, "table");
        this.provider = provider;
        this.project = project;
        this.table = table;
    }

    public static WriteCapabilities getProviderCapabilities(String provider) throws ClassNotFoundException {
        Validator.checkString(provider, "provider");
        return ProviderRegistry.lookup(provider).getWriteCapabilities();
    }

    public TableWriteSessionBuilder tableSchema(TableSchema tableSchema) {
        Validator.checkNotNull(tableSchema, "tableSchema");
        this.tableSchema = tableSchema;
        return this;
    }

    public TableWriteSessionBuilder partitionSpec(Map<String, String> partitionSpec) {
        Validator.checkNotNull(partitionSpec, "partitionSpec");
        this.partitionSpec = partitionSpec;
        return this;
    }

    public TableWriteSessionBuilder overwrite(boolean isOverwrite) {
        this.overwrite = isOverwrite;
        return this;
    }

    public TableWriteSessionBuilder writeSessionInfo(WriteSessionInfo writeSessionInfo) {
        Validator.checkNotNull(writeSessionInfo, "writeSessionInfo");
        this.writeSessionInfo = writeSessionInfo;
        return this;
    }

    public TableWriteSession build() throws ClassNotFoundException {
        if (this.writeSessionInfo == null) {
            this.sanitize();
            return ProviderRegistry.lookup(this.provider).createWriteSession(this.project, this.table, this.tableSchema, this.partitionSpec, this.overwrite);
        }
        this.markBuilt();
        return ProviderRegistry.lookup(this.provider).getWriteSession(this.writeSessionInfo);
    }

    private void sanitize() {
        this.markBuilt();
        if (this.partitionSpec == null) {
            this.partitionSpec = Collections.emptyMap();
        } else {
            Validator.checkMap(this.partitionSpec, "partitionSpec");
            this.partitionSpec = Collections.unmodifiableMap(new HashMap<String, String>(this.partitionSpec));
        }
    }
}

