/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.writer;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.table.v1.util.TableUtils;
import com.aliyun.odps.cupid.table.v1.writer.BucketFileInfo;
import com.aliyun.odps.cupid.table.v1.writer.WriteSessionInfo;
import com.aliyun.odps.cupid.table.v1.writer.WriterCommitMessage;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public abstract class TableWriteSession {
    protected final String project;
    protected final String table;
    protected final Map<String, String> partitionSpec;
    protected final boolean overwrite;
    protected TableSchema tableSchema;

    protected TableWriteSession(String project, String table, TableSchema tableSchema, Map<String, String> partitionSpec, boolean overwrite) {
        this.project = project;
        this.table = table;
        this.tableSchema = tableSchema == null ? this.getTableSchema() : tableSchema;
        this.partitionSpec = TableUtils.getOrderedPartitionSpec(this.tableSchema, partitionSpec);
        this.overwrite = overwrite;
    }

    public abstract TableSchema getTableSchema();

    public abstract WriteSessionInfo getOrCreateSessionInfo() throws IOException;

    public abstract void commitTable() throws IOException;

    public abstract void commitTableWithPartitions(List<Map<String, String>> var1) throws IOException;

    public abstract void commitClusteredTable(List<BucketFileInfo> var1) throws IOException;

    public void commitTableWithMessage(List<WriterCommitMessage> commitMessages) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void cleanup() throws IOException;
}

