/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.writer;

import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.cupid.table.v1.util.Builder;
import com.aliyun.odps.cupid.table.v1.util.ProviderRegistry;
import com.aliyun.odps.cupid.table.v1.util.Validator;
import com.aliyun.odps.cupid.table.v1.vectorized.ColDataBatch;
import com.aliyun.odps.cupid.table.v1.writer.FileWriter;
import com.aliyun.odps.cupid.table.v1.writer.WriteSessionInfo;
import com.aliyun.odps.data.ArrayRecord;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.arrow.vector.VectorSchemaRoot;

public final class FileWriterBuilder
extends Builder {
    private final WriteSessionInfo sessionInfo;
    private Map<String, String> partitionSpec;
    private int fileIndex = -1;
    private boolean built;

    public FileWriterBuilder(WriteSessionInfo sessionInfo, int fileIndex) {
        Validator.checkNotNull(sessionInfo, "sessionInfo");
        Validator.checkInteger(fileIndex, 0, "fileIndex");
        this.sessionInfo = sessionInfo;
        this.fileIndex = fileIndex;
    }

    public FileWriterBuilder partitionSpec(Map<String, String> partitionSpec) {
        Validator.checkNotNull(partitionSpec, "partitionSpec");
        this.partitionSpec = partitionSpec;
        return this;
    }

    public FileWriter<ArrayRecord> buildRecordWriter() throws ClassNotFoundException {
        this.sanitize();
        return ProviderRegistry.lookup(this.sessionInfo.getProvider()).createRecordWriter(this.sessionInfo, this.partitionSpec, this.fileIndex);
    }

    public FileWriter<ColDataBatch> buildColDataWriter() throws ClassNotFoundException {
        this.sanitize();
        return ProviderRegistry.lookup(this.sessionInfo.getProvider()).createColDataWriter(this.sessionInfo, this.partitionSpec, this.fileIndex);
    }

    public FileWriter<VectorSchemaRoot> buildArrowWriter() throws ClassNotFoundException {
        this.sanitize();
        return ProviderRegistry.lookup(this.sessionInfo.getProvider()).createArrowWriter(this.sessionInfo, this.partitionSpec, this.fileIndex);
    }

    private void sanitize() {
        this.markBuilt();
        if (this.partitionSpec == null) {
            this.partitionSpec = Collections.emptyMap();
        } else {
            Validator.checkMap(this.partitionSpec, "partitionSpec");
            LinkedHashMap<String, String> orderedPartSpec = new LinkedHashMap<String, String>();
            for (Attribute partAttr : this.sessionInfo.getPartitionColumns()) {
                if (!this.partitionSpec.containsKey(partAttr.getName())) {
                    throw new RuntimeException("invalid partitionSpec for file writer");
                }
                orderedPartSpec.put(partAttr.getName(), this.partitionSpec.get(partAttr.getName()));
            }
            this.partitionSpec = orderedPartSpec;
        }
    }
}

