/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.vectorized;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.cupid.table.v1.util.Platform;
import com.aliyun.odps.cupid.table.v1.util.TableUtils;
import com.aliyun.odps.cupid.table.v1.util.Validator;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Date;

public final class ColDataVector {
    private Attribute column;
    private byte[] dataBuf;
    private int dataBufSize;
    private byte[] nulls;
    private byte[] deepBuf;
    private final OdpsType odpsType;
    private final TypeInfo odpsTypeInfo;
    private int numRows;
    private int numNulls;
    private int[] binaryOffsets;
    private boolean isOldDecimal;

    public ColDataVector(Attribute column, byte[] dataBuf, int dataBufSize, byte[] nulls, byte[] deepBuf) {
        Validator.checkNotNull(column, "column");
        this.column = column;
        this.dataBuf = dataBuf;
        this.dataBufSize = dataBufSize;
        this.nulls = nulls;
        this.deepBuf = deepBuf;
        this.odpsTypeInfo = TableUtils.getTypeInfoFromString(column.getType());
        this.odpsType = this.odpsTypeInfo.getOdpsType();
        this.numNulls = -1;
        this.binaryOffsets = null;
    }

    public void setDataBufSize(int dataBufSize) {
        this.dataBufSize = dataBufSize;
    }

    public void setDeepBuf(byte[] deepBuf) {
        this.deepBuf = deepBuf;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public void setBinaryOffsets(int numRows) {
        if (this.binaryOffsets == null) {
            this.binaryOffsets = new int[numRows];
            int sum = 0;
            for (int i = 0; i < numRows; ++i) {
                this.binaryOffsets[i] = sum;
                sum += this.getBinaryLength(i);
            }
        }
    }

    public boolean hasNull() {
        return this.getNumNulls() > 0;
    }

    public int getNumNulls() {
        if (this.numNulls < 0) {
            this.numNulls = 0;
            for (int i = 0; i < this.numRows; ++i) {
                if (!this.isNullAt(i)) continue;
                ++this.numNulls;
            }
        }
        return this.numNulls;
    }

    public byte[] getDeepBuf() {
        return this.deepBuf;
    }

    public byte[] getNulls() {
        return this.nulls;
    }

    public byte[] getDataBuf() {
        return this.dataBuf;
    }

    public Attribute getColumn() {
        return this.column;
    }

    public OdpsType getOdpsType() {
        return this.odpsType;
    }

    public int getDataBufSize() {
        return this.dataBufSize;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public boolean isNullAt(int rowId) {
        return this.nulls[rowId] == 1;
    }

    public boolean getBoolean(int rowId) {
        return Platform.getBoolean(this.dataBuf, Platform.BYTE_ARRAY_OFFSET + rowId);
    }

    public byte getByte(int rowId) {
        return this.dataBuf[rowId];
    }

    public short getShort(int rowId) {
        return Platform.getShort(this.dataBuf, (long)Platform.BYTE_ARRAY_OFFSET + (long)rowId * 2L);
    }

    public int getInt(int rowId) {
        return Platform.getInt(this.dataBuf, (long)Platform.BYTE_ARRAY_OFFSET + (long)rowId * 4L);
    }

    public long getLong(int rowId) {
        return Platform.getLong(this.dataBuf, (long)Platform.BYTE_ARRAY_OFFSET + (long)rowId * 8L);
    }

    public float getFloat(int rowId) {
        return Platform.getFloat(this.dataBuf, (long)Platform.BYTE_ARRAY_OFFSET + (long)rowId * 4L);
    }

    public double getDouble(int rowId) {
        return Platform.getDouble(this.dataBuf, (long)Platform.BYTE_ARRAY_OFFSET + (long)rowId * 8L);
    }

    public BigDecimal getDecimal(int rowId) {
        int precision = ((DecimalTypeInfo)this.odpsTypeInfo).getPrecision();
        int scale = ((DecimalTypeInfo)this.odpsTypeInfo).getScale();
        if (this.isOldDecimal) {
            String decimalStr = this.getString(rowId);
            try {
                return new BigDecimal(decimalStr);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to get old decimal value: " + decimalStr);
            }
        }
        if (precision > 18) {
            byte[] int128Byte = new byte[16];
            for (int i = 0; i < 16; ++i) {
                int128Byte[15 - i] = Platform.getByte(this.dataBuf, Platform.BYTE_ARRAY_OFFSET + rowId * 16 + i);
            }
            BigInteger bigInteger = new BigInteger(int128Byte);
            return new BigDecimal(bigInteger, scale);
        }
        if (precision > 9) {
            return new BigDecimal(new BigInteger(String.valueOf(Platform.getLong(this.dataBuf, Platform.BYTE_ARRAY_OFFSET + rowId * 8))), scale);
        }
        if (precision > 4) {
            return new BigDecimal(new BigInteger(String.valueOf(Platform.getLong(this.dataBuf, Platform.BYTE_ARRAY_OFFSET + rowId * 4))), scale);
        }
        return new BigDecimal(new BigInteger(String.valueOf(Platform.getLong(this.dataBuf, Platform.BYTE_ARRAY_OFFSET + rowId * 2))), scale);
    }

    public String getString(int rowId) {
        byte[] binary = this.getBinary(rowId);
        return new String(binary, StandardCharsets.UTF_8);
    }

    public byte[] getBinary(int rowId) {
        this.setBinaryOffsets(this.numRows);
        int offset = this.binaryOffsets[rowId];
        int numBytes = this.getBinaryLength(rowId);
        byte[] binary = new byte[numBytes];
        System.arraycopy(this.deepBuf, offset, binary, 0, numBytes);
        return binary;
    }

    public Timestamp getTimestamp(int rowId) {
        long seconds = Platform.getLong(this.dataBuf, rowId * 12 + Platform.BYTE_ARRAY_OFFSET);
        int nano = Platform.getInt(this.dataBuf, rowId * 12 + 8 + Platform.BYTE_ARRAY_OFFSET);
        Timestamp t = new Timestamp(seconds * 1000L);
        t.setNanos(nano);
        return t;
    }

    public java.sql.Date getDate(int rowId) {
        return DateUtils.fromDayOffset((long)this.getLong(rowId));
    }

    public Date getDateTime(int rowId) {
        return new Date(this.getLong(rowId));
    }

    private int getBinaryLength(int rowId) {
        if (this.isOldDecimal) {
            return this.getInt(rowId);
        }
        return (int)this.getLong(rowId * 2);
    }

    private boolean isStringLikeType(OdpsType odpsType) {
        return odpsType == OdpsType.STRING || odpsType == OdpsType.VARCHAR || odpsType == OdpsType.BINARY || odpsType == OdpsType.CHAR;
    }

    private boolean isOldDecimal(TypeInfo odpsTypeInfo) {
        if (odpsTypeInfo.getOdpsType() == OdpsType.DECIMAL && ((DecimalTypeInfo)odpsTypeInfo).getPrecision() == 54 && ((DecimalTypeInfo)odpsTypeInfo).getScale() == 18) {
            this.isOldDecimal = true;
            return true;
        }
        return false;
    }

    public void close() {
        this.column = null;
        this.dataBuf = null;
        this.dataBufSize = 0;
        this.nulls = null;
        this.deepBuf = null;
    }
}

