/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.util;

import java.util.List;
import java.util.Map;

public class Validator {
    public static void checkNotNull(Object arg, String name) {
        if (arg == null) {
            throw new IllegalArgumentException(name + " == null!");
        }
    }

    public static void checkArray(Object[] arg, int minLength, String name) {
        Validator.checkNotNull(arg, name);
        if (arg.length < minLength) {
            throw new IllegalArgumentException(name + " must has at least " + minLength + "items");
        }
        for (Object item : arg) {
            Validator.checkNotNull(item, name + "[x]");
        }
    }

    public static void checkInteger(Integer arg, int minValue, String name) {
        Validator.checkNotNull(arg, name);
        if (arg < minValue) {
            throw new IllegalArgumentException(name + " < " + minValue);
        }
    }

    public static void checkString(String arg, String name) {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty string!");
        }
    }

    public static void checkArray(String[] arg, String name) {
        Validator.checkArray(arg, 1, name);
    }

    public static void checkArray(String[] arg, int minLength, String name) {
        Validator.checkNotNull(arg, name);
        if (arg.length < minLength) {
            throw new IllegalArgumentException(name + " must has at least " + minLength + "items");
        }
        for (String str : arg) {
            Validator.checkString(str, name + "[x]");
        }
    }

    public static void checkMap(Map<String, String> arg, String name) {
        Validator.checkMap(arg, 1, name);
    }

    public static void checkMap(Map<String, String> arg, int minSize, String name) {
        Validator.checkNotNull(arg, name);
        if (arg.size() < minSize) {
            throw new IllegalArgumentException(name + " must has at least " + minSize + "items");
        }
        for (Map.Entry<String, String> entry : arg.entrySet()) {
            Validator.checkString(entry.getKey(), name + " key");
            Validator.checkString(entry.getValue(), name + " value");
        }
    }

    public static void checkList(List<?> arg, String name) {
        Validator.checkList(arg, 1, name);
    }

    public static void checkList(List<?> arg, int minSize, String name) {
        Validator.checkNotNull(arg, name);
        if (arg.size() < minSize) {
            throw new IllegalArgumentException(name + " must has at least " + minSize + "items");
        }
        for (Object item : arg) {
            Validator.checkNotNull(item, name + "[x]");
        }
    }

    public static void checkMapList(List<Map<String, String>> arg, String name) {
        Validator.checkMapList(arg, 1, 1, name);
    }

    public static void checkMapList(List<Map<String, String>> arg, int listMinSize, int mapMinSize, String name) {
        Validator.checkNotNull(arg, name);
        if (arg.size() < listMinSize) {
            throw new IllegalArgumentException(name + " must has at least " + listMinSize + "items");
        }
        for (Map<String, String> map : arg) {
            Validator.checkMap(map, mapMinSize, name + "[x]");
        }
    }

    public static void checkIntList(List<Integer> arg, int minSize, int minValue, String name) {
        Validator.checkNotNull(arg, name);
        if (arg.size() < minSize) {
            throw new IllegalArgumentException(name + " must has at least " + minSize + "items");
        }
        for (Integer value : arg) {
            Validator.checkInteger(value, minValue, name + "[x]");
        }
    }

    public static void checkBucketFileIndices(Map<Integer, List<Integer>> arg, String name) {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException(name + " is null or empty map!");
        }
        for (Map.Entry<Integer, List<Integer>> entry : arg.entrySet()) {
            Validator.checkInteger(entry.getKey(), 0, name + " key");
            Validator.checkIntList(entry.getValue(), 1, 0, name + " value");
        }
    }
}

