/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.util;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.cupid.table.v1.writer.WriteSessionInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableUtils {
    public static Column[] toColumnArray(List<Attribute> attributes) {
        Column[] result = null;
        if (attributes != null) {
            ArrayList columns = new ArrayList(attributes.size());
            attributes.forEach(dataCol -> {
                Column column = new Column(dataCol.getName(), TableUtils.getTypeInfoFromString(dataCol.getType()));
                columns.add(column);
            });
            result = columns.toArray(new Column[0]);
        }
        return result;
    }

    public static Map<String, String> getOrderedPartitionSpec(TableSchema tableSchema, Map<String, String> partitionSpec) {
        if (tableSchema == null) {
            throw new RuntimeException("tableSchema cannot be null");
        }
        LinkedHashMap<String, String> orderedPartSpec = new LinkedHashMap<String, String>();
        tableSchema.getPartitionColumns().stream().forEach(column -> orderedPartSpec.put(column.getName(), (String)partitionSpec.get(column.getName())));
        return orderedPartSpec;
    }

    public static TableSchema toTableSchema(WriteSessionInfo writeSessionInfo) {
        TableSchema tableSchema = new TableSchema();
        if (writeSessionInfo.getDataColumns() != null) {
            ArrayList dataColumns = new ArrayList(writeSessionInfo.getDataColumns().size());
            writeSessionInfo.getDataColumns().forEach(dataCol -> {
                Column column = new Column(dataCol.getName(), TableUtils.getTypeInfoFromString(dataCol.getType()));
                dataColumns.add(column);
            });
            tableSchema.setColumns(dataColumns);
        }
        if (writeSessionInfo.getPartitionColumns() != null) {
            ArrayList partitionColumns = new ArrayList(writeSessionInfo.getPartitionColumns().size());
            writeSessionInfo.getPartitionColumns().forEach(partiCol -> {
                Column column = new Column(partiCol.getName(), TableUtils.getTypeInfoFromString(partiCol.getType()));
                partitionColumns.add(column);
            });
            tableSchema.setPartitionColumns(partitionColumns);
        }
        return tableSchema;
    }

    public static TypeInfo getTypeInfoFromString(String typeName) {
        TypeInfo typeInfo = TypeInfoParser.getTypeInfoFromTypeString((String)typeName);
        if (typeInfo == null) {
            throw new RuntimeException("parse odps type info fail");
        }
        return typeInfo;
    }
}

