/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.util;

import com.aliyun.odps.cupid.table.v1.util.TableProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class ProviderRegistry {
    private static Map<String, TableProvider> providerStore = new HashMap<String, TableProvider>();

    public static TableProvider lookup(String shortName) throws ClassNotFoundException {
        ServiceLoader<TableProvider> loader = ServiceLoader.load(TableProvider.class, ProviderRegistry.class.getClassLoader());
        for (TableProvider provider : loader) {
            providerStore.put(provider.getShortName(), provider);
        }
        TableProvider provider = providerStore.get(shortName);
        if (provider == null) {
            throw new ClassNotFoundException(shortName);
        }
        return provider;
    }

    static {
        ServiceLoader<TableProvider> loader = ServiceLoader.load(TableProvider.class);
        for (TableProvider provider : loader) {
            providerStore.put(provider.getShortName(), provider);
        }
    }
}

