/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.reader.function;

import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.type.TypeInfoFactory;

public abstract class FunctionCall {
    private final String functionName;
    private final String attribute;
    private final String[] literalArgs;

    public Attribute toAttribute() {
        return new Attribute(this.makeFullName(), TypeInfoFactory.STRING.getTypeName());
    }

    protected FunctionCall(String functionName, String attribute, String[] literalArgs) {
        this.functionName = functionName;
        this.attribute = attribute;
        this.literalArgs = literalArgs;
    }

    private String makeFullName() {
        StringBuilder b = new StringBuilder(this.functionName);
        b.append("(`");
        b.append(this.attribute);
        b.append("`");
        String[] args = this.literalArgs;
        for (int i = 0; i < args.length; ++i) {
            b.append("`");
            b.append(args[i]);
            b.append("`");
            if (i >= args.length - 1) continue;
            b.append(", ");
        }
        return b.append(')').toString();
    }
}

