/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.reader;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.cupid.table.v1.reader.PartitionSpecWithBucketFilter;
import com.aliyun.odps.cupid.table.v1.reader.ReadCapabilities;
import com.aliyun.odps.cupid.table.v1.reader.RequiredSchema;
import com.aliyun.odps.cupid.table.v1.reader.TableReadSession;
import com.aliyun.odps.cupid.table.v1.reader.filter.FilterExpression;
import com.aliyun.odps.cupid.table.v1.reader.function.FunctionCall;
import com.aliyun.odps.cupid.table.v1.util.Builder;
import com.aliyun.odps.cupid.table.v1.util.ProviderRegistry;
import com.aliyun.odps.cupid.table.v1.util.TableProvider;
import com.aliyun.odps.cupid.table.v1.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class TableReadSessionBuilder
extends Builder {
    private String provider;
    private String project;
    private String table;
    private TableSchema tableSchema;
    private RequiredSchema readDataColumns;
    private List<PartitionSpecWithBucketFilter> readPartitions;
    private List<Integer> bucketFilter;
    private boolean splitAtBucketLevel;
    private List<FilterExpression> filterExpressions;
    private List<FunctionCall> functionCalls;
    private List<Map<String, String>> partitionSpecs;
    private List<List<Integer>> partitionBucketFilters;

    public static ReadCapabilities getProviderCapabilities(String provider) throws ClassNotFoundException {
        Validator.checkString(provider, "provider");
        return ProviderRegistry.lookup(provider).getReadCapabilities();
    }

    public TableReadSessionBuilder(String provider, String project, String table) {
        Validator.checkString(provider, "provider");
        Validator.checkString(project, "project");
        Validator.checkString(table, "table");
        this.provider = provider;
        this.project = project;
        this.table = table;
    }

    public TableReadSessionBuilder tableSchema(TableSchema tableSchema) {
        Validator.checkNotNull(tableSchema, "tableSchema");
        this.tableSchema = tableSchema;
        return this;
    }

    public TableReadSessionBuilder readDataColumns(RequiredSchema readDataColumns) {
        Validator.checkNotNull(readDataColumns, "readDataColumns");
        this.readDataColumns = readDataColumns;
        return this;
    }

    public TableReadSessionBuilder readPartitions(List<PartitionSpecWithBucketFilter> readPartitions) {
        Validator.checkNotNull(readPartitions, "readPartitions");
        this.readPartitions = readPartitions;
        return this;
    }

    public TableReadSessionBuilder bucketFilter(List<Integer> bucketFilter) {
        Validator.checkNotNull(bucketFilter, "readPartitions");
        this.bucketFilter = bucketFilter;
        return this;
    }

    public TableReadSessionBuilder splitAtBucketLevel(boolean splitAtBucketLevel) {
        this.splitAtBucketLevel = splitAtBucketLevel;
        return this;
    }

    public TableReadSessionBuilder filterExpressions(List<FilterExpression> filterExpressions) {
        Validator.checkNotNull(filterExpressions, "filterExpressions");
        this.filterExpressions = filterExpressions;
        return this;
    }

    public TableReadSessionBuilder functionCalls(List<FunctionCall> functionCalls) {
        Validator.checkNotNull(functionCalls, "functionCalls");
        this.functionCalls = functionCalls;
        return this;
    }

    public TableReadSession build() throws ClassNotFoundException {
        this.sanitizeBasicInfo();
        TableProvider tableProvider = ProviderRegistry.lookup(this.provider);
        ReadCapabilities capabilities = tableProvider.getReadCapabilities();
        TableReadSession session = tableProvider.createReadSession(this.project, this.table, this.tableSchema, this.readDataColumns, this.partitionSpecs);
        this.sanitizeExtendedInfo(capabilities, session);
        return session;
    }

    private void sanitizeBasicInfo() {
        this.markBuilt();
        if (this.readDataColumns == null) {
            throw new IllegalArgumentException("readDataColumns required");
        }
        if (this.readPartitions == null) {
            this.partitionSpecs = Collections.emptyList();
            this.partitionBucketFilters = Collections.emptyList();
        } else {
            Validator.checkList(this.readPartitions, "readPartitions");
            this.partitionSpecs = new ArrayList<Map<String, String>>();
            this.partitionBucketFilters = new ArrayList<List<Integer>>();
            for (PartitionSpecWithBucketFilter p : this.readPartitions) {
                this.partitionSpecs.add(p.getPartitionSpec());
                this.partitionBucketFilters.add(p.getBucketFilter());
            }
            this.partitionSpecs = Collections.unmodifiableList(this.partitionSpecs);
            this.partitionBucketFilters = Collections.unmodifiableList(this.partitionBucketFilters);
        }
    }

    private void sanitizeExtendedInfo(ReadCapabilities capabilities, TableReadSession session) {
        List<Attribute> functionCallResults;
        if (this.bucketFilter == null) {
            this.bucketFilter = Collections.emptyList();
        } else {
            Validator.checkIntList(this.bucketFilter, 1, 0, "bucketFilter");
            this.bucketFilter = Collections.unmodifiableList(new ArrayList<Integer>(this.bucketFilter));
        }
        if (capabilities.supportBuckets()) {
            session.setBucketFilter(this.bucketFilter);
            session.setPartitionBucketFilters(this.partitionBucketFilters);
            session.setSplitAtBucketLevel(this.splitAtBucketLevel);
        } else if (this.needBucketSupport()) {
            throw new IllegalArgumentException(this.provider + " provider does not support buckets");
        }
        if (this.filterExpressions == null) {
            this.filterExpressions = Collections.emptyList();
        } else {
            Validator.checkList(this.filterExpressions, "filterExpressions");
            this.filterExpressions = Collections.unmodifiableList(new ArrayList<FilterExpression>(this.filterExpressions));
        }
        if (capabilities.supportPushDownFilters()) {
            session.setFilterExpressions(this.filterExpressions);
        } else if (!this.filterExpressions.isEmpty()) {
            throw new IllegalArgumentException(this.provider + " provider does not support push down filters");
        }
        if (this.functionCalls == null) {
            functionCallResults = Collections.emptyList();
        } else {
            Validator.checkList(this.functionCalls, "functionCalls");
            functionCallResults = new ArrayList();
            for (FunctionCall f : this.functionCalls) {
                functionCallResults.add(f.toAttribute());
            }
            functionCallResults = Collections.unmodifiableList(functionCallResults);
        }
        if (capabilities.supportPushDownFunctionCalls()) {
            session.setFunctionCalls(functionCallResults);
        } else if (!functionCallResults.isEmpty()) {
            throw new IllegalArgumentException(this.provider + " provider does not support push down function calls");
        }
    }

    private boolean needBucketSupport() {
        if (!this.bucketFilter.isEmpty() || this.splitAtBucketLevel) {
            return true;
        }
        for (List<Integer> f : this.partitionBucketFilters) {
            if (f.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

