/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.reader;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.cupid.table.v1.reader.InputSplit;
import com.aliyun.odps.cupid.table.v1.reader.RequiredSchema;
import com.aliyun.odps.cupid.table.v1.reader.filter.FilterExpression;
import com.aliyun.odps.cupid.table.v1.util.TableUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class TableReadSession {
    protected final String project;
    protected final String table;
    protected TableSchema tableSchema;
    protected final RequiredSchema readDataColumns;
    protected final List<Map<String, String>> partitionSpecs;

    protected TableReadSession(String project, String table, TableSchema tableSchema, RequiredSchema readDataColumns, List<Map<String, String>> partitionSpecs) {
        this.project = project;
        this.table = table;
        this.tableSchema = tableSchema == null ? this.getTableSchema() : tableSchema;
        this.readDataColumns = readDataColumns;
        this.partitionSpecs = partitionSpecs.stream().map(partitionSpec -> TableUtils.getOrderedPartitionSpec(this.tableSchema, partitionSpec)).collect(Collectors.toList());
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public abstract InputSplit[] getOrCreateInputSplits(int var1) throws IOException;

    protected void setBucketFilter(List<Integer> bucketFilter) {
        throw new UnsupportedOperationException();
    }

    protected void setPartitionBucketFilters(List<List<Integer>> partitionBucketFilters) {
        throw new UnsupportedOperationException();
    }

    protected void setSplitAtBucketLevel(boolean splitAtBucketLevel) {
        throw new UnsupportedOperationException();
    }

    protected void setFilterExpressions(List<FilterExpression> filterExpressions) {
        throw new UnsupportedOperationException();
    }

    protected void setFunctionCalls(List<Attribute> functionCalls) {
        throw new UnsupportedOperationException();
    }
}

