/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.reader;

import com.aliyun.odps.cupid.table.v1.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PartitionSpecWithBucketFilter {
    private final Map<String, String> partitionSpec;
    private List<Integer> bucketFilter;

    public PartitionSpecWithBucketFilter(Map<String, String> partitionSpec) {
        Validator.checkMap(partitionSpec, "partitionSpec");
        this.partitionSpec = partitionSpec;
    }

    public PartitionSpecWithBucketFilter(Map<String, String> partitionSpec, List<Integer> bucketFilter) {
        Validator.checkMap(partitionSpec, "partitionSpec");
        Validator.checkIntList(bucketFilter, 1, 0, "bucketFilter");
        this.partitionSpec = partitionSpec;
        this.bucketFilter = bucketFilter;
    }

    Map<String, String> getPartitionSpec() {
        return Collections.unmodifiableMap(new HashMap<String, String>(this.partitionSpec));
    }

    List<Integer> getBucketFilter() {
        if (this.bucketFilter == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<Integer>(this.bucketFilter));
    }
}

