/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver.ui;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Status$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$ExecutionState$;
import org.apache.spark.sql.hive.thriftserver.SparkOperationLogManager$;
import org.apache.spark.sql.hive.thriftserver.ui.ExecutionInfo;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2Listener$;
import org.apache.spark.sql.hive.thriftserver.ui.LiveExecutionData;
import org.apache.spark.sql.hive.thriftserver.ui.LiveSessionData;
import org.apache.spark.sql.hive.thriftserver.ui.SessionInfo;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationCanceled;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationClosed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationError;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationFinish;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationParsed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationStart;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationTimeout;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerSessionClosed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerSessionCreated;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.status.LiveEntity;
import org.apache.spark.util.kvstore.KVStoreView;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rUa!B\u001e=\u0001yR\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011}\u0003!\u0011!Q\u0001\n\u0001D\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tg\u0002\u0011\t\u0011)A\u0005i\")q\u000f\u0001C\u0001q\"Aq\u0010\u0001b\u0001\n\u0013\t\t\u0001\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0002\u0011%\t)\u0004\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u001d\u0011%\t\u0019\u0005\u0001b\u0001\n\u0013\t)\u0005\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA$\u0011%\tY\u0005\u0001b\u0001\n\u0013\t)\u0005\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA$\u0011%\ty\u0005\u0001b\u0001\n\u0013\t\t\u0006\u0003\u0005\u0002n\u0001\u0001\u000b\u0011BA*\u00111\ty\u0007\u0001I\u0001\u0002\u0007\u0005\u000b\u0011BA9\u0011%\t9\b\u0001b\u0001\n\u0013\tI\b\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA+\u0011%\ti\b\u0001b\u0001\n\u0013\tI\b\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0011BA+\u00111\t\t\t\u0001I\u0001\u0002\u0007\u0005\u000b\u0011BAB\u0011%\tY\t\u0001b\u0001\n\u0013\ti\tC\u0004\u0002\u0010\u0002\u0001\u000b\u0011\u0002;\t\u0013\u0005E\u0005A1A\u0005\n\u0005M\u0005\u0002CAK\u0001\u0001\u0006I!!\"\t\u0013\u0005]\u0005A1A\u0005\n\u0005M\u0005\u0002CAM\u0001\u0001\u0006I!!\"\t\u0011\u0005m\u0005\u0001\"\u0001?\u0003;Cq!a(\u0001\t\u0013\t\t\u000bC\u0004\u00022\u0002!\t%a-\t\u000f\u0005}\u0006\u0001\"\u0011\u0002B\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007bBAn\u0001\u0011\u0005\u0013Q\u001c\u0005\b\u0003S\u0004A\u0011IAv\u0011\u001d\t9\u0010\u0001C\u0005\u0003sDqA!\u0003\u0001\t\u0003\u0012Y\u0001C\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(!9!\u0011\u0007\u0001\u0005\n\tM\u0002b\u0002B\u001f\u0001\u0011%!q\b\u0005\b\u0005\u0013\u0002A\u0011\u0002B&\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/BqA!\u0019\u0001\t\u0013\u0011\u0019\u0007C\u0004\u0003n\u0001!IAa\u001c\t\u000f\te\u0004\u0001\"\u0003\u0003|!9!Q\u0011\u0001\u0005\u0002\t\u001d\u0005b\u0002BJ\u0001\u0011\u0005!Q\u0013\u0005\n\u0005;\u0003\u0011\u0013!C\u0001\u0005?CqA!.\u0001\t\u0013\u00119\fC\u0004\u0003D\u0002!IA!2\t\u000f\t]\u0007\u0001\"\u0003\u0003Z\"9!1\u001e\u0001\u0005\n\t5\bb\u0002Bz\u0001\u0011%!Q\u001f\u0005\b\u0005s\u0004A\u0011\u0002B~\u000f)\u0019)\u0001PA\u0001\u0012\u0003q4q\u0001\u0004\nwq\n\t\u0011#\u0001?\u0007\u0013Aaa\u001e\u001d\u0005\u0002\rE\u0001\"CB\nqE\u0005I\u0011\u0001BP\u0005eA\u0015N^3UQJLg\r^*feZ,'O\r'jgR,g.\u001a:\u000b\u0005ur\u0014AA;j\u0015\ty\u0004)\u0001\u0007uQJLg\r^:feZ,'O\u0003\u0002B\u0005\u0006!\u0001.\u001b<f\u0015\t\u0019E)A\u0002tc2T!!\u0012$\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dC\u0015AB1qC\u000eDWMC\u0001J\u0003\ry'oZ\n\u0004\u0001-\u000b\u0006C\u0001'P\u001b\u0005i%B\u0001(E\u0003%\u00198\r[3ek2,'/\u0003\u0002Q\u001b\ni1\u000b]1sW2K7\u000f^3oKJ\u0004\"AU+\u000e\u0003MS!\u0001\u0016#\u0002\u0011%tG/\u001a:oC2L!AV*\u0003\u000f1{wmZ5oO\u000691N^:u_J,7\u0001\u0001\t\u00035vk\u0011a\u0017\u0006\u00039\u0012\u000baa\u001d;biV\u001c\u0018B\u00010\\\u0005Q)E.Z7f]R$&/Y2lS:<7\u000b^8sK\u0006I1\u000f]1sW\u000e{gN\u001a\t\u0003C\nl\u0011\u0001R\u0005\u0003G\u0012\u0013\u0011b\u00159be.\u001cuN\u001c4\u0002\rM,'O^3s!\r1\u0017n[\u0007\u0002O*\t\u0001.A\u0003tG\u0006d\u0017-\u0003\u0002kO\n1q\n\u001d;j_:\u0004\"\u0001\\9\u000e\u00035T!\u0001\u001a8\u000b\u0005=\u0004\u0018aB:feZL7-\u001a\u0006\u0003\u0003\u001aK!A]7\u0003\u0017!Kg/Z*feZ,'OM\u0001\u0005Y&4X\r\u0005\u0002gk&\u0011ao\u001a\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q)\u0011p\u001f?~}B\u0011!\u0010A\u0007\u0002y!)q+\u0002a\u00013\")q,\u0002a\u0001A\")A-\u0002a\u0001K\"91/\u0002I\u0001\u0002\u0004!\u0018aC:fgNLwN\u001c'jgR,\"!a\u0001\u0011\u0011\u0005\u0015\u00111CA\f\u0003[i!!a\u0002\u000b\t\u0005%\u00111B\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0007\u0003\u001f\tA!\u001e;jY*\u0011\u0011\u0011C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0016\u0005\u001d!!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u0011\u0011DA\u0014\u001d\u0011\tY\"a\t\u0011\u0007\u0005uq-\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005-\u0002\rq\u0012xn\u001c;?\u0013\r\t)cZ\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00121\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015r\rE\u0002{\u0003_I1!!\r=\u0005=a\u0015N^3TKN\u001c\u0018n\u001c8ECR\f\u0017\u0001D:fgNLwN\u001c'jgR\u0004\u0013!D3yK\u000e,H/[8o\u0019&\u001cH/\u0006\u0002\u0002:AA\u0011QAA\n\u0003/\tY\u0004E\u0002{\u0003{I1!a\u0010=\u0005Ea\u0015N^3Fq\u0016\u001cW\u000f^5p]\u0012\u000bG/Y\u0001\u000fKb,7-\u001e;j_:d\u0015n\u001d;!\u00031QwNY%ee\u0015CXmY%e+\t\t9\u0005\u0005\u0005\u0002\u0006\u0005M\u0011qCA\f\u00035QwNY%ee\u0015CXmY%eA\u0005q1\u000f^1hK&#''\u0012=fG&#\u0017aD:uC\u001e,\u0017\n\u001a\u001aFq\u0016\u001c\u0017\n\u001a\u0011\u0002\u001d)|'-\u001333'R\fw-Z%egV\u0011\u00111\u000b\t\t\u0003\u000b\t\u0019\"!\u0016\u0002\\A\u0019a-a\u0016\n\u0007\u0005esMA\u0002J]R\u0004b!!\u0018\u0002h\u0005Uc\u0002BA0\u0003GrA!!\b\u0002b%\t\u0001.C\u0002\u0002f\u001d\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002j\u0005-$aA*fc*\u0019\u0011QM4\u0002\u001f)|'-\u001333'R\fw-Z%eg\u0002\n1\u0001\u001f\u00132!\u001d1\u00171OA+\u0003+J1!!\u001eh\u0005\u0019!V\u000f\u001d7fe\u0005\u0011\"/\u001a;bS:,Gm\u0015;bi\u0016lWM\u001c;t+\t\t)&A\nsKR\f\u0017N\\3e'R\fG/Z7f]R\u001c\b%\u0001\tsKR\f\u0017N\\3e'\u0016\u001c8/[8og\u0006\t\"/\u001a;bS:,GmU3tg&|gn\u001d\u0011\u0002\u0007a$#\u0007\u0005\u0004g\u0003g\"\u0018Q\u0011\t\u0004M\u0006\u001d\u0015bAAEO\n!Aj\u001c8h\u0003M\u0001(o\\4sKN\u001cXI^3oi\u0016s\u0017M\u00197f+\u0005!\u0018\u0001\u00069s_\u001e\u0014Xm]:Fm\u0016tG/\u00128bE2,\u0007%A\u000bqe><'/Z:t\u000bZ,g\u000e^%oi\u0016\u0014h/\u00197\u0016\u0005\u0005\u0015\u0015A\u00069s_\u001e\u0014Xm]:Fm\u0016tG/\u00138uKJ4\u0018\r\u001c\u0011\u0002%1Lg/Z+qI\u0006$X\rU3sS>$gj]\u0001\u0014Y&4X-\u00169eCR,\u0007+\u001a:j_\u0012t5\u000fI\u0001\u000b]>d\u0015N^3ECR\fG#\u0001;\u0002#]\u0014\u0018\u000e^3Pa\u0016\u0014\u0018\r^5p]2{w\r\u0006\u0004\u0002$\u0006%\u0016Q\u0016\t\u0004M\u0006\u0015\u0016bAATO\n!QK\\5u\u0011\u001d\tY+\ba\u0001\u0003/\ta!\u001a=fG&#\u0007bBAX;\u0001\u0007\u0011qC\u0001\u0004[N<\u0017\u0001E8o\u0003B\u0004H.[2bi&|g.\u00128e)\u0011\t\u0019+!.\t\u000f\u0005]f\u00041\u0001\u0002:\u0006q\u0011\r\u001d9mS\u000e\fG/[8o\u000b:$\u0007c\u0001'\u0002<&\u0019\u0011QX'\u00037M\u0003\u0018M]6MSN$XM\\3s\u0003B\u0004H.[2bi&|g.\u00128e\u0003)ygNS8c'R\f'\u000f\u001e\u000b\u0005\u0003G\u000b\u0019\rC\u0004\u0002F~\u0001\r!a2\u0002\u0011)|'m\u0015;beR\u00042\u0001TAe\u0013\r\tY-\u0014\u0002\u0016'B\f'o\u001b'jgR,g.\u001a:K_\n\u001cF/\u0019:u\u0003!ygNS8c\u000b:$G\u0003BAR\u0003#Dq!a5!\u0001\u0004\t).\u0001\u0004k_\n,e\u000e\u001a\t\u0004\u0019\u0006]\u0017bAAm\u001b\n\u00192\u000b]1sW2K7\u000f^3oKJTuNY#oI\u0006IqN\u001c+bg.,e\u000e\u001a\u000b\u0005\u0003G\u000by\u000eC\u0004\u0002b\u0006\u0002\r!a9\u0002\u000fQ\f7o[#oIB\u0019A*!:\n\u0007\u0005\u001dXJ\u0001\u000bTa\u0006\u00148\u000eT5ti\u0016tWM\u001d+bg.,e\u000eZ\u0001\u0011_:\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012$B!a)\u0002n\"9\u0011q\u001e\u0012A\u0002\u0005E\u0018AD:uC\u001e,7i\\7qY\u0016$X\r\u001a\t\u0004\u0019\u0006M\u0018bAA{\u001b\nY2\u000b]1sW2K7\u000f^3oKJ\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012\f\u0001#\u001e9eCR,'j\u001c2EKR\f\u0017\u000e\\:\u0015\u0011\u0005\r\u00161`A\u0000\u0005\u000bAq!!@$\u0001\u0004\t9\"A\u0003k_\nLE\rC\u0004\u0003\u0002\r\u0002\rAa\u0001\u0002\u0011M$\u0018mZ3JIN\u0004b!!\u0018\u0002h\u0005]\u0001b\u0002B\u0004G\u0001\u0007\u0011qC\u0001\bOJ|W\u000f]%e\u00031ygn\u0014;iKJ,e/\u001a8u)\u0011\t\u0019K!\u0004\t\u000f\t=A\u00051\u0001\u0003\u0012\u0005)QM^3oiB\u0019AJa\u0005\n\u0007\tUQJ\u0001\nTa\u0006\u00148\u000eT5ti\u0016tWM]#wK:$\u0018\u0001E8o'\u0016\u001c8/[8o\u0007J,\u0017\r^3e)\u0011\t\u0019Ka\u0007\t\u000f\tuQ\u00051\u0001\u0003 \u0005\tQ\rE\u0002{\u0005CI1Aa\t=\u0005\u001d\u001a\u0006/\u0019:l\u0019&\u001cH/\u001a8feRC'/\u001b4u'\u0016\u0014h/\u001a:TKN\u001c\u0018n\u001c8De\u0016\fG/\u001a3\u0002\u001f=t7+Z:tS>t7\t\\8tK\u0012$B!a)\u0003*!9!Q\u0004\u0014A\u0002\t-\u0002c\u0001>\u0003.%\u0019!q\u0006\u001f\u0003MM\u0003\u0018M]6MSN$XM\\3s)\"\u0014\u0018N\u001a;TKJ4XM]*fgNLwN\\\"m_N,G-\u0001\tp]>\u0003XM]1uS>t7\u000b^1siR!\u00111\u0015B\u001b\u0011\u001d\u0011ib\na\u0001\u0005o\u00012A\u001fB\u001d\u0013\r\u0011Y\u0004\u0010\u0002('B\f'o\u001b'jgR,g.\u001a:UQJLg\r^*feZ,'o\u00149fe\u0006$\u0018n\u001c8Ti\u0006\u0014H/A\tp]>\u0003XM]1uS>t\u0007+\u0019:tK\u0012$B!a)\u0003B!9!Q\u0004\u0015A\u0002\t\r\u0003c\u0001>\u0003F%\u0019!q\t\u001f\u0003QM\u0003\u0018M]6MSN$XM\\3s)\"\u0014\u0018N\u001a;TKJ4XM](qKJ\fG/[8o!\u0006\u00148/\u001a3\u0002'=tw\n]3sCRLwN\\\"b]\u000e,G.\u001a3\u0015\t\u0005\r&Q\n\u0005\b\u0005;I\u0003\u0019\u0001B(!\rQ(\u0011K\u0005\u0004\u0005'b$AK*qCJ\\G*[:uK:,'\u000f\u00165sS\u001a$8+\u001a:wKJ|\u0005/\u001a:bi&|gnQ1oG\u0016dW\rZ\u0001\u0013_:|\u0005/\u001a:bi&|g\u000eV5nK>,H\u000f\u0006\u0003\u0002$\ne\u0003b\u0002B\u000fU\u0001\u0007!1\f\t\u0004u\nu\u0013b\u0001B0y\tI3\u000b]1sW2K7\u000f^3oKJ$\u0006N]5giN+'O^3s\u001fB,'/\u0019;j_:$\u0016.\\3pkR\f\u0001c\u001c8Pa\u0016\u0014\u0018\r^5p]\u0016\u0013(o\u001c:\u0015\t\u0005\r&Q\r\u0005\b\u0005;Y\u0003\u0019\u0001B4!\rQ(\u0011N\u0005\u0004\u0005Wb$aJ*qCJ\\G*[:uK:,'\u000f\u00165sS\u001a$8+\u001a:wKJ|\u0005/\u001a:bi&|g.\u0012:s_J\f1c\u001c8Pa\u0016\u0014\u0018\r^5p]\u001aKg.[:iK\u0012$B!a)\u0003r!9!Q\u0004\u0017A\u0002\tM\u0004c\u0001>\u0003v%\u0019!q\u000f\u001f\u0003QM\u0003\u0018M]6MSN$XM\\3s)\"\u0014\u0018N\u001a;TKJ4XM](qKJ\fG/[8o\r&t\u0017n\u001d5\u0002#=tw\n]3sCRLwN\\\"m_N,G\r\u0006\u0003\u0002$\nu\u0004b\u0002B\u000f[\u0001\u0007!q\u0010\t\u0004u\n\u0005\u0015b\u0001BBy\tA3\u000b]1sW2K7\u000f^3oKJ$\u0006N]5giN+'O^3s\u001fB,'/\u0019;j_:\u001cEn\\:fI\u0006iR\u000f\u001d3bi\u0016\u001cFo\u001c:f/&$\b\u000e\u0016:jO\u001e,'/\u00128bE2,G\r\u0006\u0003\u0002$\n%\u0005b\u0002BF]\u0001\u0007!QR\u0001\u0007K:$\u0018\u000e^=\u0011\u0007i\u0013y)C\u0002\u0003\u0012n\u0013!\u0002T5wK\u0016sG/\u001b;z\u0003=)\b\u000fZ1uK2Kg/Z*u_J,GCBAR\u0005/\u0013I\nC\u0004\u0003\f>\u0002\rA!$\t\u0011\tmu\u0006%AA\u0002Q\fq\u0001\u001e:jO\u001e,'/A\rva\u0012\fG/\u001a'jm\u0016\u001cFo\u001c:fI\u0011,g-Y;mi\u0012\u0012TC\u0001BQU\r!(1U\u0016\u0003\u0005K\u0003BAa*\u000326\u0011!\u0011\u0016\u0006\u0005\u0005W\u0013i+A\u0005v]\u000eDWmY6fI*\u0019!qV4\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00034\n%&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)a\r\\;tQR!\u00111\u0015B]\u0011\u001d\u0011Y,\ra\u0001\u0005{\u000bq\"\u001a8uSRLh\t\\;tQ\u001a+hn\u0019\t\bM\n}&QRAR\u0013\r\u0011\tm\u001a\u0002\n\rVt7\r^5p]F\n!cZ3u\u001fJ\u001c%/Z1uKN+7o]5p]RQ\u0011Q\u0006Bd\u0005\u0017\u0014yMa5\t\u000f\t%'\u00071\u0001\u0002\u0018\u0005I1/Z:tS>t\u0017\n\u001a\u0005\b\u0005\u001b\u0014\u0004\u0019AAC\u0003%\u0019H/\u0019:u)&lW\rC\u0004\u0003RJ\u0002\r!a\u0006\u0002\u0005%\u0004\bb\u0002Bke\u0001\u0007\u0011qC\u0001\tkN,'O\\1nK\u0006!r-\u001a;Pe\u000e\u0013X-\u0019;f\u000bb,7-\u001e;j_:$B\"a\u000f\u0003\\\nu'\u0011\u001dBr\u0005ODq!a+4\u0001\u0004\t9\u0002C\u0004\u0003`N\u0002\r!a\u0006\u0002\u0013M$\u0018\r^3nK:$\bb\u0002Beg\u0001\u0007\u0011q\u0003\u0005\b\u0005K\u001c\u0004\u0019AAC\u00039\u0019H/\u0019:u)&lWm\u001d;b[BDqA!;4\u0001\u0004\t9\"\u0001\u0005vg\u0016\u0014h*Y7f\u0003E\u0019G.Z1okB,\u00050Z2vi&|gn\u001d\u000b\u0005\u0003G\u0013y\u000fC\u0004\u0003rR\u0002\r!!\"\u0002\u000b\r|WO\u001c;\u0002\u001d\rdW-\u00198vaN+7o]5p]R!\u00111\u0015B|\u0011\u001d\u0011\t0\u000ea\u0001\u0003\u000b\u000bqcY1mGVd\u0017\r^3Ok6\u0014WM\u001d+p%\u0016lwN^3\u0015\r\u0005\u0015%Q`B\u0001\u0011\u001d\u0011yP\u000ea\u0001\u0003\u000b\u000b\u0001\u0002Z1uCNK'0\u001a\u0005\b\u0007\u00071\u0004\u0019AAC\u00031\u0011X\r^1j]\u0016$7+\u001b>f\u0003eA\u0015N^3UQJLg\r^*feZ,'O\r'jgR,g.\u001a:\u0011\u0005iD4c\u0001\u001d\u0004\fA\u0019am!\u0004\n\u0007\r=qM\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0007\u000f\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class HiveThriftServer2Listener
extends SparkListener
implements Logging {
    private final ElementTrackingStore kvstore;
    private final Option<HiveServer2> server;
    private final boolean live;
    private final ConcurrentHashMap<String, LiveSessionData> sessionList;
    private final ConcurrentHashMap<String, LiveExecutionData> executionList;
    private final ConcurrentHashMap<String, String> jobId2ExecId;
    private final ConcurrentHashMap<String, String> stageId2ExecId;
    private final ConcurrentHashMap<Object, Seq<Object>> jobId2StageIds;
    private final /* synthetic */ Tuple2 x$1;
    private final int retainedStatements;
    private final int retainedSessions;
    private final /* synthetic */ Tuple2 x$2;
    private final boolean progressEventEnable;
    private final long progressEventInterval;
    private final long liveUpdatePeriodNs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$4() {
        return HiveThriftServer2Listener$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<String, LiveSessionData> sessionList() {
        return this.sessionList;
    }

    private ConcurrentHashMap<String, LiveExecutionData> executionList() {
        return this.executionList;
    }

    private ConcurrentHashMap<String, String> jobId2ExecId() {
        return this.jobId2ExecId;
    }

    private ConcurrentHashMap<String, String> stageId2ExecId() {
        return this.stageId2ExecId;
    }

    private ConcurrentHashMap<Object, Seq<Object>> jobId2StageIds() {
        return this.jobId2StageIds;
    }

    private int retainedStatements() {
        return this.retainedStatements;
    }

    private int retainedSessions() {
        return this.retainedSessions;
    }

    private boolean progressEventEnable() {
        return this.progressEventEnable;
    }

    private long progressEventInterval() {
        return this.progressEventInterval;
    }

    private long liveUpdatePeriodNs() {
        return this.liveUpdatePeriodNs;
    }

    public boolean noLiveData() {
        return this.sessionList().isEmpty() && this.executionList().isEmpty();
    }

    private void writeOperationLog(String execId, String msg) {
        SparkOperationLogManager$.MODULE$.getOperationLog(execId).foreach((Function1 & Serializable & scala.Serializable)operationLog -> {
            HiveThriftServer2Listener.$anonfun$writeOperationLog$1(this, msg, operationLog);
            return BoxedUnit.UNIT;
        });
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        block0: {
            if (!this.live) break block0;
            this.server.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.stop();
                return BoxedUnit.UNIT;
            });
        }
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        block0: {
            String groupId;
            Properties properties = jobStart.properties();
            if (properties == null || (groupId = properties.getProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID())) == null) break block0;
            this.jobId2ExecId().put(((Object)BoxesRunTime.boxToInteger((int)jobStart.jobId())).toString(), groupId);
            jobStart.stageIds().foreach((Function1 & Serializable & scala.Serializable)stageId -> HiveThriftServer2Listener.$anonfun$onJobStart$1(this, groupId, BoxesRunTime.unboxToInt((Object)stageId)));
            this.jobId2StageIds().put(BoxesRunTime.boxToInteger((int)jobStart.jobId()), (Seq<Object>)jobStart.stageIds());
            this.updateJobDetails(((Object)BoxesRunTime.boxToInteger((int)jobStart.jobId())).toString(), (Seq<String>)((Seq)jobStart.stageIds().map((Function1 & Serializable & scala.Serializable)x$4 -> HiveThriftServer2Listener.$anonfun$onJobStart$2(BoxesRunTime.unboxToInt((Object)x$4)), Seq$.MODULE$.canBuildFrom())), groupId);
        }
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        block0: {
            LiveExecutionData exec;
            String execId;
            if (!this.progressEventEnable() || (execId = this.jobId2ExecId().get(((Object)BoxesRunTime.boxToInteger((int)jobEnd.jobId())).toString())) == null || (exec = this.executionList().get(execId)) == null) break block0;
            exec.finishedJobId().$plus$eq((Object)((Object)BoxesRunTime.boxToInteger((int)jobEnd.jobId())).toString());
            exec.finishedStageId().$plus$plus$eq((TraversableOnce)((TraversableLike)((TraversableLike)this.jobId2StageIds().get(BoxesRunTime.boxToInteger((int)jobEnd.jobId()))).filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)p -> exec.finishedStageId().contains((Object)((Object)BoxesRunTime.boxToInteger((int)p)).toString()))).map((Function1 & Serializable & scala.Serializable)x$5 -> HiveThriftServer2Listener.$anonfun$onJobEnd$2(BoxesRunTime.unboxToInt((Object)x$5)), Seq$.MODULE$.canBuildFrom()));
            this.jobId2ExecId().remove(((Object)BoxesRunTime.boxToInteger((int)jobEnd.jobId())).toString());
            this.updateLiveStore(exec, this.updateLiveStore$default$2());
        }
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        block0: {
            long now;
            LiveExecutionData exec;
            String execId;
            if (!this.progressEventEnable() || (execId = this.stageId2ExecId().get(((Object)BoxesRunTime.boxToInteger((int)taskEnd.stageId())).toString())) == null || (exec = this.executionList().get(execId)) == null || (now = System.currentTimeMillis()) - exec.progressEventTimestamp() <= this.progressEventInterval()) break block0;
            exec.progressEventTimestamp_$eq(now);
            this.writeOperationLog(execId, new StringBuilder(34).append("Running : ").append(execId).append(" => Job(").append(exec.finishedJobId().length()).append(" / ").append(exec.jobId().length()).append("), ").append("Stage(").append(exec.finishedStageId().length()).append(" / ").append(exec.stageId().length()).append(")").toString());
        }
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        block2: {
            LiveExecutionData exec;
            if (!this.progressEventEnable()) break block2;
            String stageId = ((Object)BoxesRunTime.boxToInteger((int)stageCompleted.stageInfo().stageId())).toString();
            String execId = this.stageId2ExecId().get(stageId);
            if (execId != null && (exec = this.executionList().get(execId)) != null) {
                exec.finishedStageId().$plus$eq((Object)stageId);
                this.stageId2ExecId().remove(stageId);
                long now = System.currentTimeMillis();
                if (now - exec.progressEventTimestamp() > this.progressEventInterval()) {
                    exec.progressEventTimestamp_$eq(now);
                }
                this.updateLiveStore(exec, this.updateLiveStore$default$2());
            }
        }
    }

    private void updateJobDetails(String jobId, Seq<String> stageIds, String groupId) {
        Seq execList = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.executionList().values()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$updateJobDetails$1(groupId, x$6)))).toSeq();
        if (execList.nonEmpty()) {
            execList.foreach((Function1 & Serializable & scala.Serializable)exec -> {
                HiveThriftServer2Listener.$anonfun$updateJobDetails$2(this, jobId, stageIds, exec);
                return BoxedUnit.UNIT;
            });
        } else {
            Iterable storeExecInfo = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.kvstore.view(ExecutionInfo.class)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$updateJobDetails$3(groupId, x$7)));
            storeExecInfo.foreach((Function1 & Serializable & scala.Serializable)exec -> {
                LiveExecutionData liveExec = this.getOrCreateExecution(exec.execId(), exec.statement(), exec.sessionId(), exec.startTimestamp(), exec.userName());
                liveExec.jobId().$plus$eq((Object)jobId.toString());
                this.updateStoreWithTriggerEnabled(liveExec);
                return this.executionList().remove(liveExec.execId());
            });
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerThriftServerSessionCreated) {
            SparkListenerThriftServerSessionCreated sparkListenerThriftServerSessionCreated = (SparkListenerThriftServerSessionCreated)sparkListenerEvent;
            this.onSessionCreated(sparkListenerThriftServerSessionCreated);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerSessionClosed) {
            SparkListenerThriftServerSessionClosed sparkListenerThriftServerSessionClosed = (SparkListenerThriftServerSessionClosed)sparkListenerEvent;
            this.onSessionClosed(sparkListenerThriftServerSessionClosed);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationStart) {
            SparkListenerThriftServerOperationStart sparkListenerThriftServerOperationStart = (SparkListenerThriftServerOperationStart)sparkListenerEvent;
            this.onOperationStart(sparkListenerThriftServerOperationStart);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationParsed) {
            SparkListenerThriftServerOperationParsed sparkListenerThriftServerOperationParsed = (SparkListenerThriftServerOperationParsed)sparkListenerEvent;
            this.onOperationParsed(sparkListenerThriftServerOperationParsed);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationCanceled) {
            SparkListenerThriftServerOperationCanceled sparkListenerThriftServerOperationCanceled = (SparkListenerThriftServerOperationCanceled)sparkListenerEvent;
            this.onOperationCanceled(sparkListenerThriftServerOperationCanceled);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationTimeout) {
            SparkListenerThriftServerOperationTimeout sparkListenerThriftServerOperationTimeout = (SparkListenerThriftServerOperationTimeout)sparkListenerEvent;
            this.onOperationTimeout(sparkListenerThriftServerOperationTimeout);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationError) {
            SparkListenerThriftServerOperationError sparkListenerThriftServerOperationError = (SparkListenerThriftServerOperationError)sparkListenerEvent;
            this.onOperationError(sparkListenerThriftServerOperationError);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationFinish) {
            SparkListenerThriftServerOperationFinish sparkListenerThriftServerOperationFinish = (SparkListenerThriftServerOperationFinish)sparkListenerEvent;
            this.onOperationFinished(sparkListenerThriftServerOperationFinish);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationClosed) {
            SparkListenerThriftServerOperationClosed sparkListenerThriftServerOperationClosed = (SparkListenerThriftServerOperationClosed)sparkListenerEvent;
            this.onOperationClosed(sparkListenerThriftServerOperationClosed);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void onSessionCreated(SparkListenerThriftServerSessionCreated e) {
        LiveSessionData session = this.getOrCreateSession(e.sessionId(), e.startTime(), e.ip(), e.userName());
        this.sessionList().put(e.sessionId(), session);
        this.updateLiveStore(session, this.updateLiveStore$default$2());
    }

    private void onSessionClosed(SparkListenerThriftServerSessionClosed e) {
        Option option = Option$.MODULE$.apply((Object)this.sessionList().get(e.sessionId()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveSessionData sessionData = (LiveSessionData)((Object)some.value());
            sessionData.finishTimestamp_$eq(e.finishTime());
            this.updateStoreWithTriggerEnabled(sessionData);
            this.sessionList().remove(e.sessionId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("onSessionClosed called with unknown session id: ").append(e.sessionId()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void onOperationStart(SparkListenerThriftServerOperationStart e) {
        LiveExecutionData executionData = this.getOrCreateExecution(e.id(), e.statement(), e.sessionId(), e.startTime(), e.userName());
        executionData.state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.STARTED());
        this.executionList().put(e.id(), executionData);
        executionData.groupId_$eq(e.groupId());
        this.updateLiveStore(executionData, this.updateLiveStore$default$2());
        Option option = Option$.MODULE$.apply((Object)this.sessionList().get(e.sessionId()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveSessionData sessionData = (LiveSessionData)((Object)some.value());
            sessionData.totalExecution_$eq(sessionData.totalExecution() + 1);
            this.updateLiveStore(sessionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("onOperationStart called with unknown session id: ").append(e.sessionId()).append(".").append("Regardless, the operation has been registered.").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void onOperationParsed(SparkListenerThriftServerOperationParsed e) {
        Option option = Option$.MODULE$.apply((Object)this.executionList().get(e.id()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.executePlan_$eq(e.executionPlan());
            executionData.state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.COMPILED());
            this.updateLiveStore(executionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("onOperationParsed called with unknown operation id: ").append(e.id()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void onOperationCanceled(SparkListenerThriftServerOperationCanceled e) {
        Option option = Option$.MODULE$.apply((Object)this.executionList().get(e.id()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.finishTimestamp_$eq(e.finishTime());
            executionData.state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.CANCELED());
            this.updateLiveStore(executionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("onOperationCanceled called with unknown operation id: ").append(e.id()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void onOperationTimeout(SparkListenerThriftServerOperationTimeout e) {
        Option option = Option$.MODULE$.apply((Object)this.executionList().get(e.id()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.finishTimestamp_$eq(e.finishTime());
            executionData.state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.TIMEDOUT());
            this.updateLiveStore(executionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("onOperationCanceled called with unknown operation id: ").append(e.id()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void onOperationError(SparkListenerThriftServerOperationError e) {
        Option option = Option$.MODULE$.apply((Object)this.executionList().get(e.id()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.finishTimestamp_$eq(e.finishTime());
            executionData.detail_$eq(e.errorMsg());
            executionData.state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.FAILED());
            this.updateLiveStore(executionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("onOperationError called with unknown operation id: ").append(e.id()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void onOperationFinished(SparkListenerThriftServerOperationFinish e) {
        Option option = Option$.MODULE$.apply((Object)this.executionList().get(e.id()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.finishTimestamp_$eq(e.finishTime());
            executionData.state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.FINISHED());
            if (this.progressEventEnable()) {
                this.writeOperationLog(e.id(), new StringBuilder(32).append("Finished: ").append(e.id()).append(" => Job(").append(executionData.finishedJobId().length()).append(" /").append(executionData.jobId().length()).append("), Stage(").append(executionData.finishedStageId().length()).append(" /").append(executionData.stageId().length()).append(")").toString());
            }
            this.updateLiveStore(executionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("onOperationFinished called with unknown operation id: ").append(e.id()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void onOperationClosed(SparkListenerThriftServerOperationClosed e) {
        Option option = Option$.MODULE$.apply((Object)this.executionList().get(e.id()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.closeTimestamp_$eq(e.closeTime());
            executionData.state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.CLOSED());
            this.updateStoreWithTriggerEnabled(executionData);
            if (this.progressEventEnable()) {
                this.executionList().remove(e.id()).jobId().foreach((Function1 & Serializable & scala.Serializable)s -> this.jobId2StageIds().remove(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s)).toInt())));
            }
            this.executionList().remove(e.id());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("onOperationClosed called with unknown operation id: ").append(e.id()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void updateStoreWithTriggerEnabled(LiveEntity entity) {
        entity.write(this.kvstore, System.nanoTime(), true);
    }

    public void updateLiveStore(LiveEntity entity, boolean trigger) {
        block0: {
            long now = System.nanoTime();
            if (!this.live || this.liveUpdatePeriodNs() < 0L || now - entity.lastWriteTime() <= this.liveUpdatePeriodNs()) break block0;
            entity.write(this.kvstore, now, trigger);
        }
    }

    public boolean updateLiveStore$default$2() {
        return false;
    }

    private void flush(Function1<LiveEntity, BoxedUnit> entityFlushFunc) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.sessionList().values()).asScala()).foreach(entityFlushFunc);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.executionList().values()).asScala()).foreach(entityFlushFunc);
    }

    private LiveSessionData getOrCreateSession(String sessionId, long startTime, String ip, String username) {
        return this.sessionList().computeIfAbsent(sessionId, x$8 -> new LiveSessionData(sessionId, startTime, ip, username));
    }

    private LiveExecutionData getOrCreateExecution(String execId, String statement, String sessionId, long startTimestamp, String userName) {
        return this.executionList().computeIfAbsent(execId, x$9 -> new LiveExecutionData(execId, statement, sessionId, startTimestamp, userName));
    }

    private void cleanupExecutions(long count) {
        long countToDelete = this.calculateNumberToRemove(count, this.retainedStatements());
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(ExecutionInfo.class).index("finishTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable & scala.Serializable)j -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$cleanupExecutions$1(j)));
        toDelete.foreach((Function1 & Serializable & scala.Serializable)j -> {
            this.kvstore.delete(j.getClass(), (Object)j.execId());
            return BoxedUnit.UNIT;
        });
    }

    private void cleanupSession(long count) {
        long countToDelete = this.calculateNumberToRemove(count, this.retainedSessions());
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(SessionInfo.class).index("finishTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable & scala.Serializable)j -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$cleanupSession$1(j)));
        toDelete.foreach((Function1 & Serializable & scala.Serializable)j -> {
            this.kvstore.delete(j.getClass(), (Object)j.sessionId());
            return BoxedUnit.UNIT;
        });
    }

    private long calculateNumberToRemove(long dataSize, long retainedSize) {
        return dataSize > retainedSize ? package$.MODULE$.max(retainedSize / 10L, dataSize - retainedSize) : 0L;
    }

    public static final /* synthetic */ void $anonfun$writeOperationLog$1(HiveThriftServer2Listener $this, String msg$1, OperationLog operationLog) {
        OperationLog.setCurrentOperationLog((OperationLog)operationLog);
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg$1);
        OperationLog.removeCurrentOperationLog();
    }

    public static final /* synthetic */ String $anonfun$onJobStart$1(HiveThriftServer2Listener $this, String groupId$1, int stageId) {
        return $this.stageId2ExecId().put(((Object)BoxesRunTime.boxToInteger((int)stageId)).toString(), groupId$1);
    }

    public static final /* synthetic */ String $anonfun$onJobStart$2(int x$4) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$4)).toString();
    }

    public static final /* synthetic */ String $anonfun$onJobEnd$2(int x$5) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$5)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$updateJobDetails$1(String groupId$2, LiveExecutionData x$6) {
        String string = x$6.groupId();
        String string2 = groupId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateJobDetails$2(HiveThriftServer2Listener $this, String jobId$1, Seq stageIds$1, LiveExecutionData exec) {
        exec.jobId().$plus$eq((Object)jobId$1.toString());
        exec.stageId().$plus$plus$eq((TraversableOnce)stageIds$1);
        $this.updateLiveStore(exec, $this.updateLiveStore$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$updateJobDetails$3(String groupId$2, ExecutionInfo x$7) {
        String string = x$7.groupId();
        String string2 = groupId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$cleanupExecutions$1(ExecutionInfo j) {
        return j.finishTimestamp() != 0L;
    }

    public static final /* synthetic */ boolean $anonfun$cleanupSession$1(SessionInfo j) {
        return j.finishTimestamp() != 0L;
    }

    public HiveThriftServer2Listener(ElementTrackingStore kvstore, SparkConf sparkConf, Option<HiveServer2> server, boolean live) {
        this.kvstore = kvstore;
        this.server = server;
        this.live = live;
        Logging.$init$((Logging)this);
        this.sessionList = new ConcurrentHashMap();
        this.executionList = new ConcurrentHashMap();
        this.jobId2ExecId = new ConcurrentHashMap();
        this.stageId2ExecId = new ConcurrentHashMap();
        this.jobId2StageIds = new ConcurrentHashMap();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)sparkConf.get(SQLConf$.MODULE$.THRIFTSERVER_UI_STATEMENT_LIMIT())), BoxesRunTime.unboxToInt((Object)sparkConf.get(SQLConf$.MODULE$.THRIFTSERVER_UI_SESSION_LIMIT())));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int retainedStatements = sp2._1$mcI$sp();
        int retainedSessions = sp2._2$mcI$sp();
        int n = retainedStatements;
        int n2 = retainedSessions;
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(n, n2);
        this.x$1 = sp3;
        this.retainedStatements = this.x$1._1$mcI$sp();
        this.retainedSessions = this.x$1._2$mcI$sp();
        Tuple2.mcZJ.sp sp4 = new Tuple2.mcZJ.sp(BoxesRunTime.unboxToBoolean((Object)sparkConf.get(SQLConf$.MODULE$.THRIFTSERVER_PROGRESS_EVENT_ENABLED())), BoxesRunTime.unboxToLong((Object)sparkConf.get(SQLConf$.MODULE$.THRIFTSERVER_PROGRESS_EVENT_INTERVAL())));
        if (sp4 == null) {
            throw new MatchError((Object)sp4);
        }
        boolean progressEventEnable = sp4._1$mcZ$sp();
        long progressEventInterval = sp4._2$mcJ$sp();
        boolean bl = progressEventEnable;
        long l = progressEventInterval;
        Tuple2.mcZJ.sp sp5 = new Tuple2.mcZJ.sp(bl, l);
        this.x$2 = sp5;
        this.progressEventEnable = this.x$2._1$mcZ$sp();
        this.progressEventInterval = this.x$2._2$mcJ$sp();
        this.liveUpdatePeriodNs = live ? BoxesRunTime.unboxToLong((Object)sparkConf.get(Status$.MODULE$.LIVE_ENTITY_UPDATE_PERIOD())) : -1L;
        kvstore.addTrigger(SessionInfo.class, (long)this.retainedSessions(), (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)count -> this.cleanupSession(count));
        kvstore.addTrigger(ExecutionInfo.class, (long)this.retainedStatements(), (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)count -> this.cleanupExecutions(count));
        kvstore.onFlush((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if ($this.live) break block0;
                this.flush((Function1<LiveEntity, BoxedUnit>)(Function1 & Serializable & scala.Serializable)entity -> {
                    this.updateStoreWithTriggerEnabled(entity);
                    return BoxedUnit.UNIT;
                });
            }
        });
    }
}

